/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.eval;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.statet.internal.r.debug.core.RDebugCorePlugin;
import org.eclipse.statet.internal.r.debug.core.model.BasicRElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RMainThread;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.r.core.tool.TmpUtils;
import org.eclipse.statet.r.debug.core.REvaluationResult;
import org.eclipse.statet.r.debug.core.RValue;
import org.eclipse.statet.r.debug.core.RVariable;

@NonNullByDefault
public final class EvaluationResult
implements REvaluationResult {
    private final String expression;
    private final RMainThread thread;
    private final int status;
    private final @Nullable BasicRElementVariable variable;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TmpUtils.Item tmpItem;
    private final @Nullable ImList<@NonNull String> errorMessages;
    private int lockCounter;

    public EvaluationResult(String expression, RMainThread thread, BasicRElementVariable variable, TmpUtils.Item tmpItem) {
        this.expression = expression;
        this.thread = thread;
        this.status = 0;
        this.variable = variable;
        this.tmpItem = tmpItem;
        this.errorMessages = null;
        this.lockCounter = 1;
    }

    public EvaluationResult(String expression, RMainThread thread, int status, String errorMessage) {
        this.expression = expression;
        this.thread = thread;
        this.status = status;
        this.variable = null;
        this.tmpItem = null;
        this.errorMessages = ImCollections.newList((Object)errorMessage);
        this.lockCounter = 1;
    }

    public EvaluationResult(String expression, RMainThread thread) {
        this.expression = expression;
        this.thread = thread;
        this.status = 24;
        this.variable = null;
        this.tmpItem = null;
        this.errorMessages = null;
        this.lockCounter = 1;
    }

    public String getExpressionText() {
        return this.expression;
    }

    @Override
    public RMainThread getThread() {
        return this.thread;
    }

    public int getStatus() {
        return this.status;
    }

    public @Nullable RVariable getVariable() {
        return this.variable;
    }

    public @Nullable RValue getValue() {
        BasicRElementVariable variable = this.variable;
        return variable != null ? variable.getCurrentValue() : null;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TmpUtils.Item getTmpItem() {
        return this.tmpItem;
    }

    public @Nullable ImList<@NonNull String> getMessages() {
        return this.errorMessages;
    }

    public synchronized void lock() {
        ++this.lockCounter;
    }

    public synchronized void free() {
        --this.lockCounter;
        if (this.lockCounter < 0) {
            this.thread.getExpressionManager().scheduleClean();
        }
    }

    public synchronized boolean isLocked() {
        return this.lockCounter > 0;
    }

    public void reset(int stamp, ProgressMonitor m) {
        BasicRElementVariable variable = this.variable;
        if (variable != null) {
            try {
                variable.reset(stamp);
                variable.getValue(m);
            }
            catch (DebugException e) {
                RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", "An error occurred when refreshing expression result.", (Throwable)e));
            }
        }
    }
}

