/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class SimpleCompletionProposal<TContext extends AssistInvocationContext>
extends SourceProposal<TContext> {
    private final String replacementString;
    private @Nullable String description;

    public SimpleCompletionProposal(SourceProposal.ProposalParameters<? extends TContext> parameters, String replacementString, @Nullable String description) {
        super(parameters);
        this.replacementString = replacementString;
        this.description = description;
    }

    public SimpleCompletionProposal(SourceProposal.ProposalParameters<? extends TContext> parameters, String replacementString) {
        super(parameters);
        this.replacementString = replacementString;
    }

    @Override
    protected final String getName() {
        return this.replacementString;
    }

    @Override
    public String getSortingString() {
        return this.replacementString;
    }

    @Override
    public String getDisplayString() {
        return this.getStyledDisplayString().getString();
    }

    @Override
    protected StyledString computeStyledText() {
        StyledString styledText = new StyledString(this.getName());
        String description = this.description;
        if (description != null) {
            styledText.append("\u2002\u2013\u2002", StyledString.QUALIFIER_STYLER);
            styledText.append(description, StyledString.QUALIFIER_STYLER);
        }
        return styledText;
    }

    @Override
    public Image getImage() {
        return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/obj/dummy");
    }

    @Override
    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException, BadPartitioningException {
        Object context;
        IDocument document;
        ITypedRegion partition;
        int end = Math.max(caretOffset, selection.x + selection.y);
        if (overwrite && (replacementOffset == (partition = TextUtils.getPartition((IDocument)(document = ((AssistInvocationContext)(context = this.getInvocationContext())).getDocument()), (DocContentSections)((AssistInvocationContext)context).getEditor().getDocumentContentInfo(), (int)end, (boolean)true)).getOffset() || end > partition.getOffset())) {
            end = TextUtils.findCommonWord2End((IDocument)document, (int)end, (int)(partition.getOffset() + partition.getLength()));
        }
        return end - replacementOffset;
    }
}

