/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ast.core.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.internal.ltk.core.LtkCorePlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.impl.AbstractSourceIssueReporter;

@NonNullByDefault
public class AbstractAstProblemReporter
extends AbstractSourceIssueReporter {
    protected static final int MASK = 0xFFFFFF;
    private final boolean reportSubsequent = false;

    public AbstractAstProblemReporter(String modelTypeId) {
        super(modelTypeId);
    }

    protected final boolean requiredCheck(int code) {
        return code != 0 && (code & 0x800000) == 0;
    }

    protected void handleCommonCodes(AstNode node, int code) throws BadLocationException, InvocationTargetException {
        switch (code & 0xF00) {
            case 3840: {
                this.addProblem(2, code, "Error when parsing source code. Please submit a bug report with a code snippet / log entry.", node.getStartOffset(), node.getStartOffset());
                return;
            }
        }
        this.handleUnknownCodes(node);
    }

    protected void handleUnknownCodes(AstNode node) {
        int code = node.getStatusCode() & 0xFFFFFF;
        StringBuilder sb = new StringBuilder();
        sb.append("Unhandled/Unknown code of AST node (").append(this.getModelTypeId()).append("):");
        sb.append('\n');
        sb.append("  code= ").append(String.format("0x%1$08X", code));
        sb.append('\n');
        sb.append("  node= ").append(node);
        sb.append(" (").append(node.getStartOffset()).append(", ").append(node.getLength()).append(')');
        sb.append('\n');
        SourceContent sourceContent = this.getSourceContent();
        if (sourceContent != null) {
            TextLineInformation lines = sourceContent.getStringLines();
            int line = lines.getLineOfOffset(node.getStartOffset() - sourceContent.getStartOffset());
            sb.append("  Line ").append(line + 1);
            sb.append('\n');
            int firstLine = Math.max(0, line - 2);
            int lastLine = Math.min(lines.getNumberOfLines() - 1, lines.getLineOfOffset(node.getEndOffset() - sourceContent.getStartOffset()) + 2);
            sb.append("  source (line ").append(firstLine + 1).append('-').append(lastLine + 1).append(")= \n");
            sb.append(sourceContent.getString(), lines.getStartOffset(firstLine), lines.getEndOffset(lastLine));
        }
        LtkCorePlugin.log((IStatus)new Status(2, "org.eclipse.statet.ltk.core", sb.toString()));
    }
}

