/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.string;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.string.CharPair;

@NonNullByDefault
public final class Chars {
    private static final byte[] U_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final CharPair CURLY_BRACKETS = new CharPair('{', '}');
    public static final CharPair ROUND_BRACKETS = new CharPair('(', ')');
    public static final CharPair SQUARE_BRACKETS = new CharPair('[', ']');

    public static final String getAsciiControlAbbr(char c) {
        return switch (c) {
            case '\u0000' -> "NUL";
            case '\u0001' -> "SOH";
            case '\u0002' -> "STX";
            case '\u0003' -> "ETX";
            case '\u0004' -> "EOT";
            case '\u0005' -> "ENQ";
            case '\u0006' -> "ACK";
            case '\u0007' -> "BEL";
            case '\b' -> "BS";
            case '\t' -> "HT";
            case '\n' -> "LF";
            case '\u000b' -> "VT";
            case '\f' -> "FF";
            case '\r' -> "CR";
            case '\u000e' -> "SO";
            case '\u000f' -> "SI";
            case '\u0010' -> "DLE";
            case '\u0011' -> "DC1";
            case '\u0012' -> "DC2";
            case '\u0013' -> "DC3";
            case '\u0014' -> "DC4";
            case '\u0015' -> "NAX";
            case '\u0016' -> "SYN";
            case '\u0017' -> "ETB";
            case '\u0018' -> "CAN";
            case '\u0019' -> "EM";
            case '\u001a' -> "SUB";
            case '\u001b' -> "ESC";
            case '\u001c' -> "FS";
            case '\u001d' -> "GS";
            case '\u001e' -> "RS";
            case '\u001f' -> "US";
            case ' ' -> "SP";
            case '\u007f' -> "DEL";
            default -> throw new IllegalArgumentException(String.format("c= 0x%1$04X", c));
        };
    }

    public static final char getAsciiControlSymbol(char c) {
        return switch (c) {
            case '\u0000' -> '\u2400';
            case '\u0001' -> '\u2401';
            case '\u0002' -> '\u2402';
            case '\u0003' -> '\u2403';
            case '\u0004' -> '\u2404';
            case '\u0005' -> '\u2405';
            case '\u0006' -> '\u2406';
            case '\u0007' -> '\u2407';
            case '\b' -> '\u2408';
            case '\t' -> '\u2409';
            case '\n' -> '\u240a';
            case '\u000b' -> '\u240b';
            case '\f' -> '\u240c';
            case '\r' -> '\u240d';
            case '\u000e' -> '\u240e';
            case '\u000f' -> '\u240f';
            case '\u0010' -> '\u2410';
            case '\u0011' -> '\u2411';
            case '\u0012' -> '\u2412';
            case '\u0013' -> '\u2413';
            case '\u0014' -> '\u2414';
            case '\u0015' -> '\u2415';
            case '\u0016' -> '\u2416';
            case '\u0017' -> '\u2417';
            case '\u0018' -> '\u2418';
            case '\u0019' -> '\u2419';
            case '\u001a' -> '\u241a';
            case '\u001b' -> '\u241b';
            case '\u001c' -> '\u241c';
            case '\u001d' -> '\u241d';
            case '\u001e' -> '\u241e';
            case '\u001f' -> '\u241f';
            case ' ' -> '\u2420';
            case '\u007f' -> '\u2421';
            default -> throw new IllegalArgumentException(String.format("c= 0x%1$04X", c));
        };
    }

    public static String formatCodePoint(int cp) {
        int nDigits = Math.max((39 - Integer.numberOfLeadingZeros(cp)) / 8 * 2, 4);
        byte[] latin1 = new byte[2 + nDigits];
        latin1[0] = 85;
        latin1[1] = 43;
        int i = latin1.length;
        do {
            latin1[--i] = U_DIGITS[cp & 0xF];
            cp >>>= 4;
        } while (i > 2);
        return new String(latin1, 0, 0, latin1.length);
    }

    private Chars() {
    }
}

