/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.statet.ecommons.graphics.core.ColorDef;
import org.eclipse.statet.ecommons.graphics.core.HSVColorDef;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

@NonNullByDefault
public class HSVSelector
extends Canvas
implements IObjValueWidget<ColorDef> {
    private static final int INITIAL = 1;
    private static final @Nullable Image[] BASE_CACHE = new Image[10];
    private int size = 8 + LayoutUtils.defaultHSpacing() * 30;
    private HSVColorDef value = new HSVColorDef(0.0f, 1.0f, 1.0f);
    private int flags;
    private final CopyOnWriteIdentityListSet<IObjValueListener<ColorDef>> valueListeners = new CopyOnWriteIdentityListSet();
    private Color backgroundColor;

    private static float distance(float x, float y) {
        return (float)Math.sqrt(x * x + y * y);
    }

    private static float save01(float value) {
        if (value <= 0.0f) {
            return 0.0f;
        }
        if (value >= 1.0f) {
            return 1.0f;
        }
        return value;
    }

    private static Color createColor(Device device, float hue, float saturation, float value) {
        float r;
        float g;
        float b;
        if (saturation == 0.0f) {
            g = b = value;
            r = b;
        } else {
            if (hue == 1.0f) {
                hue = 0.0f;
            }
            int i = (int)(hue *= 6.0f);
            float f = hue - (float)i;
            float p = value * (1.0f - saturation);
            float q = value * (1.0f - saturation * f);
            float t = value * (1.0f - saturation * (1.0f - f));
            switch (i) {
                case 0: {
                    r = value;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = value;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = value;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = value;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = value;
                    break;
                }
                default: {
                    r = value;
                    g = p;
                    b = q;
                }
            }
        }
        return new Color((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5));
    }

    private static void plotPoint(GC gc, int x, int y, Color color) {
        if (color != null) {
            gc.setForeground(color);
        }
        gc.drawLine(x - 1, y, x + 1, y);
        gc.drawLine(x, y - 1, x, y + 1);
    }

    private static void plotLine(GC gc, int xMin, int xMax, float a, float b, float c, Color color) {
        if (color != null) {
            gc.setForeground(color);
        }
        float m = -a / b;
        float t = -c / b;
        int x = xMin;
        while (x <= xMax) {
            float y = m * (float)x + t;
            gc.drawPoint(x, Math.round(y));
            ++x;
        }
    }

    private static Image getBaseImage(Data data, Display display) {
        Image image;
        int i = 0;
        while (i < BASE_CACHE.length) {
            image = BASE_CACHE[i];
            if (image == null) break;
            if (image.getImageData().width == data.size) {
                return image;
            }
            ++i;
        }
        if (i == BASE_CACHE.length) {
            image = BASE_CACHE[BASE_CACHE.length - 1];
            HSVSelector.BASE_CACHE[HSVSelector.BASE_CACHE.length - 1] = null;
            image.dispose();
        }
        System.arraycopy(BASE_CACHE, 0, BASE_CACHE, 1, BASE_CACHE.length - 1);
        HSVSelector.BASE_CACHE[0] = image = data.createBaseImage(display);
        return image;
    }

    public HSVSelector(Composite parent, Color backgroundColor) {
        super(parent, 0x20000000);
        this.backgroundColor = backgroundColor;
        SWTListener listener = new SWTListener();
        this.addPaintListener(listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(5, listener);
    }

    public void setSize(int size) {
        this.size = size;
    }

    private boolean doSetValue(HSVColorDef newValue, int time, int flags) {
        HSVColorDef oldValue = this.value;
        if (oldValue.equals((Object)newValue) && (flags | this.flags & 1) == 0) {
            return false;
        }
        this.value = newValue;
        this.flags &= 0xFFFFFFFE;
        ObjValueEvent<HSVColorDef> event = new ObjValueEvent<HSVColorDef>(this, time, 0, oldValue, newValue, flags);
        for (IObjValueListener listener : this.valueListeners) {
            event.newValue = newValue;
            listener.valueChanged(event);
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
        return true;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = this.size;
        int height = this.size;
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public Class<ColorDef> getValueType() {
        return ColorDef.class;
    }

    @Override
    public void addValueListener(IObjValueListener<ColorDef> listener) {
        this.valueListeners.add((Object)((IObjValueListener)ObjectUtils.nonNullAssert(listener)));
    }

    @Override
    public void removeValueListener(IObjValueListener<ColorDef> listener) {
        this.valueListeners.remove(listener);
    }

    @Override
    public HSVColorDef getValue(int idx) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        return this.value;
    }

    @Override
    public void setValue(int idx, ColorDef value) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        if (value.getType() == "hsv") {
            this.doSetValue((HSVColorDef)value, 0, 0);
        } else {
            this.doSetValue(new HSVColorDef(value), 0, 0);
        }
    }

    private static final class Data {
        private static final float TRIANGLE_RATIO = 0.78f;
        private static final float TRIANGLE_ALPHA = -1.0f;
        private final int size;
        private final int center;
        private final float outer;
        private final float inner;
        private final Color backgroundColor;
        private final float h;
        private final float xh1;
        private final float yh1;
        private final float x11;
        private final float y11;
        private final float x01;
        private final float y01;
        private final float x10;
        private final float y10;

        public Data(int size, Color backgroundColor, float hue) {
            this.size = size;
            this.center = size / 2;
            this.outer = this.center;
            this.inner = (int)(this.outer * 0.78f);
            this.backgroundColor = backgroundColor;
            this.h = hue;
            float[] xy1 = this.hue_xy1(this.h);
            this.xh1 = xy1[0];
            this.yh1 = xy1[1];
            this.x11 = (float)this.center + this.inner * this.xh1;
            this.y11 = (float)this.center + this.inner * this.yh1;
            xy1 = this.hue_xy1((double)this.h + 0.3333333333333333);
            this.x01 = (float)this.center + this.inner * xy1[0];
            this.y01 = (float)this.center + this.inner * xy1[1];
            xy1 = this.hue_xy1((double)this.h - 0.3333333333333333);
            this.x10 = (float)this.center + this.inner * xy1[0];
            this.y10 = (float)this.center + this.inner * xy1[1];
        }

        public final int x0(int x) {
            return x - this.center;
        }

        public final int y0(int y) {
            return y - this.center;
        }

        public final float xy0_d(int x0, int y0) {
            return (float)Math.sqrt(x0 * x0 + y0 * y0);
        }

        public final float xy0_hue(int x0, int y0) {
            float hue = (float)(Math.atan2(y0, x0) / (Math.PI * 2));
            if ((hue += 0.25f) < 0.0f) {
                hue += 1.0f;
            }
            return hue;
        }

        public final float[] hue_xy1(double hue) {
            double a = (hue - 0.25) * (Math.PI * 2);
            return new float[]{(float)Math.cos(a), (float)Math.sin(a)};
        }

        public HSVColorDef svColor(int x, int y) {
            float v;
            float s;
            float a_01_11 = this.y11 - this.y01;
            float b_01_11 = -(this.x11 - this.x01);
            float c_01_11 = -(a_01_11 * this.x11 + b_01_11 * this.y11);
            float av = (float)y - this.y10;
            float bv = -((float)x - this.x10);
            float cv = -(av * (float)x + bv * (float)y);
            if (a_01_11 < -4.0f || a_01_11 > 4.0f) {
                float yq = (av / a_01_11 * c_01_11 - cv) / (bv - av / a_01_11 * b_01_11);
                s = (yq - this.y01) / a_01_11;
                v = ((float)y - this.y10) / (yq - this.y10);
            } else {
                float yq = (a_01_11 / av * cv - c_01_11) / (b_01_11 - a_01_11 / av * bv);
                float xq = -(bv * yq + cv) / av;
                s = (xq - this.x01) / (this.x11 - this.x01);
                v = ((float)x - this.x10) / (xq - this.x10);
            }
            return new HSVColorDef(this.h, HSVSelector.save01(s), HSVSelector.save01(v));
        }

        public int[] sv_xy(float s, float v) {
            float xq = this.x01 + s * (this.x11 - this.x01);
            float yq = this.y01 + s * (this.y11 - this.y01);
            float x = this.x10 + v * (xq - this.x10);
            float y = this.y10 + v * (yq - this.y10);
            return new int[]{Math.round(x), Math.round(y)};
        }

        private Image createBaseImage(Display display) {
            Image image = new Image((Device)display, this.size, this.size);
            GC gc = new GC((Drawable)image);
            try {
                gc.setBackground(this.backgroundColor);
                gc.fillRectangle(0, 0, this.size, this.size);
                gc.setAdvanced(true);
                gc.setAntialias(0);
                int currentAlpha = 255;
                float in = this.inner + 1.0f;
                int y = 0;
                while (y < this.size) {
                    int x = 0;
                    while (x < this.size) {
                        block11: {
                            int alpha;
                            float a;
                            int y0;
                            int x0;
                            block12: {
                                x0 = this.x0(x);
                                float d = this.xy0_d(x0, y0 = this.y0(y));
                                a = this.outer - d;
                                if (a < 0.0f) break block11;
                                if (!(a > 1.0f)) break block12;
                                a = d - in;
                                if (a < 0.0f) break block11;
                                if (a > 1.0f) {
                                    a = 1.0f;
                                }
                            }
                            if ((alpha = (int)(a * 255.0f)) != currentAlpha) {
                                currentAlpha = alpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.setForeground(HSVSelector.createColor((Device)display, this.xy0_hue(x0, y0), 1.0f, 1.0f));
                            gc.drawPoint(x, y);
                        }
                        ++x;
                    }
                    ++y;
                }
            }
            finally {
                gc.dispose();
            }
            return image;
        }

        private Image createFullImage(Display display) {
            Image image = new Image((Device)display, HSVSelector.getBaseImage(this, display), 0);
            if (this.h < 0.0f) {
                return image;
            }
            GC gc = new GC((Drawable)image);
            try {
                gc.setAdvanced(true);
                gc.setAntialias(0);
                int currentAlpha = 255;
                int xMin = Math.min((int)Math.ceil(this.x11), Math.min((int)Math.ceil(this.x01), (int)Math.ceil(this.x10))) - 1;
                int xMax = Math.max((int)Math.floor(this.x11), Math.max((int)Math.floor(this.x01), (int)Math.floor(this.x10))) + 1;
                int yMin = Math.min((int)Math.ceil(this.y11), Math.min((int)Math.ceil(this.y01), (int)Math.ceil(this.y10))) - 1;
                int yMax = Math.max((int)Math.floor(this.y11), Math.max((int)Math.floor(this.y01), (int)Math.floor(this.y10))) + 1;
                float a = this.y11 - this.y01;
                float b = -(this.x11 - this.x01);
                float d = HSVSelector.distance(a, b);
                float a_01_11 = a / d;
                float b_01_11 = b / d;
                float c_01_11 = -(a * this.x11 + b * this.y11) / d;
                float a2 = this.y01 - this.y10;
                float b2 = -(this.x01 - this.x10);
                float d2 = HSVSelector.distance(a2, b2);
                float a_10_01 = a2 / d2;
                float b_10_01 = b2 / d2;
                float c_10_01 = -(a2 * this.x01 + b2 * this.y01) / d2;
                float a3 = this.y10 - this.y11;
                float b3 = -(this.x10 - this.x11);
                float d3 = HSVSelector.distance(a3, b3);
                float a_11_10 = a3 / d3;
                float b_11_10 = b3 / d3;
                float c_11_10 = -(a3 * this.x10 + b3 * this.y10) / d3;
                int y = yMin;
                while (y <= yMax) {
                    float av = (float)y - this.y10;
                    float av_as_cs = av / a_01_11 * c_01_11;
                    float av_as_bs = av / a_01_11 * b_01_11;
                    int x = xMin;
                    while (x <= xMax) {
                        block17: {
                            int alpha;
                            float v;
                            float s;
                            float min;
                            block19: {
                                float d4;
                                block18: {
                                    block16: {
                                        min = 0.0f;
                                        d4 = a_01_11 * (float)x + b_01_11 * (float)y + c_01_11;
                                        if (!(d4 < 0.0f)) break block16;
                                        if (d4 < -1.0f) break block17;
                                        if (d4 < min) {
                                            min = d4;
                                        }
                                    }
                                    if (!((d4 = a_10_01 * (float)x + b_10_01 * (float)y + c_10_01) < 0.0f)) break block18;
                                    if (d4 < -1.0f) break block17;
                                    if (d4 < min) {
                                        min = d4;
                                    }
                                }
                                if (!((d4 = a_11_10 * (float)x + b_11_10 * (float)y + c_11_10) < 0.0f)) break block19;
                                if (d4 < -1.0f) break block17;
                                if (d4 < min) {
                                    min = d4;
                                }
                            }
                            float bv = -((float)x - this.x10);
                            float cv = -(av * (float)x + bv * (float)y);
                            if (a_01_11 < -4.0f || a_01_11 > 4.0f) {
                                yq = (av_as_cs - cv) / (bv - av_as_bs);
                                s = (yq - this.y01) / a_01_11;
                                v = ((float)y - this.y10) / (yq - this.y10);
                            } else {
                                yq = (a_01_11 / av * cv - c_01_11) / (b_01_11 - a_01_11 / av * bv);
                                float xq = -(bv * yq + cv) / av;
                                s = (xq - this.x01) / (this.x11 - this.x01);
                                v = ((float)x - this.x10) / (xq - this.x10);
                            }
                            int n = alpha = min >= 0.0f ? 255 : (int)((1.0f + min) * 255.0f);
                            if (alpha != currentAlpha) {
                                currentAlpha = alpha;
                                gc.setAlpha(currentAlpha);
                            }
                            gc.setForeground(HSVSelector.createColor((Device)display, this.h, HSVSelector.save01(s), HSVSelector.save01(v)));
                            gc.drawPoint(x, y);
                        }
                        ++x;
                    }
                    ++y;
                }
            }
            finally {
                gc.dispose();
            }
            return image;
        }

        public void drawTriangle(GC gc) {
            int[] xy = new int[]{Math.round(this.x11), Math.round(this.y11), Math.round(this.x01), Math.round(this.y01), Math.round(this.x10), Math.round(this.y10)};
            gc.drawPolygon(xy);
        }
    }

    private class SWTListener
    implements PaintListener,
    Listener {
        private static final int TRACK_HUE = 1;
        private static final int TRACK_SV = 2;
        private @Nullable Data data;
        private @Nullable Image image;
        private int mouseState;

        private SWTListener() {
        }

        public void handleEvent(Event event) {
            Data data = this.data;
            switch (event.type) {
                case 3: {
                    if (data != null) {
                        int y0;
                        int x0 = data.x0(event.x);
                        float d = data.xy0_d(x0, y0 = data.y0(event.y));
                        if (d > data.inner) {
                            HSVSelector.this.doSetValue(new HSVColorDef(data.xy0_hue(x0, y0), HSVSelector.this.value.getSaturation(), HSVSelector.this.value.getValue()), event.time, 0);
                            this.mouseState = 1;
                        } else {
                            HSVSelector.this.doSetValue(data.svColor(event.x, event.y), event.time, 0);
                            this.mouseState = 2;
                        }
                    }
                    return;
                }
                case 4: {
                    this.mouseState = 0;
                    return;
                }
                case 5: {
                    if (data != null) {
                        switch (this.mouseState) {
                            case 1: {
                                HSVSelector.this.doSetValue(new HSVColorDef(data.xy0_hue(data.x0(event.x), data.y0(event.y)), HSVSelector.this.value.getSaturation(), HSVSelector.this.value.getValue()), event.time, 0);
                                break;
                            }
                            case 2: {
                                HSVSelector.this.doSetValue(data.svColor(event.x, event.y), event.time, 0);
                            }
                        }
                    }
                    return;
                }
            }
        }

        public void paintControl(PaintEvent e) {
            Rectangle clientArea = HSVSelector.this.getClientArea();
            int size = Math.min(clientArea.width, clientArea.height);
            if (HSVSelector.this.size > 0 && HSVSelector.this.size < size) {
                size = HSVSelector.this.size;
            }
            Data data = this.data;
            Image image = this.image;
            if (data == null || data.size != size || data.h != HSVSelector.this.value.getHue()) {
                if (image != null) {
                    this.image = null;
                    image.dispose();
                    image = null;
                }
                this.data = data = new Data(size, HSVSelector.this.backgroundColor, HSVSelector.this.value.getHue());
            }
            GC gc = e.gc;
            gc.setAdvanced(true);
            gc.setAntialias(0);
            int currentAlpha = 255;
            gc.setAlpha(255);
            gc.setBackground(HSVSelector.this.backgroundColor);
            gc.fillRectangle(clientArea);
            if (image == null) {
                this.image = image = data.createFullImage(e.display);
            }
            gc.drawImage(image, 0, 0);
            gc.setLineWidth(1);
            gc.setAntialias(1);
            gc.setForeground(e.display.getSystemColor(2));
            gc.drawLine(Math.round((float)data.center + data.outer * data.xh1), Math.round((float)data.center + data.outer * data.yh1), Math.round(data.x11), Math.round(data.y11));
            if ((double)HSVSelector.this.value.getValue() < 0.5) {
                gc.setForeground(e.display.getSystemColor(1));
            }
            int[] xy = data.sv_xy(HSVSelector.this.value.getSaturation(), HSVSelector.this.value.getValue());
            gc.drawOval(xy[0] - 1, xy[1] - 1, 3, 3);
        }
    }
}

