/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ByteArrayCombinerStream
extends InputStream {
    private final ArrayList<byte[]> arrays;
    private final long specifiedLength;
    private long gOffset = 0L;
    private int arrayIndex = 0;
    private byte[] curArray;
    private int off = 0;

    public ByteArrayCombinerStream(ArrayList<byte[]> arraysIn, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("Length cannot be negative: " + length);
        }
        this.specifiedLength = length;
        long tmpRemaining = length;
        if (arraysIn != null && arraysIn.size() > 0) {
            byte[] tmpArray;
            int arrayCount = arraysIn.size();
            this.arrays = new ArrayList(arrayCount);
            for (int i = 0; i < arrayCount && tmpRemaining > 0L; tmpRemaining -= (long)tmpArray.length, ++i) {
                tmpArray = arraysIn.get(i);
                if (tmpRemaining < (long)tmpArray.length) {
                    byte[] shrunkArray = new byte[(int)tmpRemaining];
                    System.arraycopy(tmpArray, 0, shrunkArray, 0, shrunkArray.length);
                    this.arrays.add(shrunkArray);
                    tmpRemaining -= (long)shrunkArray.length;
                    break;
                }
                this.arrays.add(tmpArray);
            }
            this.curArray = this.nextArray();
        } else {
            this.gOffset = length;
            this.arrays = null;
        }
        if (tmpRemaining > 0L) {
            throw new IllegalArgumentException("Not enough data, " + tmpRemaining + " bytes short of specified length " + length);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.curArray == null) {
            return -1;
        }
        if (this.off >= this.curArray.length) {
            this.curArray = this.nextArray();
            if (this.curArray == null) {
                return -1;
            }
        }
        ++this.gOffset;
        return this.curArray[this.off++];
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        int read = 0;
        if (this.curArray == null) {
            return -1;
        }
        if (length <= this.curArray.length - this.off) {
            System.arraycopy(this.curArray, this.off, buf, offset, length);
            this.off += length;
            this.gOffset += (long)length;
            read = length;
        } else {
            int toRead = 0;
            while (this.curArray != null && read < length) {
                toRead = Math.min(this.curArray.length - this.off, length - read);
                System.arraycopy(this.curArray, this.off, buf, offset + read, toRead);
                read += toRead;
                this.gOffset += (long)toRead;
                this.off += toRead;
                if (this.off < this.curArray.length) break;
                this.curArray = this.nextArray();
            }
        }
        return read;
    }

    @Override
    public int available() {
        return (int)(this.specifiedLength - this.gOffset);
    }

    private byte[] nextArray() {
        if (this.arrayIndex >= this.arrays.size()) {
            return null;
        }
        byte[] tmp = this.arrays.get(this.arrayIndex);
        this.arrays.set(this.arrayIndex++, null);
        this.off = 0;
        return tmp;
    }
}

