/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMapping;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMappingManager;
import org.eclipse.statet.ecommons.net.resourcemapping.core.ResourceMappingOrder;
import org.eclipse.statet.ecommons.net.resourcemapping.core.ResourceMappingUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.PathCompletionComputor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.nico.ui.console.ConsolePageEditor;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.RUtil;

@NonNullByDefault
public class RPathCompletionComputer
extends PathCompletionComputor {
    private @Nullable RProcess associatedTool;
    private @Nullable IContainer baseResource;
    private @Nullable IFileStore baseFileStore;

    public void onSessionStarted(ISourceEditor editor, ContentAssist assist) {
        this.associatedTool = null;
        this.baseResource = null;
        this.baseFileStore = null;
        if (editor instanceof ConsolePageEditor) {
            Tool tool = (Tool)editor.getAdapter(Tool.class);
            if (tool instanceof RProcess) {
                this.associatedTool = (RProcess)tool;
            }
        } else {
            ISourceUnit su = editor.getSourceUnit();
            if (su instanceof IWorkspaceSourceUnit) {
                this.baseResource = null;
                IResource resource = ((IWorkspaceSourceUnit)su).getResource();
                if (this.baseResource == null) {
                    this.baseResource = resource.getParent();
                }
                if (this.baseResource != null) {
                    try {
                        this.baseFileStore = EFS.getStore((URI)this.baseResource.getLocationURI());
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        }
        super.onSessionStarted(editor, assist);
    }

    public void onSessionEnded() {
        super.onSessionEnded();
        this.associatedTool = null;
    }

    protected boolean getIsWindows() {
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null) {
            return associatedTool.getWorkspaceData().isWindows();
        }
        return super.getIsWindows();
    }

    protected char getDefaultFileSeparator() {
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null) {
            return associatedTool.getWorkspaceData().getFileSeparator();
        }
        return super.getDefaultFileSeparator();
    }

    protected @Nullable TextRegion getContentRange(AssistInvocationContext context, int mode) throws BadLocationException {
        int end;
        IDocument document = context.getSourceViewer().getDocument();
        int offset = context.getInvocationOffset();
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)context.getEditor().getDocumentContentInfo().getPartitioning(), (int)offset, (boolean)true);
        int start = partition.getOffset();
        if (start == (end = partition.getOffset() + partition.getLength())) {
            return null;
        }
        char bound = document.getChar(start);
        if (bound != '\"' && bound != '\'') {
            return null;
        }
        if (++start > offset) {
            return null;
        }
        if (end > start && document.getChar(end - 1) == bound) {
            if (end == offset) {
                return null;
            }
            --end;
        }
        return new BasicTextRegion(start, end);
    }

    protected @Nullable IPath getRelativeBasePath() {
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null) {
            IFileStore wd = associatedTool.getWorkspaceData().getWorkspaceDir();
            if (wd != null) {
                return URIUtil.toPath((URI)wd.toURI());
            }
            return null;
        }
        IFileStore baseFileStore = this.baseFileStore;
        if (baseFileStore != null) {
            return this.baseResource.getLocation();
        }
        return null;
    }

    protected @Nullable IFileStore getRelativeBaseStore() {
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null) {
            return associatedTool.getWorkspaceData().getWorkspaceDir();
        }
        IFileStore baseFileStore = this.baseFileStore;
        if (baseFileStore != null) {
            return baseFileStore;
        }
        return null;
    }

    protected @Nullable IFileStore resolveStore(IPath path) throws CoreException {
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null) {
            return associatedTool.getWorkspaceData().toFileStore(path);
        }
        return super.resolveStore(path);
    }

    protected void tryAlternative(AssistInvocationContext context, IPath path, int startOffset, String segmentPrefix, String completionPrefix, AssistProposalCollector proposals) throws CoreException {
        IResourceMappingManager rmManager;
        String address;
        RProcess associatedTool = this.associatedTool;
        if (associatedTool != null && (address = associatedTool.getWorkspaceData().getRemoteAddress()) != null && (rmManager = ResourceMappingUtils.getManager()) != null) {
            SourceProposal.ProposalParameters parameters = this.createProposalParameters(context, startOffset, segmentPrefix);
            List mappings = rmManager.getResourceMappingsFor(address, ResourceMappingOrder.REMOTE);
            for (IResourceMapping mapping : mappings) {
                String name;
                IPath remotePath = mapping.getRemotePath();
                if (!path.isEmpty()) {
                    if (!path.isPrefixOf(remotePath)) continue;
                    remotePath = remotePath.setDevice(null).makeRelative().removeFirstSegments(path.segmentCount());
                }
                if ((name = remotePath.segment(0)) == null) {
                    name = "";
                }
                if (!parameters.matchesNamePattern(name)) continue;
                proposals.add((AssistProposal)new PathCompletionComputor.ResourceCompletionProposal((PathCompletionComputor)this, parameters, mapping.getFileStore(), remotePath.toString(), completionPrefix, null));
            }
            return;
        }
    }

    protected @Nullable String checkPrefix(String prefix) {
        String unescaped = RUtil.unescapeCompletely((String)prefix);
        if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) == '\\' && (unescaped.isEmpty() || unescaped.charAt(unescaped.length() - 1) != '\\')) {
            unescaped = String.valueOf(unescaped) + '\\';
        }
        return super.checkPrefix(unescaped);
    }

    protected String checkPathCompletion(IDocument document, int completionOffset, String completion) {
        boolean startsWithBackslash;
        completion = RUtil.escapeCompletely((String)completion);
        int existingBackslashCount = 0;
        if (completionOffset >= 1) {
            try {
                if (document.getChar(completionOffset - 1) == '\\') {
                    ++existingBackslashCount;
                    if (completionOffset >= 2 && document.getChar(completionOffset - 2) == '\\') {
                        ++existingBackslashCount;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        boolean bl = startsWithBackslash = completion.length() >= 2 && completion.charAt(0) == '\\' && completion.charAt(1) == '\\';
        if (existingBackslashCount % 2 == 1) {
            completion = startsWithBackslash ? completion.substring(1) : String.valueOf('\\') + completion;
        } else if (existingBackslashCount > 0 && startsWithBackslash) {
            completion = completion.substring(2);
        }
        return completion;
    }
}

