/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.RUIMessages;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.SourceDocumentRunnable;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorProgressHandler;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class RStripCommentsHandler
extends SourceEditorProgressHandler {
    public RStripCommentsHandler(ISourceEditor editor) {
        super(editor);
    }

    protected String getTaskLabel() {
        return RUIMessages.StripComments_task_label;
    }

    protected boolean isEditTask() {
        return true;
    }

    protected void doExecute(ISourceEditor editor, ISourceUnit su, ITextSelection selection, IProgressMonitor monitor) throws Exception {
        AbstractDocument document = su.getDocument(monitor);
        ISourceUnitModelInfo model = su.getModelInfo(null, 2, monitor);
        RHeuristicTokenScanner scanner = RHeuristicTokenScanner.create((DocContentSections)editor.getDocumentContentInfo());
        if (model == null || scanner == null || monitor.isCanceled()) {
            return;
        }
        monitor.subTask(String.valueOf(this.getTaskLabel()) + "...");
        List comments = ((SourceComponent)model.getAst().getRoot()).getComments();
        IRegion region = TextUtil.getBlock((IDocument)document, (int)selection.getOffset(), (int)(selection.getOffset() + selection.getLength()));
        scanner.configure((IDocument)document);
        final MultiTextEdit edits = new MultiTextEdit();
        int startOffset = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        for (AstNode comment : comments) {
            if (comment.getStartOffset() < startOffset) continue;
            if (comment.getStartOffset() >= endOffset) break;
            int line = document.getLineOfOffset(comment.getStartOffset());
            int lineOffset = document.getLineOffset(line);
            int offset = scanner.findNonBlankBackward(comment.getStartOffset(), lineOffset, false);
            offset = offset >= 0 ? ++offset : lineOffset;
            if (offset == lineOffset) {
                edits.addChild((TextEdit)new DeleteEdit(lineOffset, document.getLineLength(line)));
                continue;
            }
            edits.addChild((TextEdit)new DeleteEdit(offset, comment.getEndOffset() - offset));
        }
        if (edits.getChildrenSize() > 0) {
            su.syncExec(new SourceDocumentRunnable(document, model.getStamp().getSourceStamp(), DocumentRewriteSessionType.SEQUENTIAL){

                public void run() throws InvocationTargetException {
                    try {
                        edits.apply((IDocument)this.getDocument(), 0);
                    }
                    catch (MalformedTreeException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (BadLocationException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
    }
}

