/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.resources.core.ProjectUtils;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.REnvSelectionComposite;
import org.eclipse.statet.internal.r.ui.RProjectContainerComposite;
import org.eclipse.statet.internal.r.ui.RUIMessages;
import org.eclipse.statet.internal.r.ui.buildpaths.RBuildpathsUIDescription;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathsUIDescription;
import org.eclipse.statet.ltk.buildpaths.ui.SourceContainerComponent;
import org.eclipse.statet.r.core.RBuildpaths;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.RProjects;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.statushandlers.StatusManager;

class RProjectConfigurationBlock
extends ManagedConfigurationBlock {
    private final RProject rProject;
    private final RBuildpathsUIDescription buildpathUIDescription;
    private final WritableList buildpathList;
    private final SourceContainerComponent sourceFolders;
    private boolean isPkg;
    private Label pkgNameLabel;
    private Text pkgNameControl;
    private RProjectContainerComposite projectComposite;
    private REnvSelectionComposite rEnvControl;
    private IResourceChangeListener listener;

    public RProjectConfigurationBlock(IProject project, StatusChangeListener statusListener) {
        super(project, statusListener);
        this.rProject = RProjects.getRProject((IProject)project);
        this.buildpathUIDescription = new RBuildpathsUIDescription();
        this.buildpathList = new WritableList();
        this.sourceFolders = new SourceContainerComponent(this.buildpathList, RBuildpaths.R_SOURCE_TYPE, null, (BuildpathsUIDescription)this.buildpathUIDescription);
        this.listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                UIAccess.getDisplay().asyncExec(() -> {
                    if (UIAccess.isOkToUse((Control)RProjectConfigurationBlock.this.pkgNameControl)) {
                        RProjectConfigurationBlock.this.updatePkgName();
                    }
                });
            }
        };
        this.rProject.getProject().getWorkspace().addResourceChangeListener(this.listener, 16);
    }

    public void dispose() {
        if (this.listener != null) {
            this.rProject.getProject().getWorkspace().removeResourceChangeListener(this.listener);
            this.listener = null;
        }
        super.dispose();
    }

    protected String getHelpContext() {
        return "org.eclipse.statet.r.ui.r_project-project_properties";
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Preference, Object> prefs = new HashMap<Preference, Object>();
        prefs.put(RProject.PKG_BASE_FOLDER_PATH_PREF, null);
        prefs.put(RProject.RENV_CODE_PREF, null);
        this.setupPreferenceManager(prefs);
        Composite mainComposite = new Composite(pageComposite, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        TabFolder folder = new TabFolder(mainComposite, 0);
        folder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TabItem item = new TabItem(folder, 0);
        item.setText("&Main");
        item.setControl(this.createMainTab((Composite)folder));
        item = new TabItem(folder, 0);
        item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        item.setText("&Source");
        item.setControl(this.createSourceTab((Composite)folder));
        item = new TabItem(folder, 0);
        item.setImage(RUI.getImage("org.eclipse.statet.r.ui/image/obj/r_environment"));
        item.setText("R &Environment");
        item.setControl(this.createREnvTab((Composite)folder));
        this.initBindings();
        this.updateControls();
    }

    private Control createMainTab(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)2));
        this.projectComposite = new RProjectContainerComposite(composite, this.getProject());
        this.projectComposite.setLayoutData(new GridData(4, 4, true, true));
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true));
        buttons.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        Button button = new Button(buttons, 8);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        button.setText("R &Package Root");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RProjectConfigurationBlock.this.projectComposite.togglePkgBaseContainer();
            }
        });
        Composite packageComposite = new Composite(composite, 0);
        packageComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        packageComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(packageComposite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("R Package &Name:");
        this.pkgNameLabel = label;
        this.pkgNameControl = new Text(packageComposite, 8);
        this.pkgNameControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pkgNameControl.setFont(JFaceResources.getTextFont());
        this.pkgNameControl.setEditable(false);
        return composite;
    }

    private Control createSourceTab(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)1));
        Control control = this.sourceFolders.create(composite);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    private Control createREnvTab(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)1));
        Label label = new Label(composite, 0);
        label.setText("R Envir&onment:");
        this.rEnvControl = new REnvSelectionComposite(composite);
        this.rEnvControl.setLayoutData(new GridData(4, 4, true, false));
        return composite;
    }

    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindValue(this.rEnvControl.createObservable(Realm.getDefault()), this.createObservable(RProject.RENV_CODE_PREF), new UpdateValueStrategy().setAfterGetValidator(this.rEnvControl.createValidator(db.getContext())), null);
        this.sourceFolders.bind(db);
    }

    private void updatePkgName() {
        IPath pkgBasePath = this.rProject.getPkgRootPath();
        if (pkgBasePath != null) {
            String pkgName = this.rProject.getPkgName();
            if (pkgName == null) {
                pkgName = "<missing>";
            }
            this.pkgNameLabel.setEnabled(true);
            this.pkgNameControl.setText(pkgName);
        } else {
            this.pkgNameLabel.setEnabled(false);
            this.pkgNameControl.setText("");
        }
    }

    protected void updateControls() {
        IPath pkgBasePath = this.rProject.getPkgRootPath();
        if (pkgBasePath != null) {
            this.isPkg = true;
            this.projectComposite.setPkgBaseContainer(pkgBasePath.removeFirstSegments(1));
        } else {
            this.isPkg = false;
            this.projectComposite.setPkgBaseContainer(null);
        }
        this.updatePkgName();
        this.buildpathList.clear();
        this.buildpathUIDescription.toListElements(this.getProject(), (List)this.rProject.getRawBuildpath(), (List)this.buildpathList);
        this.sourceFolders.init(this.getProject());
        super.updateControls();
    }

    protected void updatePreferences() {
        IPath pkgBasePath = this.projectComposite.getPkgBaseContainer();
        if (pkgBasePath != null) {
            this.isPkg = true;
            this.setPrefValue(RProject.PKG_BASE_FOLDER_PATH_PREF, pkgBasePath.toPortableString());
        } else {
            this.isPkg = false;
            this.setPrefValue(RProject.PKG_BASE_FOLDER_PATH_PREF, null);
        }
        super.updatePreferences();
    }

    public boolean performOk(int flags) {
        boolean wasPkg = this.isPkg;
        this.saveProjectConfig();
        boolean ok = super.performOk(flags);
        if (ok && wasPkg != this.isPkg) {
            this.setupRPkg(this.isPkg);
        }
        return ok;
    }

    private void saveProjectConfig() {
        ImList newBuildpath = this.buildpathUIDescription.toCoreElements((List)this.buildpathList);
        RBuildpaths.set((IProject)this.getProject(), (ImList)newBuildpath);
    }

    private void setupRPkg(final boolean pkg) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
                try {
                    IProject project = RProjectConfigurationBlock.this.rProject.getProject();
                    if (pkg) {
                        RProjects.setupRPkgProject((IProject)project, null, (IProgressMonitor)m);
                    } else {
                        m.beginTask(NLS.bind((String)RUIMessages.RProject_ConfigureTask_label, (Object)project.getName()), 10);
                        IProjectDescription description = project.getDescription();
                        boolean changed = false;
                        m.worked(2);
                        if (changed |= ProjectUtils.removeNature((IProjectDescription)description, (String)"org.eclipse.statet.r.resourceProjects.RPkg")) {
                            project.setDescription(description, (IProgressMonitor)m.newChild(8));
                        }
                    }
                }
                finally {
                    m.done();
                }
            }
        };
        try {
            UIAccess.getActiveWorkbenchWindow((boolean)true).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", RUIMessages.RPkgProject_ConvertTask_error_message, e.getTargetException()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return new String[]{RUIMessages.RProject_NeedsBuild_title, workspaceSettings ? RUIMessages.RProject_NeedsBuild_Full_message : RUIMessages.RProject_NeedsBuild_Project_message};
    }
}

