/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.RLexer;
import org.eclipse.statet.r.core.rsource.RSourceIndenter;
import org.eclipse.statet.r.core.rsource.ast.Assignment;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RScanner;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.text.edits.TextEdit;

public class RRefactoringAdapter
extends RefactoringAdapter {
    private RLexer lexer;

    public RRefactoringAdapter() {
        super("R");
    }

    public String getPluginIdentifier() {
        return "org.eclipse.statet.r.core";
    }

    public RHeuristicTokenScanner getScanner(ISourceUnit su) {
        return RHeuristicTokenScanner.create(su.getDocumentContentInfo());
    }

    public boolean isCommentContent(ITypedRegion partition) {
        return partition != null && partition.getType() == "R.Comment";
    }

    public TextRegion trimToAstRegion(AbstractDocument document, TextRegion region, RHeuristicTokenScanner scanner) {
        int result;
        scanner.configure((IDocument)document, IRDocumentConstants.R_CODE_CONTENT_CONSTRAINT);
        int start = region.getStartOffset();
        int stop = region.getEndOffset();
        while (stop > start) {
            result = scanner.findNonBlankBackward(stop, start, true);
            if (result >= 0) {
                if (scanner.getChar() == ';') {
                    stop = result;
                    continue;
                }
                stop = result + 1;
                break;
            }
            stop = start;
            break;
        }
        while (start < stop) {
            result = scanner.findNonBlankForward(start, stop, true);
            if (result >= 0) {
                if (scanner.getChar() == ';') {
                    start = result + 1;
                    continue;
                }
                start = result;
                break;
            }
            start = stop;
            break;
        }
        return new BasicTextRegion(start, stop);
    }

    public RAstNode searchPotentialNameNode(ISourceUnit su, TextRegion region, boolean allowAssignRegion, IProgressMonitor monitor) {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        su.connect((IProgressMonitor)m.newChild(1));
        try {
            AstSelection astSelection;
            AbstractDocument document = su.getDocument((IProgressMonitor)m.newChild(1));
            RHeuristicTokenScanner scanner = this.getScanner(su);
            region = this.trimToAstRegion(document, region, scanner);
            ISourceUnitModelInfo modelInfo = su.getModelInfo("R", 2, (IProgressMonitor)m.newChild(1));
            if (modelInfo != null && (astSelection = AstSelection.search((AstNode)modelInfo.getAst().getRoot(), (int)region.getStartOffset(), (int)region.getEndOffset(), (int)3)).getCovering() instanceof RAstNode) {
                RAstNode node = (RAstNode)astSelection.getCovering();
                RAstNode rAstNode = RRefactoringAdapter.getPotentialNameNode(node, allowAssignRegion);
                return rAstNode;
            }
            return null;
        }
        finally {
            m.setWorkRemaining(1);
            su.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    public TextRegion expandSelectionRegion(AbstractDocument document, TextRegion region, TextRegion limit, RHeuristicTokenScanner scanner) {
        int result;
        scanner.configure((IDocument)document, new PartitionConstraint(){

            public boolean matches(String partitionType) {
                return partitionType != "R.Comment";
            }
        });
        int min = limit.getStartOffset();
        int max = limit.getEndOffset();
        int start = region.getStartOffset();
        int end = region.getEndOffset();
        while (start > min) {
            result = scanner.findNonBlankBackward(start, min, true);
            if (result >= 0) {
                if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(scanner.getPartition(result).getType()) && scanner.getChar() == ';') {
                    start = result;
                    continue;
                }
                start = result + 1;
                break;
            }
            start = min;
            break;
        }
        while (end < max) {
            result = scanner.findNonBlankForward(end, max, true);
            if (result >= 0) {
                if (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(scanner.getPartition(result).getType()) && scanner.getChar() == ';') {
                    end = result + 1;
                    continue;
                }
                end = result;
                break;
            }
            end = max;
            break;
        }
        return new BasicTextRegion(start, end);
    }

    public String validateIdentifier(String value, String identifierMessageName) {
        if (value == null || value.isEmpty()) {
            return identifierMessageName != null ? NLS.bind((String)Messages.RIdentifiers_error_EmptyFor_message, (Object)identifierMessageName, (Object)Messages.RIdentifiers_error_Empty_message) : Messages.RIdentifiers_error_Empty_message;
        }
        if (this.lexer == null) {
            this.lexer = new RLexer();
        }
        this.lexer.reset((TextParserInput)new StringParserInput(value).init());
        RTerminal nextToken = this.lexer.next();
        if (nextToken == RTerminal.EOF) {
            return identifierMessageName != null ? NLS.bind((String)Messages.RIdentifiers_error_EmptyFor_message, (Object)identifierMessageName, (Object)Messages.RIdentifiers_error_Empty_message) : Messages.RIdentifiers_error_Empty_message;
        }
        if (nextToken != RTerminal.SYMBOL && nextToken != RTerminal.SYMBOL_G || (this.lexer.getFlags() & 0x10000) != 0 || this.lexer.next() != RTerminal.EOF) {
            return identifierMessageName != null ? NLS.bind((String)Messages.RIdentifiers_error_InvalidFor_message, (Object)identifierMessageName, (Object)Messages.RIdentifiers_error_Empty_message) : Messages.RIdentifiers_error_Invalid_message;
        }
        return null;
    }

    static RAstNode getPotentialNameNode(RAstNode node, boolean allowAssignRegion) {
        switch (node.getNodeType()) {
            case A_RIGHT: 
            case A_EQUALS: 
            case A_LEFT: 
            case A_COLON: {
                Assignment assignment;
                if (allowAssignRegion && (assignment = (Assignment)node).isSearchOperator()) {
                    switch (assignment.getTargetChild().getNodeType()) {
                        case STRING_CONST: 
                        case SYMBOL: {
                            return assignment.getTargetChild();
                        }
                    }
                }
                return null;
            }
            case STRING_CONST: 
            case SYMBOL: {
                return node;
            }
        }
        return null;
    }

    public static String getQuotedIdentifier(String identifier) {
        int length;
        if (identifier == null || (length = identifier.length()) == 0) {
            return "";
        }
        if (identifier.charAt(0) == '`') {
            if (length > 1 && identifier.charAt(length - 1) == '`') {
                return identifier;
            }
            return String.valueOf(identifier) + '`';
        }
        return String.valueOf('`') + identifier + '`';
    }

    public static String getUnquotedIdentifier(String identifier) {
        int length;
        if (identifier == null || (length = identifier.length()) == 0) {
            return "";
        }
        if (identifier.charAt(0) == '`') {
            if (length > 1 && identifier.charAt(length - 1) == '`') {
                return identifier.substring(1, length - 2);
            }
            return identifier.substring(1, length - 1);
        }
        return identifier;
    }

    static String indent(StringBuilder sb, AbstractDocument orgDoc, int offset, ISourceUnit su, RHeuristicTokenScanner scanner) throws BadLocationException, CoreException {
        IRCoreAccess coreConfig = su instanceof IRSourceUnit ? ((IRSourceUnit)su).getRCoreAccess() : RCore.getWorkbenchAccess();
        IndentUtil indentUtil = new IndentUtil((IDocument)orgDoc, (IIndentSettings)coreConfig.getRCodeStyle());
        int column = indentUtil.getColumn(offset);
        String initial = indentUtil.createIndentString(column);
        String prefix = String.valueOf(initial) + "1\n";
        sb.insert(0, prefix);
        String text = sb.toString();
        Document doc = new Document(text);
        StringParserInput parseInput = new StringParserInput(text);
        text = null;
        RScanner astScanner = new RScanner(1);
        SourceComponent rootNode = astScanner.scanSourceUnit(parseInput.init());
        RSourceIndenter indenter = new RSourceIndenter(scanner, coreConfig);
        TextEdit edits = indenter.getIndentEdits((AbstractDocument)doc, rootNode, 0, 1, doc.getNumberOfLines() - 1);
        edits.apply((IDocument)doc, 0);
        return doc.get(prefix.length(), doc.getLength() - prefix.length());
    }

    static int prepareInsertBefore(StringBuilder text, AbstractDocument orgDoc, int offset, ISourceUnit su) throws BadLocationException, CoreException {
        int line;
        IRCoreAccess coreConfig = su instanceof IRSourceUnit ? ((IRSourceUnit)su).getRCoreAccess() : RCore.getWorkbenchAccess();
        IndentUtil indentUtil = new IndentUtil((IDocument)orgDoc, (IIndentSettings)coreConfig.getRCodeStyle());
        int[] lineIndent = indentUtil.getLineIndent(line = orgDoc.getLineOfOffset(offset), false);
        if (lineIndent[1] == offset) {
            text.insert(0, indentUtil.createIndentString(lineIndent[0]));
            text.append(orgDoc.getDefaultLineDelimiter());
            return orgDoc.getLineOffset(line);
        }
        text.append("; ");
        return offset;
    }

    static RCodeStyleSettings getCodeStyle(ISourceUnit su) {
        if (su instanceof IRSourceUnit) {
            return ((IRSourceUnit)su).getRCoreAccess().getRCodeStyle();
        }
        return RCore.getWorkbenchAccess().getRCodeStyle();
    }
}

