/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall3;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.internal.r.console.ui.RConsoleUIPlugin;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.nico.core.runtime.ToolRunner;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.launching.ui.REnvTab;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.server.eruntime.ERJContext;
import org.eclipse.statet.rj.server.util.LocalREnv;
import org.eclipse.statet.rj.server.util.ServerUtils;

public class RJEngineLaunchDelegate
extends JavaLaunchDelegate {
    private static final ImList<BundleSpec> CLASSPATH_LIB_SPECS = ImCollections.addElement((List)ServerUtils.MIN_CLASSPATH_SPECS, (Object)new BundleSpec("org.eclipse.swt"));
    private static final ImList<BundleSpec> CODEBASE_LIB_SPECS = ServerUtils.MIN_RMI_CODEBASE_SPECS;
    private static final String PATH_SPLITTER = Pattern.compile(File.pathSeparator, 16).pattern();
    private final String address;
    private final IREnvConfiguration rEnvConfig;
    private final List<BundleSpec> codebaseLibs;
    private final ERJContext serverContext;
    private final LocalREnv serverREnv;
    private final Path rjPkgPath;
    private File workingDirectory;
    private IProgressMonitor monitor;
    private String libPreloadVar;
    private String libPreloadFile;

    public RJEngineLaunchDelegate(String address, boolean requireCodebase, IREnvConfiguration rEnvConfig) throws CoreException {
        this.address = address;
        this.rEnvConfig = rEnvConfig;
        this.codebaseLibs = requireCodebase ? CODEBASE_LIB_SPECS : null;
        this.serverContext = new ERJContext();
        try {
            ArrayList<Path> rLibPaths = new ArrayList<Path>();
            for (RLibGroup group : this.rEnvConfig.getRLibGroups()) {
                for (RLibLocation library : group.getLibLocations()) {
                    Path path = library.getDirectoryPath();
                    if (path == null) continue;
                    rLibPaths.add(path);
                }
            }
            this.serverREnv = new LocalREnv(Paths.get(this.rEnvConfig.getRHomeDirectory(), new String[0]), rLibPaths);
            this.rjPkgPath = this.serverREnv.searchRPkg("rj");
            if (this.rjPkgPath == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", "Could not find the R package 'rj' in the R library path:" + CollectionUtils.toString(rLibPaths, (String)"\n\t")));
            }
        }
        catch (RjInvalidConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", "An error occurred when initializing the R library paths.", (Throwable)e));
        }
        this.setLibPreload(true);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Object object = this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        if (mode.equals("debug")) {
            mode = "run";
        }
        super.launch(configuration, mode, launch, this.monitor);
    }

    public IPath getWorkingDirectoryPath(ILaunchConfiguration configuration) throws CoreException {
        IFileStore workingDirectory = REnvTab.getWorkingDirectory((ILaunchConfiguration)configuration);
        return URIUtil.toPath((URI)workingDirectory.toURI());
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        this.workingDirectory = super.verifyWorkingDirectory(configuration);
        return this.workingDirectory;
    }

    public IFileStore getWorkingDirectory() {
        if (this.workingDirectory != null) {
            return EFS.getLocalFileSystem().fromLocalFile(this.workingDirectory);
        }
        return null;
    }

    public void setLibPreload(boolean enable) {
        if (enable) {
            if (Platform.getOS().equals("win32")) {
                this.libPreloadVar = null;
                this.libPreloadFile = null;
            } else if (Platform.getOS().equals("macosx")) {
                this.libPreloadVar = null;
                this.libPreloadFile = "libjsig.dylib";
            } else {
                this.libPreloadVar = "LD_PRELOAD";
                this.libPreloadFile = "libjsig.so";
            }
        } else {
            this.libPreloadVar = null;
            this.libPreloadFile = null;
        }
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        String path;
        String value;
        IVMInstall vmInstall = this.getVMInstall(configuration);
        HashMap<String, String> additional = new HashMap<String, String>();
        File location = vmInstall.getInstallLocation();
        if (location != null) {
            additional.put("JAVA_HOME", location.getAbsolutePath());
        }
        Map envp = LaunchUtils.createEnvironment((ILaunchConfiguration)configuration, (Map[])new Map[]{additional, this.rEnvConfig.getEnvironmentsVariables()});
        if (!(this.libPreloadVar == null || (value = (String)envp.get(this.libPreloadVar)) != null && value.contains("libjsig") || (path = (String)((IVMInstall3)vmInstall).evaluateSystemProperties(new String[]{"java.library.path"}, this.monitor).get("java.library.path")) == null)) {
            String[] pathList = path.split(PATH_SPLITTER);
            int i = 0;
            while (i < pathList.length) {
                File file = new File(pathList[i], this.libPreloadFile);
                if (file.exists()) {
                    String s = file.getAbsolutePath();
                    if (s.indexOf(32) >= 0) break;
                    value = value != null && value.length() > 0 ? String.valueOf(s) + ' ' + value : s;
                    envp.put(this.libPreloadVar, value);
                    break;
                }
                ++i;
            }
        }
        return LaunchUtils.toKeyValueStrings((Map)envp);
    }

    public String[][] getClasspathAndModulepath(ILaunchConfiguration configuration) throws CoreException {
        String[][] paths = new String[][]{this.getClasspath(configuration), new String[0]};
        return paths;
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        LinkedHashSet<String> classpath = new LinkedHashSet<String>();
        classpath.add(this.rjPkgPath.resolve(Paths.get("server/rj-boot.jar", new String[0])).toString());
        classpath.addAll(Arrays.asList(super.getClasspath(configuration)));
        return classpath.toArray(new String[classpath.size()]);
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        try {
            String rArch;
            List rjLibs;
            String args = super.getVMArguments(configuration);
            StringBuilder s = new StringBuilder(" ");
            if (args != null) {
                s.append(args);
            }
            if (s.indexOf(" -Dorg.eclipse.statet.rj.server.ClassPath.urls=") < 0) {
                s.append(" -Dorg.eclipse.statet.rj.server.ClassPath.urls=\"");
                rjLibs = this.serverContext.resolveBundles(CLASSPATH_LIB_SPECS);
                s.append(ServerUtils.concatRJClassPath((Collection)rjLibs));
                s.append("\"");
            }
            if (s.indexOf(" -Djava.security.policy=") < 0) {
                try {
                    URL intern = Platform.getBundle((String)"org.eclipse.statet.rj.server").getEntry("/localhost.policy");
                    URL java = FileLocator.resolve((URL)intern);
                    s.append(" -Djava.security.policy=");
                    s.append('\"');
                    s.append(java.toString());
                    s.append('\"');
                }
                catch (IOException e) {
                    RConsoleUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", -1, "An error trying to resolve path to security policy", (Throwable)e));
                }
            }
            if (s.indexOf(" -Djava.rmi.server.hostname=") < 0) {
                s.append(" -Djava.rmi.server.hostname=");
                s.append(InetAddress.getLoopbackAddress().getHostAddress());
            }
            if (s.indexOf(" -Dorg.eclipse.statet.rj.rmi.disableSocketFactory=") < 0) {
                s.append(" -Dorg.eclipse.statet.rj.rmi.disableSocketFactory=true");
            }
            if (this.codebaseLibs != null && s.indexOf(" -Djava.rmi.server.codebase=") < 0) {
                s.append(" -Djava.rmi.server.codebase=\"");
                rjLibs = this.serverContext.resolveBundles(this.codebaseLibs);
                s.append(ServerUtils.concatCodebase((Collection)rjLibs));
                s.append("\"");
            }
            if (!ToolRunner.captureLogOnly((ILaunchConfiguration)configuration) && s.indexOf(" -Dorg.eclipse.statet.rj.verbose=") < 0) {
                s.append(" -Dorg.eclipse.statet.rj.verbose=true");
            }
            if (Platform.getOS().equals("macosx") && JavaRuntime.compareJavaVersions((IVMInstall)JavaRuntime.computeVMInstall((ILaunchConfiguration)configuration), (String)"1.8") == 0 && s.indexOf(" -d32") < 0 && s.indexOf(" -d64") < 0 && (rArch = this.rEnvConfig.getRArch()) != null) {
                if (rArch.equals("i386") || rArch.equals("i586") || rArch.equals("i686")) {
                    s.append(" -d32");
                } else if (rArch.equals("x86_64")) {
                    s.append(" -d64");
                }
            }
            return s.substring(1);
        }
        catch (RjInvalidConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", "An error occurred when configuring start of Java based R server.", (Throwable)e));
        }
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return "RJSrv";
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        StringBuilder args = new StringBuilder("start");
        args.append(' ');
        args.append(this.address);
        args.append(" -auth=none");
        args.append(" -plugins=");
        args.append("awt,");
        if (Platform.getOS().equals("win32")) {
            args.append("swt,");
        }
        return args.toString();
    }

    protected void prepareStopInMain(ILaunchConfiguration configuration) throws CoreException {
    }

    public String getDebugInfo() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder();
        sb.addProp("R environment name", this.rEnvConfig.getName());
        sb.addProp("R package 'rj' path", this.rjPkgPath.toString());
        return sb.toString();
    }
}

