/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.core.LTKUtils;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;

public class LTKInputData
implements ISelection {
    protected ISourceUnit inputElement;
    protected ISourceUnitModelInfo inputInfo;
    protected ISelectionProvider selectionProvider;
    protected ISelection selection;
    protected AstSelection astSelection;
    protected ISourceStructElement modelSelection;

    public LTKInputData(ISourceUnit inputElement, ISelection selection) {
        this.inputElement = inputElement;
        this.selection = selection;
    }

    public LTKInputData(ISourceUnit inputElement, ISelectionProvider selectionProvider) {
        this.inputElement = inputElement;
        this.selectionProvider = selectionProvider;
        this.selection = selectionProvider.getSelection();
    }

    public boolean update() {
        if (this.selectionProvider != null) {
            ISelection selection = this.selectionProvider.getSelection();
            if (!selection.equals(this.selection)) {
                this.astSelection = null;
                this.modelSelection = null;
            }
            return true;
        }
        return false;
    }

    public IModelElement getInputElement() {
        return this.inputElement;
    }

    public ISourceUnitModelInfo getInputInfo() {
        if (this.inputInfo == null) {
            this.inputInfo = this.inputElement.getModelInfo(null, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.inputInfo;
    }

    public boolean isEmpty() {
        return this.selection.isEmpty();
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public AstSelection getAstSelection() {
        if (this.astSelection == null && this.selection instanceof ITextSelection && this.getInputInfo() != null) {
            ITextSelection textSelection = (ITextSelection)this.selection;
            this.astSelection = AstSelection.search((AstNode)this.getInputInfo().getAst().getRoot(), (int)textSelection.getOffset(), (int)(textSelection.getOffset() + textSelection.getLength()), (int)3);
        }
        return this.astSelection;
    }

    public ISourceStructElement getModelSelection() {
        if (this.modelSelection == null && this.selection instanceof ITextSelection && this.getInputInfo() != null) {
            ITextSelection textSelection = (ITextSelection)this.selection;
            this.modelSelection = LTKUtils.getCoveringSourceElement((ISourceStructElement)this.getInputInfo().getSourceElement(), (int)textSelection.getOffset(), (int)(textSelection.getOffset() + textSelection.getLength()));
        }
        return this.modelSelection;
    }

    public boolean isStillValid() {
        return true;
    }
}

