/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core.util;

import java.util.Arrays;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.text.core.BasicTextLineInformation;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;

@NonNullByDefault
public class TextLineInformationCreator {
    private int[] buffer = new int[2048];

    public TextLineInformation create(String text) {
        int[] lines = this.buffer;
        int line = 0;
        lines[0] = 0;
        int offset = 0;
        block4: while (offset < text.length()) {
            char c = text.charAt(offset++);
            switch (c) {
                case '\r': {
                    if (offset >= text.length() || text.charAt(offset) != '\n') break;
                    ++offset;
                    break;
                }
                case '\n': {
                    break;
                }
                default: {
                    continue block4;
                }
            }
            if (++line >= lines.length) {
                lines = this.buffer = Arrays.copyOf(lines, lines.length + 2048);
            }
            lines[line] = offset;
        }
        return new BasicTextLineInformation(Arrays.copyOf(lines, line + 1), text.length());
    }
}

