/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.command.AbstractDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.LayerUtil;

public class SelectDimPositionsCommand
extends AbstractDimPositionsCommand {
    private final int selectionFlags;
    private long orthogonalPosition;
    private long positionToReveal;

    public SelectDimPositionsCommand(ILayerDim layerDim, long position, long orthogonalPosition, int selectionFlags) {
        this(layerDim, position, new LRangeList(position), orthogonalPosition, selectionFlags, position);
    }

    public SelectDimPositionsCommand(ILayerDim layerDim, long refPosition, Collection<LRange> positions, long orthogonalPosition, int selectionFlags, long positionToReveal) {
        super(layerDim, refPosition, positions);
        this.orthogonalPosition = orthogonalPosition;
        this.selectionFlags = selectionFlags;
        this.positionToReveal = positionToReveal;
    }

    protected SelectDimPositionsCommand(SelectDimPositionsCommand command) {
        super(command);
        this.orthogonalPosition = command.orthogonalPosition;
        this.selectionFlags = command.selectionFlags;
        this.positionToReveal = command.positionToReveal;
    }

    @Override
    public SelectDimPositionsCommand cloneCommand() {
        return new SelectDimPositionsCommand(this);
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        ILayerDim layerDim = this.getDim();
        long targetOrthogonalPosition = LayerUtil.convertPosition(layerDim.getLayer().getDim(this.getOrientation().getOrthogonal()), this.orthogonalPosition, this.orthogonalPosition, targetLayer.getDim(this.getOrientation().getOrthogonal()));
        if (targetOrthogonalPosition != Long.MIN_VALUE && super.convertToTargetLayer(targetLayer)) {
            this.orthogonalPosition = targetOrthogonalPosition;
            this.positionToReveal = LayerUtil.convertPosition(layerDim, this.positionToReveal, this.positionToReveal, targetLayer.getDim(this.getOrientation()));
            return true;
        }
        return false;
    }

    public long getOrthogonalPosition() {
        return this.orthogonalPosition;
    }

    public int getSelectionFlags() {
        return this.selectionFlags;
    }

    public long getPositionToReveal() {
        return this.positionToReveal;
    }
}

