/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.models.core.util.ElementProxy;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.components.SearchText;
import org.eclipse.statet.ecommons.ui.content.IElementFilter;
import org.eclipse.statet.ecommons.ui.content.ITextElementFilter;
import org.eclipse.statet.ecommons.ui.content.TextElementFilter;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class QuickTreeInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private SearchText filterText;
    private TreeViewer treeViewer;
    protected ITextElementFilter nameFilter;
    private IElementFilter.IFinalFilter finalNameFilter;
    private final ElementWithName nameFilterElement = new ElementWithName();
    private final int iterationCount;
    private int iterationPosition;
    private final String commandId;
    private String commandBestKeyStrokeFormatted;
    private List<KeyStroke> commandActiveKeyStrokes;
    private KeyListener commandKeyListener;

    public QuickTreeInformationControl(Shell parent, int shellStyle, boolean showStatusField, String commandId, int iterationCount) {
        super(parent, shellStyle, true, true, false, true, true, null, null);
        if (iterationCount < 1) {
            throw new IllegalArgumentException("iterationCount");
        }
        this.commandId = commandId;
        this.iterationCount = iterationCount;
        if (this.commandId != null && this.iterationCount > 1) {
            this.initIterateKeys();
        }
        this.setInfoText("");
        this.nameFilter = this.createNameFilter();
        this.create();
    }

    private void initIterateKeys() {
        if (this.commandId == null || this.iterationCount == 1) {
            return;
        }
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (bindingSvc == null) {
            return;
        }
        TriggerSequence sequence = bindingSvc.getBestActiveBindingFor(this.commandId);
        KeyStroke keyStroke = this.getKeyStroke(sequence);
        if (keyStroke == null) {
            return;
        }
        this.commandBestKeyStrokeFormatted = keyStroke.format();
        TriggerSequence[] sequences = bindingSvc.getActiveBindingsFor(this.commandId);
        this.commandActiveKeyStrokes = new ArrayList<KeyStroke>(sequences.length);
        int i = 0;
        while (i < sequences.length) {
            KeyStroke keyStroke2 = this.getKeyStroke(sequences[i]);
            if (keyStroke2 != null) {
                this.commandActiveKeyStrokes.add(keyStroke2);
            }
            ++i;
        }
        this.commandKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)event));
                for (KeyStroke activeKeyStroke : QuickTreeInformationControl.this.commandActiveKeyStrokes) {
                    if (!activeKeyStroke.equals((Object)keyStroke)) continue;
                    event.doit = false;
                    QuickTreeInformationControl.this.iterate();
                    return;
                }
            }
        };
    }

    private KeyStroke getKeyStroke(TriggerSequence triggerSequence) {
        KeyStroke[] keyStrokes;
        if (triggerSequence instanceof KeySequence && (keyStrokes = ((KeySequence)triggerSequence).getKeyStrokes()).length == 1) {
            return keyStrokes[0];
        }
        return null;
    }

    protected abstract String getDescription(int var1);

    protected void updateInfoText() {
        StringBuilder sb = new StringBuilder(this.getDescription(this.getIterationPosition()));
        if (this.commandBestKeyStrokeFormatted != null) {
            sb.append("\u2004\u2004");
            sb.append(NLS.bind((String)SharedMessages.DoToShow_message, (Object)this.commandBestKeyStrokeFormatted, (Object)this.getDescription(this.getNextIterationPosition())));
        }
        sb.append('\u2006');
        this.setInfoText(sb.toString());
    }

    protected Control createDialogArea(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 772);
        final Tree tree = viewer.getTree();
        GridData gd = new GridData(1808);
        gd.heightHint = LayoutUtils.hintHeight(tree, 12);
        tree.setLayoutData((Object)gd);
        viewer.setUseHashlookup(true);
        viewer.setAutoExpandLevel(-1);
        this.configureViewer(viewer);
        viewer.addFilter((ViewerFilter)new SearchFilter());
        this.treeViewer = viewer;
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickTreeInformationControl.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem lastItem = null;

            public void mouseMove(MouseEvent e) {
                if (tree.equals(e.getSource())) {
                    TreeItem o;
                    if (this.lastItem == null ^ (o = tree.getItem(new Point(e.x, e.y))) == null) {
                        tree.setCursor(o == null ? null : tree.getDisplay().getSystemCursor(21));
                    }
                    if (o instanceof TreeItem) {
                        Rectangle clientArea = tree.getClientArea();
                        if (!o.equals(this.lastItem)) {
                            this.lastItem = o;
                            tree.setSelection(new TreeItem[]{this.lastItem});
                        } else if (e.y - clientArea.y < tree.getItemHeight() / 4) {
                            Point p = tree.toDisplay(e.x, e.y);
                            Item item = QuickTreeInformationControl.this.treeViewer.scrollUp(p.x, p.y);
                            if (item instanceof TreeItem) {
                                this.lastItem = (TreeItem)item;
                                tree.setSelection(new TreeItem[]{this.lastItem});
                            }
                        } else if (clientArea.y + clientArea.height - e.y < tree.getItemHeight() / 4) {
                            Point p = tree.toDisplay(e.x, e.y);
                            Item item = QuickTreeInformationControl.this.treeViewer.scrollDown(p.x, p.y);
                            if (item instanceof TreeItem) {
                                this.lastItem = (TreeItem)item;
                                tree.setSelection(new TreeItem[]{this.lastItem});
                            }
                        }
                    } else if (o == null) {
                        this.lastItem = null;
                    }
                }
            }
        });
        if (this.commandKeyListener != null) {
            tree.addKeyListener(this.commandKeyListener);
        }
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        QuickTreeInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        });
        this.addDisposeListener(this);
        return this.treeViewer.getControl();
    }

    protected abstract void configureViewer(TreeViewer var1);

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected SearchText getFilterText() {
        return this.filterText;
    }

    protected SearchText createFilterText(Composite parent) {
        this.filterText = new SearchText(parent, "", 0);
        Dialog.applyDialogFont((Control)this.filterText);
        this.filterText.addListener(new SearchText.Listener(){

            @Override
            public void textChanged(boolean user) {
                QuickTreeInformationControl.this.setMatcherString(QuickTreeInformationControl.this.filterText.getText(), true);
            }

            @Override
            public void okPressed() {
                QuickTreeInformationControl.this.gotoSelectedElement();
            }

            @Override
            public void downPressed() {
                QuickTreeInformationControl.this.treeViewer.getTree().setFocus();
            }
        });
        this.filterText.getTextControl().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\u001b') {
                    QuickTreeInformationControl.this.close();
                    event.doit = false;
                }
            }
        });
        if (this.commandKeyListener != null) {
            this.filterText.getTextControl().addKeyListener(this.commandKeyListener);
        }
        return this.filterText;
    }

    protected void createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    protected void setMatcherString(String pattern, boolean update) {
        if (this.nameFilter.setText(pattern) && update) {
            this.stringMatcherUpdated();
        }
    }

    protected void stringMatcherUpdated() {
        this.treeViewer.getControl().setRedraw(false);
        this.finalNameFilter = this.nameFilter.getFinal(false);
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        this.selectFirstMatch();
        this.treeViewer.getControl().setRedraw(true);
    }

    protected Object getSelectedElement() {
        if (this.treeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    protected void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            try {
                this.dispose();
                this.openElement(selectedElement);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "An error occurred when opening the selected element.", (Throwable)e));
            }
        }
    }

    protected abstract void openElement(Object var1) throws CoreException;

    protected void selectFirstMatch() {
        Tree tree = this.treeViewer.getTree();
        Object element = this.findFirstMatch(tree.getItems());
        if (element != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findFirstMatch(TreeItem[] items) {
        if (items.length > 0) {
            Object element;
            int i = 0;
            while (i < items.length) {
                element = items[i].getData();
                if (element != null && this.select(element)) {
                    return element;
                }
                ++i;
            }
            i = 0;
            while (i < items.length) {
                element = this.findFirstMatch(items[i].getItems());
                if (element != null) {
                    return element;
                }
                ++i;
            }
        }
        return null;
    }

    public void setInformation(String information) {
    }

    public abstract void setInput(Object var1);

    protected void inputChanged(int iterationPage, Object newInput, Object newSelection) {
        this.filterText.clearText();
        this.resetFilter();
        this.iterationPosition = iterationPage;
        this.updateInfoText();
        this.treeViewer.setInput(newInput);
        if (newSelection != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    protected ITextElementFilter createNameFilter() {
        return new TextElementFilter();
    }

    protected void resetFilter() {
        this.nameFilter.setText(null);
        this.finalNameFilter = this.nameFilter.getFinal(true);
    }

    protected String getElementName(IAdaptable element) {
        IBaseLabelProvider labelProvider = this.treeViewer.getLabelProvider();
        if (labelProvider instanceof ILabelProvider) {
            return ((ILabelProvider)labelProvider).getText((Object)element);
        }
        return element.toString();
    }

    protected boolean select(Object element) {
        IAdaptable adaptable;
        String name;
        if (this.finalNameFilter == null) {
            return true;
        }
        if (element instanceof IAdaptable && (name = this.getElementName(adaptable = (IAdaptable)element)) != null) {
            this.nameFilterElement.set(adaptable, name);
            return this.finalNameFilter.select(this.nameFilterElement);
        }
        return false;
    }

    protected void fillDialogMenu(IMenuManager menu) {
        super.fillDialogMenu(menu);
        menu.add((IContributionItem)new Separator("view.sort"));
        menu.add((IContributionItem)new Separator("view.filter"));
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.disableActions();
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public int open() {
        this.initActions();
        return super.open();
    }

    public final void dispose() {
        this.close();
    }

    public void widgetDisposed(DisposeEvent event) {
        this.disableActions();
        this.treeViewer = null;
        this.filterText = null;
    }

    protected void initActions() {
    }

    protected void disableActions() {
    }

    public boolean hasContents() {
        return this.treeViewer != null && this.treeViewer.getInput() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public boolean isFocusControl() {
        Shell shell = this.getShell();
        return shell != null && shell.getDisplay().getActiveShell() == shell;
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.filterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    protected final String getCommandId() {
        return this.commandId;
    }

    protected final int getIterationPosition() {
        return this.iterationPosition;
    }

    private int getNextIterationPosition() {
        int page = this.iterationPosition + 1;
        return page < this.iterationCount ? page : 0;
    }

    private void iterate() {
        this.iterationPosition = this.getNextIterationPosition();
        this.updateInfoText();
        this.iterated(this.iterationPosition);
    }

    protected void iterated(int iterationPosition) {
        Object selectedElement = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        this.treeViewer.refresh();
        if (selectedElement != null && this.treeViewer.getTree().getSelectionCount() == 0) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(selectedElement), true);
        }
    }

    protected Control createTitleControl(Composite parent) {
        this.filterText = this.createFilterText(parent);
        this.filterText.setLayoutData(new GridData(4, 4, true, false));
        return this.filterText;
    }

    protected IProgressMonitor getProgressMonitor() {
        IWorkbenchPart part = UIAccess.getActiveWorkbenchPart(true);
        if (!(part instanceof IEditorPart)) {
            return null;
        }
        IEditorPart editor = (IEditorPart)part;
        return editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    private static class ElementWithName
    implements ElementProxy {
        private IAdaptable element;
        private String name;

        private ElementWithName() {
        }

        public void set(IAdaptable element, String name) {
            this.element = element;
            this.name = name;
        }

        public IAdaptable getElement() {
            return this.element;
        }

        public <T> T getAdapter(Class<T> adapterType) {
            return (T)this.element.getAdapter(adapterType);
        }

        public String toString() {
            return this.name;
        }
    }

    protected class SearchFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (QuickTreeInformationControl.this.select(element)) {
                return true;
            }
            Object[] children = ((ITreeContentProvider)QuickTreeInformationControl.this.treeViewer.getContentProvider()).getChildren(element);
            int i = 0;
            while (i < children.length) {
                if (this.select(viewer, element, children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

