/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.docmlet.base.core.DocmlSearchPattern;
import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAst;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.commands.Argument;
import org.eclipse.statet.docmlet.tex.core.commands.EnvDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.LtxCommandDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.PreambleDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommandSet;
import org.eclipse.statet.docmlet.tex.core.model.ILtxModelInfo;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.docmlet.tex.core.source.LtxHeuristicTokenScanner;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.LtxCommandCompletionProposal;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.TexLabelCompletionProposal;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxAssistInvocationContext;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.LTKUtils;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.NameAccessSet;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;

@NonNullByDefault
public abstract class LtxElementCompletionComputer
implements ContentAssistComputer {
    private static List<TexCommand> PREAMBLE_DOCU_COMMANDS = ImCollections.newList((Object)PreambleDefinitions.PREAMBLE_documentclass_COMMAND);
    private int searchMatchRules;

    protected LtxElementCompletionComputer() {
    }

    public void onSessionStarted(ISourceEditor editor, ContentAssist assist) {
        int matchRules = 4;
        if (assist.getShowSubstringMatches()) {
            matchRules |= 0x10;
        }
        this.searchMatchRules = matchRules;
    }

    public void onSessionEnded() {
    }

    protected int getSearchMatchRules() {
        return this.searchMatchRules;
    }

    protected int getLabelSearchMatchRules() {
        int rules = this.searchMatchRules;
        if ((rules & 0x10) != 0) {
            rules |= 0x200000;
        }
        return rules;
    }

    protected abstract boolean isMath();

    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (context instanceof LtxAssistInvocationContext) {
            this.computeCompletionProposals((LtxAssistInvocationContext)context, mode, proposals, monitor);
        }
    }

    protected void computeCompletionProposals(LtxAssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        int argIdx;
        LtxAssistInvocationContext texContext;
        LtxAssistInvocationContext.CommandCall commandCall;
        String prefix = context.getIdentifierPrefix();
        ILtxModelInfo modelInfo = context.getModelInfo() instanceof ILtxModelInfo ? (ILtxModelInfo)context.getModelInfo() : null;
        TexCommandSet commandSet = context.getTexCoreAccess().getTexCommandSet();
        if (prefix.length() > 0 && prefix.charAt(0) == '\\') {
            int offset = context.getInvocationOffset() - prefix.length() + 1;
            this.addCommandProposals(context, prefix, this.isMath() ? commandSet.getLtxMathCommandsASorted() : commandSet.getLtxTextCommandsASorted(), modelInfo != null ? modelInfo.getCustomCommandMap().values() : null, proposals);
            if (modelInfo != null && !this.isMath() && modelInfo.getSourceElement() != null) {
                List elements = modelInfo.getSourceElement().getSourceChildren(null);
                ISourceStructElement element = LTKUtils.getCoveringSourceElement((List)elements, (int)offset);
                if (element != null && (element.getElementType() & 0xFF0) == 1040) {
                    this.addCommandProposals(context, prefix, commandSet.getLtxPreambleCommandsASorted(), null, proposals);
                } else if (prefix.startsWith("\\docu") && (elements.size() == 0 || offset < ((ISourceStructElement)elements.get(0)).getSourceRange().getStartOffset())) {
                    this.addCommandProposals(context, prefix, PREAMBLE_DOCU_COMMANDS, null, proposals);
                }
                if (!this.isMath() && context.getAstSelection().getCovering() instanceof TexAstNode) {
                    TexAstNode texNode = (TexAstNode)context.getAstSelection().getCovering();
                    while (texNode != null) {
                        TexCommand command;
                        if (texNode.getNodeType() == TexAst.NodeType.CONTROL && (command = ((ControlNode)texNode).getCommand()) != null && (command.getType() & 0xFF) == 52) {
                            this.addCommandProposals(context, prefix, commandSet.getLtxMathCommandsASorted(), null, proposals);
                            break;
                        }
                        texNode = texNode.getTexParent();
                    }
                }
            }
        } else if (context instanceof LtxAssistInvocationContext && (commandCall = (texContext = context).getCommandCall(true)) != null && (argIdx = commandCall.getInvocationArgIdx()) >= 0) {
            TexCommand command = commandCall.getCommand();
            Argument argDef = (Argument)command.getArguments().get(argIdx);
            TexAstNode argNode = commandCall.getArgNode(argIdx);
            int offset = texContext.getInvocationOffset() - prefix.length();
            TextRegion region = TexAst.getInnerRegion((TexAstNode)argNode);
            if (region != null && region.getStartOffset() <= offset && offset <= region.getEndOffset()) {
                if (argIdx == 0 && ((command.getType() & 0xF) == 1 || (command.getType() & 0xF) == 2)) {
                    ArrayList<String> prefered = new ArrayList<String>();
                    if (command == EnvDefinitions.GENERICENV_end_COMMAND) {
                        ControlNode node = commandCall.getControlNode();
                        while (node != null) {
                            String name;
                            if (!(node.getNodeType() != TexAst.NodeType.ENVIRONMENT || !prefered.isEmpty() && (node.getStatusCode() & 0xFFFF) != 8465 || (name = node.getText()).isEmpty() || prefered.contains(name))) {
                                prefered.add(name);
                            }
                            node = node.getTexParent();
                        }
                    }
                    this.addEnvProposals(context, prefix, this.isMath() ? commandSet.getLtxMathEnvsASorted() : commandSet.getLtxTextEnvsASorted(), modelInfo != null ? modelInfo.getCustomEnvMap().values() : null, prefered, proposals);
                } else if (modelInfo != null) {
                    switch (argDef.getContent()) {
                        case 50: {
                            this.addLabelDefProposals(context, argNode, (NameAccessSet<TexNameAccess>)modelInfo.getLabels(), proposals);
                            break;
                        }
                        case 51: {
                            this.addLabelRefProposals(context, argNode, (NameAccessSet<TexNameAccess>)modelInfo.getLabels(), proposals);
                        }
                    }
                }
            }
        }
    }

    public void computeInformationProposals(AssistInvocationContext context, AssistProposalCollector tenders, IProgressMonitor monitor) {
        if (context instanceof LtxAssistInvocationContext) {
            this.computeInformationProposals0((LtxAssistInvocationContext)context, tenders, monitor);
        }
    }

    protected void computeInformationProposals0(LtxAssistInvocationContext context, AssistProposalCollector tenders, IProgressMonitor monitor) {
        if (context.getModelInfo() == null) {
            return;
        }
        LtxAssistInvocationContext.CommandCall commandCall = context.getCommandCall(false);
        if (commandCall != null) {
            LtxCommandCompletionProposal.LtxCommandProposalParameters parameters = new LtxCommandCompletionProposal.LtxCommandProposalParameters(context, commandCall.getControlNode().getArgsStartOffset());
            parameters.command = commandCall.getCommand();
            tenders.add((AssistProposal)new LtxCommandCompletionProposal.ContextInformationProposal(parameters));
        }
    }

    private void addCommandProposals(LtxAssistInvocationContext context, String prefix, List<TexCommand> commands, Collection<TexCommand> commands2, AssistProposalCollector proposals) {
        LtxCommandCompletionProposal.LtxCommandProposalParameters parameters = new LtxCommandCompletionProposal.LtxCommandProposalParameters(context, context.getInvocationOffset() - prefix.length() + 1, (SearchPattern)new DocmlSearchPattern(this.getSearchMatchRules(), prefix.substring(1)), 95);
        for (TexCommand command : commands) {
            if (!parameters.matchesNamePattern(command.getControlWord()) || (command.getType() & 0xFF) == 42) continue;
            parameters.command = command;
            proposals.add((AssistProposal)new LtxCommandCompletionProposal(parameters));
        }
        if (commands2 != null) {
            for (TexCommand command : commands2) {
                if (!parameters.matchesNamePattern(command.getControlWord()) || (command.getType() & 0xFF) == 42) continue;
                parameters.command = command;
                proposals.add((AssistProposal)new LtxCommandCompletionProposal(parameters));
            }
        }
    }

    private void addEnvProposals(LtxAssistInvocationContext context, String prefix, List<TexCommand> envs, Collection<TexCommand> envs2, List<String> prefered, AssistProposalCollector proposals) {
        int idx;
        LtxCommandCompletionProposal.LtxCommandProposalParameters parameters = new LtxCommandCompletionProposal.LtxCommandProposalParameters(context, context.getInvocationOffset() - prefix.length(), (SearchPattern)new DocmlSearchPattern(this.getSearchMatchRules(), prefix), 95);
        ArrayList<String> addedPrefered = new ArrayList<String>(prefered.size());
        for (TexCommand env : envs) {
            if (!parameters.matchesNamePattern(env.getControlWord())) continue;
            idx = prefered.indexOf(env.getControlWord());
            parameters.command = env;
            parameters.baseRelevance = idx >= 0 && idx < 5 ? 5 - idx : 0;
            proposals.add((AssistProposal)new LtxCommandCompletionProposal.Env(parameters));
            if (idx < 0) continue;
            addedPrefered.add(env.getControlWord());
        }
        if (envs2 != null) {
            for (TexCommand env : envs2) {
                if (!parameters.matchesNamePattern(env.getControlWord())) continue;
                idx = prefered.indexOf(env.getControlWord());
                parameters.command = env;
                parameters.baseRelevance = idx >= 0 && idx < 5 ? 5 - idx : 0;
                proposals.add((AssistProposal)new LtxCommandCompletionProposal.Env(parameters));
                if (idx < 0) continue;
                addedPrefered.add(env.getControlWord());
            }
        }
        for (String name : prefered) {
            if (!parameters.matchesNamePattern(name) || addedPrefered.contains(name)) continue;
            idx = prefered.indexOf(name);
            TexCommand env = LtxCommandDefinitions.getEnv((String)name);
            if (env == null) {
                env = new TexCommand(242, name, "(open environment)");
            }
            parameters.command = env;
            parameters.baseRelevance = idx >= 0 && idx < 5 ? 5 - idx : 0;
            proposals.add((AssistProposal)new LtxCommandCompletionProposal.Env(parameters));
        }
    }

    private @Nullable String getLabelPrefix(LtxAssistInvocationContext context, TexAstNode argNode) {
        try {
            LtxHeuristicTokenScanner scanner = context.getLtxHeuristicTokenScanner();
            scanner.configure(context.getDocument());
            int startOffset = scanner.findAnyNonBlankForward(argNode.getStartOffset() + 1, argNode.getEndOffset(), true);
            return context.getDocument().get(startOffset, context.getInvocationOffset() - startOffset);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private void addLabelDefProposals(LtxAssistInvocationContext context, TexAstNode argNode, NameAccessSet<TexNameAccess> labels, AssistProposalCollector proposals) {
        String prefix = this.getLabelPrefix(context, argNode);
        if (prefix == null) {
            return;
        }
        TexLabelCompletionProposal.TexLabelProposalParameters parameters = new TexLabelCompletionProposal.TexLabelProposalParameters(context, context.getInvocationOffset() - prefix.length(), (SearchPattern)new DocmlSearchPattern(this.getLabelSearchMatchRules(), prefix));
        block0: for (String label : labels.getNames()) {
            if (!parameters.matchesNamePattern(label)) continue;
            ImList accessList = labels.getAllInUnit(label);
            parameters.access = (TexNameAccess)accessList.get(0);
            boolean isDef = false;
            for (TexNameAccess access : accessList) {
                if (!access.isWriteAccess()) continue;
                if (this.isDef(access, parameters.replacementOffset)) {
                    isDef = true;
                    continue;
                }
                parameters.baseRelevance = 94;
                proposals.add((AssistProposal)new TexLabelCompletionProposal(parameters));
                continue block0;
            }
            if (isDef) continue;
            parameters.baseRelevance = 95;
            proposals.add((AssistProposal)new TexLabelCompletionProposal(parameters));
        }
    }

    private void addLabelRefProposals(LtxAssistInvocationContext context, TexAstNode argNode, NameAccessSet<TexNameAccess> labels, AssistProposalCollector proposals) {
        String prefix = this.getLabelPrefix(context, argNode);
        if (prefix == null) {
            return;
        }
        TexLabelCompletionProposal.TexLabelProposalParameters parameters = new TexLabelCompletionProposal.TexLabelProposalParameters(context, context.getInvocationOffset() - prefix.length(), (SearchPattern)new DocmlSearchPattern(this.getLabelSearchMatchRules(), prefix));
        block0: for (String label : labels.getNames()) {
            if (!parameters.matchesNamePattern(label)) continue;
            ImList accessList = labels.getAllInUnit(label);
            parameters.access = (TexNameAccess)accessList.get(0);
            for (TexNameAccess access : accessList) {
                if (!access.isWriteAccess()) continue;
                parameters.baseRelevance = 95;
                proposals.add((AssistProposal)new TexLabelCompletionProposal(parameters));
                continue block0;
            }
            if (accessList.size() == 1 && this.isDef((TexNameAccess)accessList.get(0), parameters.replacementOffset)) continue;
            parameters.baseRelevance = 94;
            proposals.add((AssistProposal)new TexLabelCompletionProposal(parameters));
        }
    }

    private boolean isDef(TexNameAccess access, int offset) {
        TexAstNode nameNode = (TexAstNode)access.getNameNode();
        return nameNode != null && nameNode.getStartOffset() <= offset && nameNode.getEndOffset() >= offset;
    }

    public static class Default
    extends LtxElementCompletionComputer {
        @Override
        protected boolean isMath() {
            return false;
        }
    }

    public static class Math
    extends LtxElementCompletionComputer {
        @Override
        protected boolean isMath() {
            return true;
        }
    }
}

