/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.docmlet.tex.core.ast.TexAst;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstVisitor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;

@NonNullByDefault
public class Embedded
extends TexAstNode
implements EmbeddingAstNode {
    private final String foreignType;
    private @Nullable AstNode foreignNode;

    Embedded(TexAstNode parent, int startOffset, int endOffset, String foreignType) {
        super(parent, startOffset, endOffset);
        this.foreignType = foreignType;
    }

    @Override
    public TexAst.NodeType getNodeType() {
        return TexAst.NodeType.EMBEDDED;
    }

    public String getForeignTypeId() {
        return this.foreignType;
    }

    public int getEmbedDescr() {
        return 1;
    }

    public void setForeignNode(AstNode node) {
        this.foreignNode = node;
    }

    public @Nullable AstNode getForeignNode() {
        return this.foreignNode;
    }

    public boolean hasChildren() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    @Override
    public TexAstNode getChild(int index) {
        throw new IndexOutOfBoundsException();
    }

    public int getChildIndex(AstNode element) {
        return -1;
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        if (this.foreignNode != null) {
            this.foreignNode.accept(visitor);
        }
    }

    @Override
    public void acceptInTex(TexAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public void acceptInTexChildren(TexAstVisitor visitor) throws InvocationTargetException {
    }

    public String getText() {
        return this.foreignType;
    }

    static class Inline
    extends Embedded {
        Inline(TexAstNode parent, int startOffset, String type) {
            super(parent, startOffset, startOffset, type);
        }

        @Override
        public int getEmbedDescr() {
            return 2;
        }
    }
}

