/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.rdata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.r.rdata.BasicCombinedRElement;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RInteger32Store;

public final class RArrayVar<TData extends RStore>
extends BasicCombinedRElement
implements RArray<TData>,
ExternalizableRObject {
    private final long length;
    private final TData data;
    private String className1;
    private final RInteger32Store dimAttribute;

    public RArrayVar(TData data, String className1, int[] dim, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) {
        super(parent, name);
        if (data == null || className1 == null || dim == null) {
            throw new NullPointerException();
        }
        this.length = RDataUtils.computeLengthFromDim((int[])dim);
        if (data.getLength() >= 0L && data.getLength() != this.length) {
            throw new IllegalArgumentException("dim");
        }
        this.className1 = className1;
        this.dimAttribute = new RInteger32Store(dim);
        this.data = data;
    }

    public RArrayVar(RJIO io, RObjectFactory factory, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) throws IOException {
        super(parent, name);
        int options = io.readInt();
        if ((options & 0x10) != 0) {
            this.className1 = io.readString();
        }
        this.length = io.readVULong((byte)(options & 7));
        int[] dim = io.readIntArray();
        this.dimAttribute = new RInteger32Store(dim);
        assert ((options & 0x40) == 0);
        this.data = factory.readStore(io, this.length);
        if ((options & 0x10) == 0) {
            this.className1 = dim.length == 2 ? "matrix" : "array";
        }
    }

    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        int n = (int)this.dimAttribute.getLength();
        int options = io.getVULongGrade(this.length);
        if (!this.className1.equals(n == 2 ? "matrix" : "array")) {
            options |= 0x10;
        }
        io.writeInt(options);
        if ((options & 0x10) != 0) {
            io.writeString(this.className1);
        }
        io.writeVULong((byte)(options & 7), this.length);
        io.writeInt(n);
        this.dimAttribute.writeExternal(io);
        factory.writeStore(this.data, io);
    }

    public final byte getRObjectType() {
        return 3;
    }

    public String getRClassName() {
        return this.className1;
    }

    public long getLength() {
        return this.length;
    }

    public RIntegerStore getDim() {
        return this.dimAttribute;
    }

    public @Nullable RCharacterStore getDimNames() {
        return null;
    }

    public @Nullable RStore getNames(int dim) {
        return null;
    }

    public TData getData() {
        return this.data;
    }

    public int getElementType() {
        return 1552;
    }

    public boolean hasModelChildren(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable IModelElement.Filter filter) {
        return false;
    }

    public List<? extends CombinedRElement> getModelChildren(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable IModelElement.Filter filter) {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObject type=array, class=").append(this.getRClassName());
        sb.append("\n\tlength=").append(this.getLength());
        sb.append("\n\tdim=");
        this.dimAttribute.appendTo(sb);
        sb.append("\n\tdata: ");
        sb.append(this.data.toString());
        return sb.toString();
    }
}

