/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveAllTerminatedAction;
import org.eclipse.debug.internal.ui.views.console.ConsoleRemoveLaunchAction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.text.ui.TextViewerAction;
import org.eclipse.statet.ecommons.text.ui.TextViewerEditorColorUpdater;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.NestedServices;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.internal.nico.ui.LocalTaskTransfer;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.internal.nico.ui.console.OutputViewer;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.ts.core.ActiveToolListener;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.nico.core.runtime.Prompt;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.ui.actions.CancelHandler;
import org.eclipse.statet.nico.ui.console.ConsolePageEditor;
import org.eclipse.statet.nico.ui.console.InputSourceViewer;
import org.eclipse.statet.nico.ui.console.MultiActionHandler;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.ScrollLockAction;
import org.eclipse.statet.nico.ui.console.SubmitDropAdapter;
import org.eclipse.statet.nico.ui.console.SubmitPasteAction;
import org.eclipse.statet.nico.ui.console.TerminateToolAction;
import org.eclipse.statet.nico.ui.util.ExportConsoleOutputWizard;
import org.eclipse.statet.nico.ui.util.NicoWizardDialog;
import org.eclipse.statet.nico.ui.util.OpenTrackingFilesContributionItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.FindReplaceAction;

public abstract class NIConsolePage
implements IPageBookViewPage,
IAdaptable,
IShowInSource,
IShowInTargetList,
IPropertyChangeListener,
ScrollLockAction.Receiver,
ToolProvider,
SettingsChangeNotifier.ChangeListener {
    private static final String DIALOG_ID = "Console";
    private static final String SETTING_INPUTHEIGHT = "InputHeight";
    public static final String NICO_CONTROL_MENU_ID = "nico.control";
    private final NIConsole console;
    private final IConsoleView consoleView;
    private IPageSite site;
    private Composite control;
    private Clipboard clipboard;
    private OutputViewer outputViewer;
    private ConsolePageEditor inputGroup;
    private SizeController resizer;
    private MenuManager outputMenuManager;
    private MenuManager inputMenuManager;
    private volatile boolean isCreated = false;
    private MultiActionHandler multiActionHandler;
    private final CopyOnWriteIdentityListSet<ActiveToolListener> toolListeners = new CopyOnWriteIdentityListSet();
    NestedServices inputServices;
    private FindReplaceUpdater findReplaceUpdater;
    private FindReplaceAction findReplaceAction;
    private TextViewerAction outputCopyAction;
    private SubmitPasteAction outputPasteAction;
    private TextViewerAction outputSelectAllAction;
    private ClearOutputAction outputClearAllAction;
    private Action outputScrollLockAction;
    private TextViewerAction inputDeleteAction;
    private TextViewerAction inputCutAction;
    private TextViewerAction inputCopyAction;
    private TextViewerAction inputPasteAction;
    private TextViewerAction inputSelectAllAction;
    private TextViewerAction inputUndoAction;
    private TextViewerAction inputRedoAction;
    private StatusListener debugListener;
    private ConsoleRemoveLaunchAction removeAction;
    private ConsoleRemoveAllTerminatedAction removeAllAction;
    private TerminateToolAction terminateAction;
    private ContextHandlers pageHandlers;
    private ContextHandlers inputHandlers;

    public NIConsolePage(NIConsole console, IConsoleView view) {
        this.console = console;
        this.consoleView = view;
    }

    public void init(IPageSite site) throws PartInitException {
        this.site = site;
        this.inputGroup = this.createInputGroup();
        this.debugListener = new StatusListener();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.debugListener);
    }

    protected ConsolePageEditor createInputGroup() {
        return new ConsolePageEditor(this, null);
    }

    protected ConsolePageEditor getInputGroup() {
        return this.inputGroup;
    }

    public void createControl(Composite parent) {
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener((SettingsChangeNotifier.ChangeListener)this);
        this.console.addPropertyChangeListener(this);
        this.control = new Composite(parent, 0){

            public boolean setFocus() {
                NIConsolePage.this.setFocus();
                return true;
            }

            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (visible) {
                    NIConsolePage.this.setFocus();
                }
            }

            public void redraw() {
                super.redraw();
                if (UIAccess.isOkToUse((Viewer)NIConsolePage.this.outputViewer)) {
                    NIConsolePage.this.outputViewer.getControl().redraw();
                }
            }
        };
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        this.control.setLayout((Layout)layout);
        this.outputViewer = new OutputViewer(this.control, this.console);
        GridData outputGD = new GridData(4, 4, true, true);
        this.outputViewer.getControl().setLayoutData((Object)outputGD);
        new TextViewerEditorColorUpdater((SourceViewer)this.outputViewer, EditorsUI.getPreferenceStore());
        this.outputViewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.doit && e.character > '\u0000' && (e.stateMask == 0 || e.stateMask == 131072) && (e.keyCode & 0x1000000) == 0) {
                    StyledText textWidget = NIConsolePage.this.inputGroup.getViewer().getTextWidget();
                    if (!UIAccess.isOkToUse((Control)textWidget)) {
                        return;
                    }
                    int cType = Character.getType(e.character);
                    if (cType > 0 && cType < 15 && textWidget.getCharCount() == 0) {
                        textWidget.replaceTextRange(0, 0, Character.toString(e.character));
                        textWidget.setCaretOffset(textWidget.getCharCount());
                    } else {
                        Display.getCurrent().beep();
                    }
                    NIConsolePage.this.setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Sash sash = new Sash(this.control, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, false));
        this.inputGroup.createControl(this.control, this.createInputEditorConfigurator());
        GridData inputGD = new GridData(4, 4, true, false);
        this.inputGroup.getComposite().setLayoutData((Object)inputGD);
        this.outputViewer.getTextWidget().getHorizontalBar().setVisible(false);
        this.resizer = new SizeController(sash, outputGD, inputGD);
        sash.addListener(13, (Listener)this.resizer);
        this.control.addListener(11, (Listener)this.resizer);
        this.clipboard = new Clipboard(this.control.getDisplay());
        this.initActions();
        this.hookContextMenu();
        this.hookDND();
        this.contributeToActionBars((IServiceLocator)this.getSite(), this.getSite().getActionBars(), (HandlerCollection)this.pageHandlers);
        new ConsoleActivationNotifier();
        this.isCreated = true;
        this.debugListener.init();
        IDialogSettings dialogSettings = DialogUtils.getDialogSettings((AbstractUIPlugin)NicoUIPlugin.getInstance(), (String)DIALOG_ID);
        try {
            int height = dialogSettings.getInt(SETTING_INPUTHEIGHT);
            if (height > 0) {
                this.resizer.fLastExplicit = height;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.resizer.fontChanged();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (NIConsolePage.this.inputGroup != null && UIAccess.isOkToUse((Viewer)NIConsolePage.this.inputGroup.getViewer())) {
                    NIConsolePage.this.outputViewer.revealEndOfDocument();
                    if (NIConsolePage.this.outputViewer.getControl().isFocusControl()) {
                        NIConsolePage.this.setFocus();
                    }
                }
            }
        });
    }

    protected abstract SourceEditorViewerConfigurator createInputEditorConfigurator();

    private void activated() {
        NicoUIPlugin.getInstance().getToolRegistry().consoleActivated(this.consoleView, this.console);
        IEclipseContext service = (IEclipseContext)this.site.getService(IEclipseContext.class);
        if (service != null) {
            service.activate();
        }
    }

    private void deactivated() {
        IEclipseContext service = (IEclipseContext)this.site.getService(IEclipseContext.class);
        if (service != null) {
            service.deactivate();
        }
    }

    private void initActions() {
        Control outputControl = this.outputViewer.getControl();
        InputSourceViewer inputViewer = this.inputGroup.getViewer();
        Control inputControl = inputViewer.getControl();
        IPageSite pageServiceLocator = this.getSite();
        this.inputServices = new NestedServices((IServiceLocator)pageServiceLocator, "ConsoleInput");
        this.inputServices.bindTo(inputControl);
        IHandlerService pageHandlerService = (IHandlerService)pageServiceLocator.getService(IHandlerService.class);
        this.pageHandlers = new ContextHandlers(pageHandlerService);
        IHandlerService inputHandlerService = (IHandlerService)this.inputServices.getLocator().getService(IHandlerService.class);
        this.inputHandlers = new ContextHandlers(inputHandlerService);
        this.multiActionHandler = new MultiActionHandler();
        this.removeAction = new ConsoleRemoveLaunchAction(this.console.getProcess().getLaunch());
        this.removeAllAction = new ConsoleRemoveAllTerminatedAction();
        this.terminateAction = new TerminateToolAction((IProcess)this.console.getProcess());
        CancelHandler handler = new CancelHandler(this, 0);
        this.pageHandlers.add("org.eclipse.statet.nico.commands.CancelCurrent", (IHandler2)handler);
        pageHandlerService.activateHandler("org.eclipse.statet.nico.commands.CancelCurrent", (IHandler)handler);
        handler = new CancelHandler(this, 1);
        this.pageHandlers.add("org.eclipse.statet.nico.commands.CancelAll", (IHandler2)handler);
        pageHandlerService.activateHandler("org.eclipse.statet.nico.commands.CancelAll", (IHandler)handler);
        handler = new CancelHandler(this, 16);
        this.pageHandlers.add("org.eclipse.statet.nico.commands.CancelCurrentAndPause", (IHandler2)handler);
        pageHandlerService.activateHandler("org.eclipse.statet.nico.commands.CancelCurrentAndPause", (IHandler)handler);
        this.outputCopyAction = TextViewerAction.createCopyAction((ITextViewer)this.outputViewer);
        this.multiActionHandler.addGlobalAction((Widget)outputControl, ActionFactory.COPY.getId(), (IAction)this.outputCopyAction);
        this.outputPasteAction = new SubmitPasteAction(this);
        this.outputPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.multiActionHandler.addGlobalAction((Widget)outputControl, ActionFactory.PASTE.getId(), (IAction)this.outputPasteAction);
        this.outputSelectAllAction = TextViewerAction.createSelectAllAction((ITextViewer)this.outputViewer);
        this.multiActionHandler.addGlobalAction((Widget)outputControl, ActionFactory.SELECT_ALL.getId(), (IAction)this.outputSelectAllAction);
        this.outputClearAllAction = new ClearOutputAction((TextConsole)this.console);
        this.outputScrollLockAction = new ScrollLockAction(this, false);
        this.inputDeleteAction = TextViewerAction.createDeleteAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.DELETE.getId(), (IAction)this.inputDeleteAction);
        this.inputCutAction = TextViewerAction.createCutAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.CUT.getId(), (IAction)this.inputCutAction);
        this.inputCopyAction = TextViewerAction.createCopyAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.COPY.getId(), (IAction)this.inputCopyAction);
        this.inputPasteAction = TextViewerAction.createPasteAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.PASTE.getId(), (IAction)this.inputPasteAction);
        this.inputSelectAllAction = TextViewerAction.createSelectAllAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.SELECT_ALL.getId(), (IAction)this.inputSelectAllAction);
        this.inputUndoAction = TextViewerAction.createUndoAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.UNDO.getId(), (IAction)this.inputUndoAction);
        this.inputRedoAction = TextViewerAction.createRedoAction((ITextViewer)inputViewer);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.REDO.getId(), (IAction)this.inputRedoAction);
        ResourceBundle bundle = SharedMessages.getCompatibilityBundle();
        this.findReplaceAction = new FindReplaceAction(bundle, "FindReplaceAction_", (IWorkbenchPart)this.consoleView);
        this.findReplaceAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.multiActionHandler.addGlobalAction((Widget)outputControl, ActionFactory.FIND.getId(), (IAction)this.findReplaceAction);
        this.multiActionHandler.addGlobalAction((Widget)inputControl, ActionFactory.FIND.getId(), (IAction)this.findReplaceAction);
        this.findReplaceUpdater = new FindReplaceUpdater();
        this.console.getDocument().addDocumentListener((IDocumentListener)this.findReplaceUpdater);
        inputViewer.getDocument().addDocumentListener((IDocumentListener)new PostUpdater());
        inputViewer.addSelectionChangedListener(this.multiActionHandler);
        this.outputViewer.addSelectionChangedListener(this.multiActionHandler);
        this.initActions((IServiceLocator)this.getSite(), (HandlerCollection)this.pageHandlers);
        this.inputGroup.initActions(this.inputServices.getLocator(), this.inputHandlers);
    }

    protected void initActions(IServiceLocator serviceLocator, HandlerCollection handlers) {
    }

    private void hookContextMenu() {
        String id = "org.eclipse.statet.nico.console#OutputContextMenu";
        this.outputMenuManager = new MenuManager("ContextMenu", id);
        this.outputMenuManager.setRemoveAllWhenShown(true);
        this.outputMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NIConsolePage.this.fillOutputContextMenu(manager);
            }
        });
        Control control = this.outputViewer.getControl();
        Menu menu = this.outputMenuManager.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(id, this.outputMenuManager, (ISelectionProvider)this.outputViewer);
        id = "org.eclipse.statet.nico.console#InputContextMenu";
        this.inputMenuManager = new MenuManager("ContextMenu", id);
        this.inputMenuManager.setRemoveAllWhenShown(true);
        this.inputMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NIConsolePage.this.fillInputContextMenu(manager);
            }
        });
        control = this.inputGroup.getViewer().getControl();
        menu = this.inputMenuManager.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(id, this.inputMenuManager, (ISelectionProvider)this.inputGroup.getViewer());
    }

    protected void hookDND() {
        DNDUtils.addDropSupport((Control)this.outputViewer.getControl(), (DropTargetListener)new SubmitDropAdapter(this), (Transfer[])new Transfer[]{TextTransfer.getInstance(), LocalTaskTransfer.getTransfer()});
    }

    protected void contributeToActionBars(final IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        this.multiActionHandler.registerActions(actionBars);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.appendToGroup("outputGroup", (IAction)this.outputClearAllAction);
        toolBarManager.appendToGroup("outputGroup", (IAction)this.outputScrollLockAction);
        toolBarManager.appendToGroup("launchGroup", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, "org.eclipse.statet.nico.menus.Cancel", "org.eclipse.statet.nico.commands.CancelCurrent", null, null, null, null, Messages.CancelAction_name, null, Messages.CancelAction_tooltip, 4, null, false), this.pageHandlers.get("org.eclipse.statet.nico.commands.CancelCurrent")){

            protected void initDropDownMenu(final MenuManager menuManager) {
                menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

                    public void menuAboutToShow(IMenuManager manager) {
                        manager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.nico.commands.CancelCurrent", 8)));
                        manager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.nico.commands.CancelCurrentAndPause", 8)));
                        manager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.statet.nico.commands.CancelAll", 8)));
                    }

                    public void menuAboutToHide(IMenuManager manager) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                menuManager.dispose();
                            }
                        });
                    }
                });
            }
        });
        toolBarManager.appendToGroup("launchGroup", (IAction)this.terminateAction);
        toolBarManager.appendToGroup("launchGroup", (IAction)this.removeAction);
        toolBarManager.appendToGroup("launchGroup", (IAction)this.removeAllAction);
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IContributionItem)new Separator(NICO_CONTROL_MENU_ID));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("tracking"));
        MenuManager trackingMenu = new MenuManager("Open In Editor"){

            public boolean isVisible() {
                return !NIConsolePage.this.getTool().getTracks().isEmpty();
            }
        };
        trackingMenu.add((IContributionItem)new OpenTrackingFilesContributionItem(this.getTool()));
        menuManager.add((IContributionItem)trackingMenu);
        menuManager.add((IContributionItem)new SimpleContributionItem("Export Console Output...", null){

            protected void execute() throws ExecutionException {
                ToolProcess tool = NIConsolePage.this.getTool();
                if (tool == null) {
                    return;
                }
                ExportConsoleOutputWizard wizard = new ExportConsoleOutputWizard(NIConsolePage.this);
                NicoWizardDialog dialog = new NicoWizardDialog(NIConsolePage.this.getSite().getShell(), (IWizard)wizard);
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        });
        menuManager.add((IContributionItem)new Separator("settings"));
        menuManager.add((IContributionItem)new SimpleContributionItem("Preferences...", "P"){

            protected void execute() throws ExecutionException {
                Shell shell = NIConsolePage.this.getSite().getShell();
                ArrayList<String> pageIds = new ArrayList<String>();
                NIConsolePage.this.collectContextMenuPreferencePages(pageIds);
                if (!(pageIds.isEmpty() || shell != null && shell.isDisposed())) {
                    org.eclipse.ui.dialogs.PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)((String)pageIds.get(0)), (String[])pageIds.toArray(new String[pageIds.size()]), null).open();
                }
            }
        });
        menuManager.add((IContributionItem)new Separator());
    }

    protected void fillInputContextMenu(IMenuManager manager) {
        manager.add((IAction)this.inputCutAction);
        manager.add((IAction)this.inputCopyAction);
        manager.add((IAction)this.inputPasteAction);
        manager.add((IContributionItem)new GroupMarker("cut.ext"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.inputUndoAction);
        manager.add((IAction)this.inputRedoAction);
        manager.add((IContributionItem)new GroupMarker("undo.ext"));
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillOutputContextMenu(IMenuManager manager) {
        manager.add((IAction)this.outputCopyAction);
        manager.add((IAction)this.outputSelectAllAction);
        manager.add((IContributionItem)new Separator("more"));
        manager.add((IAction)this.findReplaceAction);
        manager.add((IContributionItem)new Separator("submit"));
        manager.add((IAction)this.outputPasteAction);
        manager.add((IContributionItem)new Separator("view"));
        manager.add((IAction)this.outputClearAllAction);
        manager.add((IAction)this.outputScrollLockAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void dispose() {
        this.console.removePropertyChangeListener(this);
        PreferencesUtil.getSettingsChangeNotifier().removeChangeListener((SettingsChangeNotifier.ChangeListener)this);
        if (this.debugListener != null) {
            DebugPlugin debug = DebugPlugin.getDefault();
            if (debug != null) {
                debug.removeDebugEventListener((IDebugEventSetListener)this.debugListener);
            }
            this.debugListener = null;
        }
        if (this.isCreated) {
            this.isCreated = false;
            try {
                this.console.getDocument().removeDocumentListener((IDocumentListener)this.findReplaceUpdater);
                this.outputViewer.removeSelectionChangedListener(this.multiActionHandler);
                this.inputGroup.getViewer().removeSelectionChangedListener(this.multiActionHandler);
            }
            catch (Exception e) {
                NicoUIPlugin.logError(100, Messages.Console_error_UnexpectedException_message, e);
            }
            if (this.pageHandlers != null) {
                this.pageHandlers.dispose();
                this.pageHandlers = null;
            }
            if (this.inputHandlers != null) {
                this.inputHandlers.dispose();
                this.inputHandlers = null;
            }
            this.multiActionHandler.dispose();
            this.multiActionHandler = null;
            this.inputServices.dispose();
            this.inputServices = null;
            this.findReplaceAction = null;
            this.outputCopyAction = null;
            this.outputPasteAction = null;
            this.outputSelectAllAction = null;
            this.outputClearAllAction = null;
            this.inputDeleteAction = null;
            this.inputCutAction = null;
            this.inputCopyAction = null;
            this.inputPasteAction = null;
            this.inputSelectAllAction = null;
            this.inputUndoAction = null;
            this.debugListener = null;
            this.removeAction.dispose();
            this.removeAction = null;
            this.removeAllAction.dispose();
            this.removeAllAction = null;
            this.terminateAction.dispose();
            this.terminateAction = null;
            this.outputViewer = null;
        }
        if (this.inputGroup != null) {
            this.inputGroup.dispose();
            this.inputGroup = null;
        }
    }

    public IPageSite getSite() {
        return this.site;
    }

    public IConsoleView getView() {
        return this.consoleView;
    }

    public Control getControl() {
        return this.control;
    }

    public NIConsole getConsole() {
        return this.console;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public ToolProcess getTool() {
        return this.console.getProcess();
    }

    public void addToolListener(ActiveToolListener listener) {
        this.toolListeners.add((Object)listener);
    }

    public void removeToolListener(ActiveToolListener listener) {
        this.toolListeners.remove((Object)listener);
    }

    public TextConsoleViewer getOutputViewer() {
        return this.outputViewer;
    }

    public IMenuManager getOutputContextMenuManager() {
        return this.outputMenuManager;
    }

    public IMenuManager getInputContextMenuManager() {
        return this.inputMenuManager;
    }

    public String getInput() {
        return this.inputGroup.getDocument().get();
    }

    public void clearInput() {
        this.inputGroup.clear();
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (this.inputGroup != null) {
            if (adapterType == Widget.class) {
                if (this.outputViewer.getControl().isFocusControl()) {
                    return (T)this.outputViewer.getTextWidget();
                }
                return (T)this.inputGroup.getViewer().getTextWidget();
            }
            if (adapterType == IFindReplaceTarget.class) {
                if (this.inputGroup.getViewer().getControl().isFocusControl()) {
                    return (T)this.inputGroup.getViewer().getFindReplaceTarget();
                }
                return (T)this.outputViewer.getFindReplaceTarget();
            }
        }
        if (adapterType == ISourceEditor.class) {
            return (T)this.inputGroup;
        }
        if (adapterType == IShowInSource.class) {
            return (T)this;
        }
        if (adapterType == IShowInTargetList.class) {
            return (T)this;
        }
        return this.console.getAdapter(adapterType);
    }

    public ShowInContext getShowInContext() {
        ToolProcess process = this.console.getProcess();
        if (process == null) {
            return null;
        }
        IDebugTarget target = (IDebugTarget)process.getAdapter(IDebugTarget.class);
        TreeSelection selection = null;
        selection = target == null ? new TreeSelection(new TreePath(new Object[]{DebugPlugin.getDefault().getLaunchManager(), process.getLaunch(), process})) : new TreeSelection(new TreePath(new Object[]{DebugPlugin.getDefault().getLaunchManager(), target.getLaunch(), target}));
        return new ShowInContext(null, (ISelection)selection);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.debug.ui.DebugView"};
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.inputGroup.getViewer().getControl().setFocus();
    }

    protected void onToolTerminated() {
        if (this.isCreated) {
            this.terminateAction.update();
            ActiveToolListener.ActiveToolEvent event = new ActiveToolListener.ActiveToolEvent(2, (Tool)this.getTool());
            for (ActiveToolListener listener : this.toolListeners) {
                listener.onToolChanged(event);
            }
            this.outputPasteAction.setEnabled(false);
            final Button button = this.inputGroup.getSubmitButton();
            UIAccess.getDisplay((Shell)this.getSite().getShell()).asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (UIAccess.isOkToUse((Control)button)) {
                        button.setEnabled(false);
                    }
                }
            });
            IDialogSettings dialogSettings = DialogUtils.getDialogSettings((AbstractUIPlugin)NicoUIPlugin.getInstance(), (String)DIALOG_ID);
            dialogSettings.put(SETTING_INPUTHEIGHT, this.resizer.fLastExplicit);
        }
    }

    @Override
    public void setAutoScroll(boolean enabled) {
        this.outputViewer.setAutoScroll(enabled);
        this.outputScrollLockAction.setChecked(!enabled);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (UIAccess.isOkToUse((Control)this.control)) {
            Object source = event.getSource();
            String property = event.getProperty();
            if (source.equals((Object)this.console) && property.equals(IConsoleConstants.P_FONT)) {
                Font font = this.console.getFont();
                this.outputViewer.setFont(font);
                this.inputGroup.setFont(font);
                this.resizer.fontChanged();
                this.control.layout();
            } else if (property.equals(IConsoleConstants.P_FONT_STYLE)) {
                this.control.redraw();
                this.outputViewer.getTextWidget().redraw();
            } else if (property.equals(IConsoleConstants.P_STREAM_COLOR)) {
                this.outputViewer.getTextWidget().redraw();
            } else if (source.equals((Object)this.console) && property.equals(IConsoleConstants.P_CONSOLE_WIDTH)) {
                this.outputViewer.setConsoleWidth(this.console.getConsoleWidth());
            }
        }
    }

    public void settingsChanged(final Set<String> groupIds) {
        final HashMap options = new HashMap();
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                NIConsolePage.this.handleSettingsChanged(groupIds, options);
            }
        });
    }

    protected void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        if (this.inputGroup != null && UIAccess.isOkToUse((Control)this.control)) {
            this.inputGroup.handleSettingsChanged(groupIds, options);
        }
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        pageIds.add("org.eclipse.statet.nico.preferencePages.Console");
    }

    private class ConsoleActivationNotifier
    implements Listener {
        private ConsoleActivationNotifier() {
            NIConsolePage.this.control.addListener(26, (Listener)this);
            NIConsolePage.this.control.addListener(27, (Listener)this);
            NIConsolePage.this.control.addListener(12, (Listener)this);
            if (NIConsolePage.this.control.isVisible()) {
                NIConsolePage.this.activated();
            }
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    NIConsolePage.this.activated();
                    break;
                }
                case 27: {
                    NIConsolePage.this.deactivated();
                    break;
                }
                case 12: {
                    NIConsolePage.this.control.removeListener(26, (Listener)this);
                    NIConsolePage.this.control.removeListener(12, (Listener)this);
                }
            }
        }
    }

    private class FindReplaceUpdater
    implements IDocumentListener {
        private boolean wasEmpty = true;

        private FindReplaceUpdater() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            boolean isEmpty;
            boolean bl = isEmpty = event.fDocument.getLength() == 0;
            if (isEmpty != this.wasEmpty) {
                NIConsolePage.this.multiActionHandler.updateEnabledState();
                this.wasEmpty = isEmpty;
            }
        }
    }

    private class PostUpdater
    implements IDocumentListener,
    Runnable {
        private volatile boolean fIsSheduled = false;

        private PostUpdater() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (!this.fIsSheduled) {
                this.fIsSheduled = true;
                Display display = UIAccess.getDisplay((Shell)NIConsolePage.this.getSite().getShell());
                display.asyncExec((Runnable)this);
            }
        }

        @Override
        public void run() {
            this.fIsSheduled = false;
            NIConsolePage.this.multiActionHandler.updateEnabledState();
        }
    }

    private class SizeController
    implements Listener {
        private final Sash fSash;
        private final GridData fOutputGD;
        private final GridData fInputGD;
        private int fLastExplicit;

        public SizeController(Sash sash, GridData outputGD, GridData inputGD) {
            this.fSash = sash;
            this.fOutputGD = outputGD;
            this.fInputGD = inputGD;
            this.fLastExplicit = -1;
        }

        public void handleEvent(Event event) {
            if (event.widget == this.fSash) {
                if (event.type == 13 && event.detail != 1) {
                    Rectangle bounds = NIConsolePage.this.control.getClientArea();
                    this.setNewInputHeight(bounds.height - event.y - this.fSash.getSize().y, true);
                }
                return;
            }
            if (event.widget == NIConsolePage.this.control && event.type == 11) {
                this.setNewInputHeight(this.fInputGD.heightHint, false);
            }
        }

        private void setNewInputHeight(int height, boolean explicit) {
            if (!explicit) {
                height = this.fLastExplicit;
            }
            if (height == -1) {
                return;
            }
            Rectangle bounds = NIConsolePage.this.control.getClientArea();
            int max = bounds.height - this.fOutputGD.minimumHeight - this.fSash.getSize().y;
            if (height > max) {
                height = max;
            }
            if (height < this.fInputGD.minimumHeight) {
                height = -1;
            }
            if (explicit) {
                this.fLastExplicit = height;
            }
            if (this.fInputGD.heightHint == height) {
                return;
            }
            this.fInputGD.heightHint = height;
            NIConsolePage.this.control.layout(new Control[]{NIConsolePage.this.inputGroup.getComposite()});
        }

        private void fontChanged() {
            this.fOutputGD.minimumHeight = LayoutUtils.hintHeight((StyledText)NIConsolePage.this.outputViewer.getTextWidget(), (int)4);
            ScrollBar bar = NIConsolePage.this.outputViewer.getTextWidget().getHorizontalBar();
            if (bar.isVisible()) {
                this.fOutputGD.minimumHeight += bar.getSize().y;
            }
            this.fInputGD.minimumHeight = ((NIConsolePage)NIConsolePage.this).inputGroup.getComposite().computeSize((int)800, (int)-1).y;
            if (this.fInputGD.heightHint != -1 && this.fInputGD.minimumHeight > this.fInputGD.heightHint) {
                this.fInputGD.heightHint = -1;
            }
        }
    }

    private class StatusListener
    implements IDebugEventSetListener {
        private boolean isProcessing = false;
        private boolean isTerminated = false;
        private int updateId = Integer.MIN_VALUE;
        private Prompt fNewPrompt = null;
        private boolean fCurrentBusy = false;
        private boolean fNewBusy = false;

        private StatusListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            ToolController controller = NIConsolePage.this.getConsole().getProcess().getController();
            StatusListener statusListener = this;
            synchronized (statusListener) {
                if (controller != null) {
                    ToolStatus status = controller.getStatus();
                    this.isProcessing = status == ToolStatus.STARTED_PROCESSING || status == ToolStatus.STARTING;
                    this.isTerminated = status == ToolStatus.TERMINATED;
                    this.fNewBusy = this.isProcessing || this.isTerminated;
                    this.fCurrentBusy = this.fNewBusy;
                } else {
                    this.isProcessing = false;
                    this.isTerminated = true;
                    this.fNewBusy = true;
                    this.fCurrentBusy = true;
                }
                NIConsolePage.this.inputGroup.updatePrompt(null);
                NIConsolePage.this.inputGroup.updateBusy(this.fCurrentBusy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDebugEvents(DebugEvent[] events) {
            int thisId;
            long schedule;
            ToolProcess process = NIConsolePage.this.getConsole().getProcess();
            ToolWorkspace data = process.getWorkspaceData();
            Prompt prompt = null;
            boolean match = false;
            Object object = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = object[n2];
                if (event.getSource() == process) {
                    if (event.getKind() == 8) {
                        match = true;
                        this.isTerminated = true;
                        NIConsolePage.this.onToolTerminated();
                    }
                } else if (event.getSource() == process.getQueue()) {
                    if (Queue.isStateChange((DebugEvent)event)) {
                        Queue.StateDelta delta = (Queue.StateDelta)event.getData();
                        match = true;
                        this.isProcessing = delta.newState == 2;
                        this.isTerminated = delta.newState == 6;
                    }
                } else if (event.getSource() == data && event.getKind() == 16 && event.getDetail() == 1) {
                    match = true;
                    prompt = (Prompt)event.getData();
                }
                ++n2;
            }
            if (!match) {
                return;
            }
            object = this;
            synchronized (object) {
                this.fNewBusy = this.isProcessing || this.isTerminated;
                long l = schedule = this.fNewBusy ? System.nanoTime() + 50000000L : System.nanoTime();
                if (prompt != null) {
                    this.fNewPrompt = prompt;
                }
                if (!NIConsolePage.this.isCreated || this.fNewBusy == this.fCurrentBusy && this.fNewPrompt == null) {
                    return;
                }
                thisId = ++this.updateId;
            }
            UIAccess.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long diff = (schedule - System.nanoTime()) / 1000000L;
                    if (diff > 5L) {
                        Display.getCurrent().timerExec((int)diff, (Runnable)this);
                        return;
                    }
                    if (!NIConsolePage.this.isCreated) {
                        return;
                    }
                    StatusListener statusListener = StatusListener.this;
                    synchronized (statusListener) {
                        if (thisId != StatusListener.this.updateId) {
                            return;
                        }
                        if (StatusListener.this.fNewPrompt != null) {
                            NIConsolePage.this.inputGroup.updatePrompt(StatusListener.this.fNewPrompt);
                            StatusListener.this.fNewPrompt = null;
                        }
                        if (StatusListener.this.fNewBusy != StatusListener.this.fCurrentBusy) {
                            NIConsolePage.this.inputGroup.updateBusy(StatusListener.this.fNewBusy);
                            StatusListener.this.fCurrentBusy = StatusListener.this.fNewBusy;
                        }
                    }
                }
            });
        }
    }
}

