/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.settings;

import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.preferences.ui.RGBPref;
import org.eclipse.statet.ecommons.ui.ColorManager;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ltk.ui.LTKUIPreferences;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class AssistPreferences {
    private static final Preference.BooleanPref CONTENT_ASSIST_AUTO_ACTIVATION_ENABLED_PREF = new Preference.BooleanPref("org.eclipse.statet.ltk.ui/assist", "ContentAssist.AutoActivation.enabled");
    private final String qualifier;
    private final Preference.BooleanPref fAutoActivationEnabled;
    private final Preference.IntPref fAutoActivationDelay;
    private final Preference.BooleanPref fAutoInsertSingle;
    private final Preference.BooleanPref fAutoInsertPrefix;
    private final RGBPref fInformationBackground;
    private final RGBPref fInformationForeground;

    public AssistPreferences(String prefQualifier) {
        this.qualifier = prefQualifier;
        this.fAutoActivationEnabled = CONTENT_ASSIST_AUTO_ACTIVATION_ENABLED_PREF;
        this.fAutoActivationDelay = LTKUIPreferences.CONTENT_ASSIST_DELAY_PREF;
        this.fAutoInsertSingle = new Preference.BooleanPref(prefQualifier, "AutoInsert.Single.enable");
        this.fAutoInsertPrefix = new Preference.BooleanPref(prefQualifier, "AutoInsert.Prefix.enable");
        this.fInformationBackground = LTKUIPreferences.CONTEXT_INFO_BACKGROUND_COLOR_PREF;
        this.fInformationForeground = LTKUIPreferences.CONTEXT_INFO_FOREGROUND_COLOR_PREF;
    }

    public String getGroupId() {
        return this.qualifier;
    }

    public Preference.BooleanPref getAutoActivationEnabledPref() {
        return this.fAutoActivationEnabled;
    }

    public Preference.BooleanPref getAutoInsertSinglePref() {
        return this.fAutoInsertSingle;
    }

    public Preference.BooleanPref getAutoInsertPrefixPref() {
        return this.fAutoInsertPrefix;
    }

    public void configure(ContentAssistant assistant) {
        ColorManager manager = SharedUIResources.getColors();
        PreferenceAccess prefs = PreferenceUtils.getInstancePrefs();
        assistant.enableAutoActivation(((Boolean)prefs.getPreferenceValue((Preference)this.fAutoActivationEnabled)).booleanValue());
        assistant.setAutoActivationDelay(((Integer)prefs.getPreferenceValue((Preference)this.fAutoActivationDelay)).intValue());
        assistant.enableAutoInsert(((Boolean)prefs.getPreferenceValue((Preference)this.fAutoInsertSingle)).booleanValue());
        assistant.enablePrefixCompletion(((Boolean)prefs.getPreferenceValue((Preference)this.fAutoInsertPrefix)).booleanValue());
        Color c = manager.getColor((RGB)prefs.getPreferenceValue((Preference)this.fInformationForeground));
        assistant.setContextInformationPopupForeground(c);
        assistant.setContextSelectorForeground(c);
        c = manager.getColor((RGB)prefs.getPreferenceValue((Preference)this.fInformationBackground));
        assistant.setContextInformationPopupBackground(c);
        assistant.setContextSelectorBackground(c);
    }

    public void configure(IQuickAssistAssistant assistant) {
    }
}

