/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style.editor;

import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractStyleEditorDialog
extends Dialog {
    private boolean cancelPressed = false;
    private Point location;

    public AbstractStyleEditorDialog(Shell parent) {
        super(parent, 67680);
    }

    public void setLocation(Point location) {
        this.location = new Point(location.x, location.y);
    }

    private void setLocation(Shell shell) {
        if (this.location != null) {
            if (this.location.x < this.getParent().getDisplay().getBounds().x) {
                this.location.x = this.getParent().getDisplay().getBounds().x;
            } else if (this.location.x + shell.getBounds().width > this.getParent().getDisplay().getBounds().x + this.getParent().getDisplay().getBounds().width) {
                this.location.x = this.getParent().getDisplay().getBounds().x + this.getParent().getDisplay().getBounds().width - shell.getBounds().width;
            }
            if (this.location.y + shell.getBounds().height > this.getParent().getDisplay().getBounds().y + this.getParent().getDisplay().getBounds().height) {
                this.location.y = this.getParent().getDisplay().getBounds().y + this.getParent().getDisplay().getBounds().height - shell.getBounds().height;
            }
            shell.setLocation(this.location);
        }
    }

    protected abstract void initComponents(Shell var1);

    public void open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setImage(GUIHelper.getImage("preferences"));
        shell.setText(this.getText());
        this.initComponents(shell);
        this.createButtons(shell);
        shell.pack();
        this.setLocation(shell);
        shell.open();
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createButtons(final Shell shell) {
        Composite buttonPanel = new Composite((Composite)shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginLeft = 65;
        buttonPanel.setLayout((Layout)gridLayout);
        GridData gridLayoutData = new GridData();
        gridLayoutData.horizontalAlignment = 768;
        buttonPanel.setLayoutData((Object)gridLayoutData);
        Button okButton = new Button(buttonPanel, 8);
        okButton.setText(Messages.getString("AbstractStyleEditorDialog.okButton"));
        okButton.setLayoutData((Object)new GridData(70, 25));
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractStyleEditorDialog.this.doFormOK(shell);
            }
        });
        Button clearButton = new Button(buttonPanel, 8);
        clearButton.setText(Messages.getString("AbstractStyleEditorDialog.clearButton"));
        clearButton.setToolTipText(Messages.getString("AbstractStyleEditorDialog.clearButtonTooltip"));
        clearButton.setLayoutData((Object)new GridData(80, 25));
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractStyleEditorDialog.this.doFormClear(shell);
            }
        });
        Button cancelButton = new Button(buttonPanel, 0);
        cancelButton.setText(Messages.getString("AbstractStyleEditorDialog.cancelButton"));
        cancelButton.setLayoutData((Object)new GridData(80, 25));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractStyleEditorDialog.this.doFormCancel(shell);
            }
        });
        shell.setDefaultButton(okButton);
    }

    protected abstract void doFormOK(Shell var1);

    protected void doFormCancel(Shell shell) {
        this.cancelPressed = true;
        shell.dispose();
    }

    protected void doFormClear(Shell shell) {
        shell.dispose();
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }
}

