/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell.decorator;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.style.ConfigAttribute;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;

public class PercentageBarDecorator
extends CellPainterWrapper {
    public static final ConfigAttribute<Color> PERCENTAGE_BAR_COMPLETE_REGION_START_COLOR = new ConfigAttribute();
    public static final ConfigAttribute<Color> PERCENTAGE_BAR_COMPLETE_REGION_END_COLOR = new ConfigAttribute();
    public static final ConfigAttribute<Color> PERCENTAGE_BAR_INCOMPLETE_REGION_COLOR = new ConfigAttribute();
    private static final Color DEFAULT_COMPLETE_REGION_START_COLOR = GUIHelper.getColor(new RGB(187, 216, 254));
    private static final Color DEFAULT_COMPLETE_REGION_END_COLOR = GUIHelper.getColor(new RGB(255, 255, 255));

    public PercentageBarDecorator(ICellPainter interiorPainter) {
        super(interiorPainter);
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle lRectangle, IConfigRegistry configRegistry) {
        Pattern originalBackgroundPattern = gc.getBackgroundPattern();
        double factor = Math.min(1.0, (Double)cell.getDataValue(0, null));
        factor = Math.max(0.0, factor);
        LRectangle bar = new LRectangle(lRectangle.x, lRectangle.y, (long)((double)lRectangle.width * factor), lRectangle.height);
        Rectangle rect = GraphicsUtils.safe(bar);
        LRectangle bounds = cell.getBounds();
        Color color1 = CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(PERCENTAGE_BAR_COMPLETE_REGION_START_COLOR);
        Color color2 = CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(PERCENTAGE_BAR_COMPLETE_REGION_END_COLOR);
        if (color1 == null) {
            color1 = DEFAULT_COMPLETE_REGION_START_COLOR;
        }
        if (color2 == null) {
            color2 = DEFAULT_COMPLETE_REGION_END_COLOR;
        }
        Pattern pattern = new Pattern((Device)Display.getCurrent(), (float)bounds.x, (float)bounds.y, (float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height), color1, color2);
        gc.setBackgroundPattern(pattern);
        gc.fillRectangle(rect);
        gc.setBackgroundPattern(originalBackgroundPattern);
        pattern.dispose();
        Color incompleteRegionColor = CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(PERCENTAGE_BAR_INCOMPLETE_REGION_COLOR);
        if (incompleteRegionColor != null) {
            Region incompleteRegion = new Region();
            incompleteRegion.add(GraphicsUtils.safe(lRectangle));
            incompleteRegion.subtract(rect);
            Color originalBackgroundColor = gc.getBackground();
            gc.setBackground(incompleteRegionColor);
            gc.fillRectangle(incompleteRegion.getBounds());
            gc.setBackground(originalBackgroundColor);
            incompleteRegion.dispose();
        }
        super.paintCell(cell, gc, lRectangle, configRegistry);
    }
}

