/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.event.IVisualChangeEvent;

public abstract class RowVisualChangeEvent
implements IVisualChangeEvent {
    private ILayer layer;
    private Collection<LRange> rowPositionRanges = new ArrayList<LRange>();

    public RowVisualChangeEvent(ILayer layer, LRange ... rowPositionRanges) {
        this(layer, Arrays.asList(rowPositionRanges));
    }

    public RowVisualChangeEvent(ILayer layer, Collection<LRange> rowPositionRanges) {
        this.layer = layer;
        this.rowPositionRanges = rowPositionRanges;
    }

    protected RowVisualChangeEvent(RowVisualChangeEvent event) {
        this.layer = event.layer;
        this.rowPositionRanges = event.rowPositionRanges;
    }

    @Override
    public ILayer getLayer() {
        return this.layer;
    }

    public Collection<LRange> getRowPositionRanges() {
        return this.rowPositionRanges;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        this.rowPositionRanges = localLayer.getDim(Orientation.VERTICAL).underlyingToLocalPositions(this.layer.getDim(Orientation.VERTICAL), this.rowPositionRanges);
        this.layer = localLayer;
        return this.rowPositionRanges != null && this.rowPositionRanges.size() > 0;
    }

    @Override
    public Collection<LRectangle> getChangedPositionRectangles() {
        ArrayList<LRectangle> changedPositionRectangles = new ArrayList<LRectangle>();
        long columnCount = this.layer.getColumnCount();
        for (LRange lRange : this.rowPositionRanges) {
            changedPositionRectangles.add(new LRectangle(0L, lRange.start, columnCount, lRange.end - lRange.start));
        }
        return changedPositionRectangles;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

