/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.event.IVisualChangeEvent;

public abstract class ColumnVisualChangeEvent
implements IVisualChangeEvent {
    private ILayer layer;
    private Collection<LRange> columnPositionRanges;

    public ColumnVisualChangeEvent(ILayer layer, LRange ... columnPositionRanges) {
        this(layer, Arrays.asList(columnPositionRanges));
    }

    public ColumnVisualChangeEvent(ILayer layer, Collection<LRange> columnPositionRanges) {
        this.layer = layer;
        this.columnPositionRanges = columnPositionRanges;
    }

    protected ColumnVisualChangeEvent(ColumnVisualChangeEvent event) {
        this.layer = event.layer;
        this.columnPositionRanges = event.columnPositionRanges;
    }

    @Override
    public ILayer getLayer() {
        return this.layer;
    }

    public Collection<LRange> getColumnPositionRanges() {
        return this.columnPositionRanges;
    }

    protected void setColumnPositionRanges(Collection<LRange> columnPositionRanges) {
        this.columnPositionRanges = columnPositionRanges;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        this.columnPositionRanges = localLayer.getDim(Orientation.HORIZONTAL).underlyingToLocalPositions(this.layer.getDim(Orientation.HORIZONTAL), this.columnPositionRanges);
        this.layer = localLayer;
        return this.columnPositionRanges != null && this.columnPositionRanges.size() > 0;
    }

    @Override
    public Collection<LRectangle> getChangedPositionRectangles() {
        ArrayList<LRectangle> changedPositionRectangles = new ArrayList<LRectangle>();
        long rowCount = this.layer.getRowCount();
        for (LRange lRange : this.columnPositionRanges) {
            changedPositionRectangles.add(new LRectangle(lRange.start, 0L, lRange.end - lRange.start, rowCount));
        }
        return changedPositionRectangles;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

