/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;

public class LayerUtil {
    public static final long convertPosition(ILayerDim sourceDim, long sourceRefPosition, long sourcePosition, ILayerDim targetDim) {
        if (targetDim == sourceDim) {
            return sourcePosition;
        }
        try {
            long id = sourceDim.getPositionId(sourceRefPosition, sourcePosition);
            return targetDim.getPositionById(id);
        }
        catch (PositionOutOfBoundsException e) {
            return Long.MIN_VALUE;
        }
    }

    public static final long convertColumnPosition(ILayer sourceLayer, long sourceColumnPosition, ILayer targetLayer) {
        return LayerUtil.convertPosition(sourceLayer.getDim(Orientation.HORIZONTAL), sourceColumnPosition, sourceColumnPosition, targetLayer.getDim(Orientation.HORIZONTAL));
    }

    public static final long convertRowPosition(ILayer sourceLayer, long sourceRowPosition, ILayer targetLayer) {
        return LayerUtil.convertPosition(sourceLayer.getDim(Orientation.VERTICAL), sourceRowPosition, sourceRowPosition, targetLayer.getDim(Orientation.VERTICAL));
    }
}

