/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer;

import java.util.Properties;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.layer.ForwardLayerDim;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.cell.ForwardLayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;
import org.eclipse.statet.ecommons.waltable.ui.IClientAreaProvider;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;

public abstract class ForwardLayer
extends AbstractLayer {
    private final ILayer underlyingLayer;

    public ForwardLayer(ILayer underlyingLayer) {
        if (underlyingLayer == null) {
            throw new NullPointerException("underlyingLayer");
        }
        this.underlyingLayer = underlyingLayer;
        this.underlyingLayer.setClientAreaProvider(this.getClientAreaProvider());
        this.underlyingLayer.addLayerListener(this);
        this.initDims();
    }

    @Override
    protected void initDims() {
        ILayer underlying = this.getUnderlyingLayer();
        if (underlying == null) {
            return;
        }
        this.setDim(new ForwardLayerDim<ForwardLayer>(this, underlying.getDim(Orientation.HORIZONTAL)));
        this.setDim(new ForwardLayerDim<ForwardLayer>(this, underlying.getDim(Orientation.VERTICAL)));
    }

    protected void setUnderlyingLayer(ILayer underlyingLayer) {
    }

    protected final ILayer getUnderlyingLayer() {
        return this.underlyingLayer;
    }

    @Override
    public void dispose() {
        this.underlyingLayer.dispose();
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        this.underlyingLayer.saveState(prefix, properties);
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.underlyingLayer.loadState(prefix, properties);
        super.loadState(prefix, properties);
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        this.underlyingLayer.configure(configRegistry, uiBindingRegistry);
        super.configure(configRegistry, uiBindingRegistry);
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter != null ? this.layerPainter : this.underlyingLayer.getLayerPainter();
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (super.doCommand(command)) {
            return true;
        }
        if (this.underlyingLayer != null) {
            return this.underlyingLayer.doCommand(command);
        }
        return false;
    }

    @Override
    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        super.setClientAreaProvider(clientAreaProvider);
        if (this.getUnderlyingLayer() != null) {
            this.getUnderlyingLayer().setClientAreaProvider(clientAreaProvider);
        }
    }

    @Override
    public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
        ILayerCell underlyingCell = this.underlyingLayer.getCellByPosition(columnPosition, rowPosition);
        return this.createCell(underlyingCell.getDim(Orientation.HORIZONTAL), underlyingCell.getDim(Orientation.VERTICAL), underlyingCell);
    }

    protected ILayerCell createCell(ILayerCellDim hDim, ILayerCellDim vDim, ILayerCell underlyingCell) {
        return new ForwardLayerCell(this, hDim, vDim, underlyingCell);
    }

    @Override
    public LabelStack getRegionLabelsByXY(long x, long y) {
        return this.underlyingLayer.getRegionLabelsByXY(x, y);
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
        return this.underlyingLayer;
    }
}

