/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.mpbv.ManagedPageBookView;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookSession;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.ui.actions.CompoundContributionItem;

@NonNullByDefault
public class ShowPageDropdownContribution<S extends PageBookSession>
extends CompoundContributionItem {
    private final ManagedPageBookView<S> view;

    public ShowPageDropdownContribution(ManagedPageBookView<S> view) {
        this.view = view;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<ContributionItem> list = new ArrayList<ContributionItem>();
        ImList<S> sessions = this.view.getSessions();
        int i = 0;
        while (i < sessions.size()) {
            list.add(this.createPageContribution((PageBookSession)sessions.get(i), i + 1));
            ++i;
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    private ContributionItem createPageContribution(S session, int num) {
        ImageDescriptor imageDescriptor = session.getImageDescriptor();
        String label = session.getLabel();
        String mnemonic = null;
        if (num < 10) {
            mnemonic = Integer.toString(num);
            label = String.valueOf(mnemonic) + " " + label;
        }
        SimpleContributionItem item = new SimpleContributionItem(label, mnemonic, imageDescriptor, null, 16, (PageBookSession)session){
            private final /* synthetic */ PageBookSession val$session;
            {
                this.val$session = pageBookSession;
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
            }

            @Override
            protected void execute() throws ExecutionException {
                ShowPageDropdownContribution.this.view.showPage(this.val$session);
            }
        };
        if (this.view.getCurrentSession() == session) {
            item.setChecked(true);
        }
        return item;
    }
}

