/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.PotentialBracketCloseDelimiter;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.PotentialBracketOpenDelimiter;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.PotentialBracketRegex;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class PotentialBracketSpan
extends SourceSpan {
    private @Nullable PotentialBracketRegex shared;

    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        char c = cursor.getChar();
        if (c == '!' && cursor.hasNext() && cursor.getNext() == '[') {
            return new PotentialBracketOpenDelimiter(cursor.getLineAtOffset(), cursor.getOffset(), 2, "![");
        }
        if (c == '[') {
            return new PotentialBracketOpenDelimiter(cursor.getLineAtOffset(), cursor.getOffset(), 1, "[");
        }
        if (c == ']') {
            return new PotentialBracketCloseDelimiter(cursor.getLineAtOffset(), cursor.getOffset(), this.getShared());
        }
        return null;
    }

    private PotentialBracketRegex getShared() {
        if (this.shared == null) {
            this.shared = new PotentialBracketRegex();
        }
        return this.shared;
    }
}

