/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.LabelInfo;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Characters;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Image;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineWithNestedContents;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineWithText;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Link;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.PotentialBracketOpenDelimiter;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.PotentialBracketRegex;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.ReferenceDefinition;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class PotentialBracketCloseDelimiter
extends InlineWithText {
    private final PotentialBracketRegex shared;

    private static int findLastPotentialBracketDelimiter(List<Inline> inlines) {
        int idx = inlines.size() - 1;
        while (idx >= 0) {
            Inline inline = inlines.get(idx);
            if (inline instanceof PotentialBracketOpenDelimiter) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    private static boolean isIndentInline(Inline inline, Line line) {
        return inline instanceof Characters && inline.getStartOffset() == line.getStartOffset() && inline.getLength() == line.getIndentLength();
    }

    public PotentialBracketCloseDelimiter(Line line, int offset, PotentialBracketRegex shared) {
        super(line, offset, 1, 1, "]");
        this.shared = shared;
    }

    @Override
    public void apply(ProcessingContext context, List<Inline> inlines, Cursor cursor, boolean inBlock) {
        int openingDelimiterIndex = PotentialBracketCloseDelimiter.findLastPotentialBracketDelimiter(inlines);
        if (openingDelimiterIndex >= 0) {
            PotentialBracketOpenDelimiter openingDelimiter = (PotentialBracketOpenDelimiter)inlines.get(openingDelimiterIndex);
            if (openingDelimiter.isActive()) {
                List<Inline> contents = InlineParser.secondPass(inlines.subList(openingDelimiterIndex + 1, inlines.size()));
                if (!openingDelimiter.isLinkDelimiter() || !this.containsLink(contents)) {
                    Matcher matcher;
                    PotentialBracketRegex.LinkDestination linkDestination;
                    boolean referenceDefinition;
                    int length = 0;
                    if (inBlock && cursor.hasNext() && cursor.getNext() == ':' && this.isEligibleForReferenceDefinition(inlines, openingDelimiter, openingDelimiterIndex)) {
                        referenceDefinition = true;
                        linkDestination = this.shared.readLinkDestination(context, cursor.getTextAtOffset(), 2);
                        if (linkDestination != null) {
                            length = linkDestination.getEndOffset();
                            matcher = cursor.setup(this.shared.getReferenceDefinitionEndMatcher(), length);
                        } else {
                            matcher = null;
                        }
                    } else if (cursor.hasNext() && cursor.getNext() == '(') {
                        referenceDefinition = false;
                        linkDestination = this.shared.readLinkDestination(context, cursor.getTextAtOffset(), 2);
                        if (linkDestination != null) {
                            length = linkDestination.getEndOffset();
                            matcher = cursor.setup(this.shared.getEndMatcher(), length);
                        } else {
                            length = 2;
                            matcher = cursor.setup(this.shared.getEndMatcher(), length);
                        }
                    } else {
                        referenceDefinition = false;
                        linkDestination = null;
                        matcher = null;
                    }
                    if (matcher != null && matcher.matches()) {
                        LabelInfo referenceLabel;
                        LabelInfo labelInfo = referenceLabel = referenceDefinition ? this.referenceLabel(context, cursor, contents) : null;
                        if (!referenceDefinition || referenceLabel != null) {
                            String uri;
                            String title = this.linkTitle(matcher, context, cursor);
                            cursor.advance(length += matcher.end(2) - matcher.regionStart());
                            int startOffset = openingDelimiter.getStartOffset();
                            int endOffset = cursor.getOffset();
                            this.truncate(inlines, openingDelimiter, openingDelimiterIndex, referenceDefinition);
                            if (openingDelimiter.isLinkDelimiter()) {
                                this.inactivatePreceding(inlines);
                            }
                            String string = uri = linkDestination != null ? this.normalizeUri(context.getHelper().replaceEscaping(linkDestination.getEscapedUri())) : "";
                            if (referenceDefinition) {
                                inlines.add(new ReferenceDefinition(openingDelimiter.getLine(), startOffset, endOffset - startOffset, uri, title, referenceLabel));
                            } else if (openingDelimiter.isImageDelimiter()) {
                                inlines.add(new Image(openingDelimiter.getLine(), startOffset, endOffset - startOffset, uri, title, contents));
                            } else {
                                inlines.add(new Link(openingDelimiter.getLine(), startOffset, endOffset - startOffset, uri, title, contents));
                            }
                            return;
                        }
                    } else {
                        Matcher referenceLabelMatcher;
                        length = 1;
                        LabelInfo referenceLabel = this.referenceLabel(context, cursor, contents);
                        if (cursor.hasNext() && (referenceLabelMatcher = cursor.setup(this.shared.getReferenceLabelMatcher(), 1)).matches()) {
                            String label = context.normalizeLabel(referenceLabelMatcher.group(2));
                            if (label != null) {
                                int start = cursor.getMatcherOffset(referenceLabelMatcher.start(2));
                                int end = cursor.getMatcherOffset(referenceLabelMatcher.end(2));
                                referenceLabel = new LabelInfo(label, start, end);
                            }
                            length += referenceLabelMatcher.end(1) - referenceLabelMatcher.regionStart();
                        }
                        if (referenceLabel != null) {
                            if (context.getMode() == 3) {
                                cursor.advance(length);
                                int startOffset = openingDelimiter.getStartOffset();
                                int endOffset = cursor.getOffset();
                                this.truncate(inlines, openingDelimiter, openingDelimiterIndex, false);
                                if (openingDelimiter.isLinkDelimiter()) {
                                    this.inactivatePreceding(inlines);
                                }
                                if (openingDelimiter.isLinkDelimiter()) {
                                    inlines.add(new Link(openingDelimiter.getLine(), startOffset, endOffset - startOffset, referenceLabel, (List<Inline>)ImCollections.emptyList()));
                                } else {
                                    inlines.add(new Image(openingDelimiter.getLine(), startOffset, endOffset - startOffset, referenceLabel, contents));
                                }
                                return;
                            }
                            ProcessingContext.UriWithTitle uriWithTitle = context.getNamedUri(referenceLabel.getLabel());
                            if (uriWithTitle != null) {
                                cursor.advance(length);
                                int startOffset = openingDelimiter.getStartOffset();
                                int endOffset = cursor.getOffset();
                                this.truncate(inlines, openingDelimiter, openingDelimiterIndex, false);
                                if (openingDelimiter.isLinkDelimiter()) {
                                    this.inactivatePreceding(inlines);
                                }
                                if (openingDelimiter.isLinkDelimiter()) {
                                    inlines.add(new Link(openingDelimiter.getLine(), startOffset, endOffset - startOffset, uriWithTitle.getUri(), uriWithTitle.getTitle(), contents));
                                } else {
                                    inlines.add(new Image(openingDelimiter.getLine(), startOffset, endOffset - startOffset, uriWithTitle.getUri(), uriWithTitle.getTitle(), contents));
                                }
                                return;
                            }
                        }
                    }
                }
            }
            this.replaceDelimiter(inlines, openingDelimiterIndex, openingDelimiter);
        }
        if (Characters.append(inlines, inlines.size(), this)) {
            cursor.advance(this.getLength());
            return;
        }
        super.apply(context, inlines, cursor, inBlock);
    }

    @Override
    public void emit(ProcessingContext context, CommonmarkLocator locator, DocumentBuilder builder) {
        builder.characters(this.text);
    }

    private @Nullable LabelInfo referenceLabel(ProcessingContext context, Cursor cursor, List<Inline> contents) {
        if (contents.isEmpty()) {
            return null;
        }
        int start = contents.get(0).getStartOffset();
        int end = this.getStartOffset();
        String name = cursor.getText(cursor.toCursorOffset(start), cursor.toCursorOffset(end));
        if (this.shared.getReferenceNameMatcher().reset(name).matches() && (name = context.normalizeLabel(name)) != null) {
            return new LabelInfo(name, start, end);
        }
        return null;
    }

    private boolean containsLink(List<Inline> contents) {
        for (Inline inline : contents) {
            if (inline instanceof Link) {
                return true;
            }
            if (!(inline instanceof InlineWithNestedContents) || !this.containsLink((List<Inline>)((InlineWithNestedContents)inline).getContents())) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean isEligibleForReferenceDefinition(List<Inline> inlines, PotentialBracketOpenDelimiter openingDelimiter, int openingDelimiterIndex) {
        block1: {
            block2: {
                openingLine = openingDelimiter.getLine();
                if (!openingDelimiter.isLinkDelimiter() || openingLine.getIndent() >= 4 || openingDelimiter.getStartOffset() != openingLine.getStartOffset() + openingLine.getIndentLength()) break block1;
                if (openingDelimiterIndex <= 0) break block2;
                idx = openingDelimiterIndex - 1;
                if ((inline = inlines.get(idx--)) instanceof ReferenceDefinition || PotentialBracketCloseDelimiter.isIndentInline(inline, openingLine)) ** GOTO lbl9
                return false;
lbl-1000:
                // 1 sources

                {
                    if ((inline = inlines.get(idx--)) instanceof ReferenceDefinition) continue;
                    return false;
lbl9:
                    // 2 sources

                    ** while (idx >= 0)
                }
            }
            return true;
        }
        return false;
    }

    private String linkTitle(Matcher matcher, ProcessingContext context, Cursor cursor) {
        int start = matcher.start(1);
        if (start != -1) {
            int end = matcher.end(1);
            String title = cursor.getText(start + 1, end - 1);
            return context.getHelper().replaceEscaping(title);
        }
        return "";
    }

    private String normalizeUri(String uri) {
        try {
            String decoded = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
            Escaper escaper = UrlEscapers.urlFragmentEscaper();
            int indexOfHash = decoded.indexOf(35);
            if (indexOfHash != -1) {
                String uriWithHash = String.valueOf(escaper.escape(decoded.substring(0, indexOfHash))) + '#';
                if (indexOfHash + 1 < decoded.length()) {
                    uriWithHash = String.valueOf(uriWithHash) + escaper.escape(decoded.substring(indexOfHash + 1));
                }
                return uriWithHash;
            }
            return escaper.escape(decoded);
        }
        catch (Exception e) {
            return uri;
        }
    }

    public void truncate(List<Inline> inlines, PotentialBracketOpenDelimiter openingDelimiter, int indexOfOpeningDelimiter, boolean removeIndent) {
        while (inlines.size() > indexOfOpeningDelimiter) {
            inlines.remove(indexOfOpeningDelimiter);
        }
        if (removeIndent && indexOfOpeningDelimiter > 0 && PotentialBracketCloseDelimiter.isIndentInline(inlines.get(indexOfOpeningDelimiter - 1), openingDelimiter.getLine())) {
            inlines.remove(indexOfOpeningDelimiter - 1);
        }
    }

    private void inactivatePreceding(List<Inline> inlines) {
        int idx = inlines.size() - 1;
        while (idx >= 0) {
            PotentialBracketOpenDelimiter openDelimiter;
            Inline inline = inlines.get(idx);
            if (inline instanceof PotentialBracketOpenDelimiter && (openDelimiter = (PotentialBracketOpenDelimiter)inline).isLinkDelimiter()) {
                if (openDelimiter.isActive()) {
                    openDelimiter.setInactive();
                } else {
                    return;
                }
            }
            --idx;
        }
    }

    private void replaceDelimiter(List<Inline> inlines, int index, PotentialBracketOpenDelimiter delimiter) {
        if (Characters.append(inlines, index, delimiter)) {
            inlines.remove(index);
            return;
        }
        inlines.set(index, new Characters(delimiter.getLine(), delimiter.getStartOffset(), delimiter.getLength(), delimiter.getCursorLength(), delimiter.getText()));
    }
}

