/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class EscapedCharacter
extends Inline {
    private final char character;

    public EscapedCharacter(Line line, int offset, char c) {
        super(line, offset, 2, 2);
        this.character = c;
    }

    public char getCharacter() {
        return this.character;
    }

    @Override
    public void emit(ProcessingContext context, CommonmarkLocator locator, DocumentBuilder builder) {
        builder.characters(Character.toString(this.character));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getStartOffset(), this.getLength(), Character.valueOf(this.character));
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj)) {
            EscapedCharacter other = (EscapedCharacter)obj;
            return this.character == other.character;
        }
        return false;
    }
}

