/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceElementAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class FencedCodeBlock
extends SourceBlock {
    private static final Pattern START_PATTERN = Pattern.compile("(?:`{3,}|~{3,})[^`]*", 32);
    private static final Pattern OPEN_PATTERN = Pattern.compile("(`{3,}|~{3,})[ \t]*([^ \t`]+)?.*", 32);
    private static final Pattern CLOSE_BACKTICK_PATTERN = Pattern.compile("(`{3,})[ \t]*", 32);
    private static final Pattern CLOSE_TILDE_PATTERN = Pattern.compile("(~{3,})[ \t]*", 32);
    private final Matcher startMatcher = START_PATTERN.matcher("");
    private @Nullable Matcher openMatcher;
    private @Nullable Matcher closeBacktickMatcher;
    private @Nullable Matcher closeTildeMatcher;

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockItem<?> currentBlockItem) {
        Line currentLine = lineSequence.getCurrentLine();
        return currentLine != null && !currentLine.isBlank() && currentLine.getIndent() < 4 && currentLine.setupIndent(this.startMatcher).matches();
    }

    @Override
    public void createItem(SourceBlocks.SourceBlockBuilder builder, LineSequence lineSequence) {
        Line line;
        CodeBlockItem codeBlockItem = new CodeBlockItem(this, builder);
        Line startLine = lineSequence.getCurrentLine();
        lineSequence.advance();
        Matcher openMatcher = startLine.setup(this.getOpenMatcher(), true, false);
        FencedCodeBlock.assertMatches(openMatcher);
        int minCount = openMatcher.end(1) - openMatcher.regionStart();
        codeBlockItem.infoText = this.getInfoText(openMatcher);
        Matcher closeMatcher = this.getCloseMatcher(startLine, openMatcher);
        while ((line = lineSequence.getCurrentLine()) != null) {
            lineSequence.advance();
            if (line.isBlank() || line.getIndent() >= 4 || !line.setupIndent(closeMatcher).matches() || closeMatcher.end(1) - closeMatcher.regionStart() < minCount) continue;
            codeBlockItem.isClosed = true;
            break;
        }
    }

    @Override
    public void initializeContext(ProcessingContext context, SourceBlockItem<?> blockItem) {
    }

    @Override
    public void emit(ProcessingContext context, SourceBlockItem<?> blockItem, CommonmarkLocator locator, DocumentBuilder builder) {
        CodeBlockItem codeBlockItem = (CodeBlockItem)blockItem;
        ImList<Line> lines = blockItem.getLines();
        Line startLine = (Line)lines.get(0);
        Matcher openMatcher = startLine.setup(this.getOpenMatcher(), true, false);
        FencedCodeBlock.assertMatches(openMatcher);
        SourceElementAttributes attributes = new SourceElementAttributes(!codeBlockItem.isClosed ? 256 : 0);
        if (codeBlockItem.infoText != null) {
            String language = context.getHelper().replaceEscaping(codeBlockItem.infoText);
            attributes.setCssClass("language-" + language);
        }
        locator.setBlockBegin(blockItem);
        builder.beginBlock(DocumentBuilder.BlockType.CODE, (Attributes)attributes);
        int startIndent = startLine.getIndent();
        for (Line line : lines.subList(1, codeBlockItem.isClosed ? lines.size() - 1 : lines.size())) {
            Line codeSegment = startIndent > 0 && line.getIndent() > 0 ? line.segmentByIndent(Math.min(startIndent, line.getIndent())) : line;
            locator.setLine(codeSegment);
            builder.characters(codeSegment.getText());
            builder.characters("\n");
        }
        locator.setBlockEnd(blockItem);
        builder.endBlock();
    }

    private @Nullable String getInfoText(Matcher matcher) {
        String infoText = matcher.group(2);
        if (infoText != null && !infoText.isEmpty()) {
            return infoText;
        }
        return null;
    }

    private Matcher getOpenMatcher() {
        if (this.openMatcher == null) {
            this.openMatcher = OPEN_PATTERN.matcher("");
        }
        return this.openMatcher;
    }

    private Matcher getCloseMatcher(Line line, Matcher matcher) {
        switch (line.getText().charAt(matcher.start(1))) {
            case '`': {
                if (this.closeBacktickMatcher == null) {
                    this.closeBacktickMatcher = CLOSE_BACKTICK_PATTERN.matcher("");
                }
                return this.closeBacktickMatcher;
            }
            case '~': {
                if (this.closeTildeMatcher == null) {
                    this.closeTildeMatcher = CLOSE_TILDE_PATTERN.matcher("");
                }
                return this.closeTildeMatcher;
            }
        }
        throw new IllegalStateException();
    }

    static final class CodeBlockItem
    extends SourceBlockItem<FencedCodeBlock> {
        private @Nullable String infoText;
        private boolean isClosed;

        public CodeBlockItem(FencedCodeBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }
    }
}

