/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.docmlet.tex.core.ITexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAst;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.commands.Argument;
import org.eclipse.statet.docmlet.tex.core.commands.IEnvDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.IPreambleDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.LtxCommandDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommandSet;
import org.eclipse.statet.docmlet.tex.core.model.ILtxModelInfo;
import org.eclipse.statet.docmlet.tex.core.model.ITexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.LtxCommandCompletionProposal;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.TexLabelCompletionProposal;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxAssistInvocationContext;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.LTKUtils;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.NameAccessSet;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IContentAssistComputer;

public abstract class LtxElementCompletionComputer
implements IContentAssistComputer {
    private static List<TexCommand> PREAMBLE_DOCU_COMMANDS = ImCollections.newList((Object)IPreambleDefinitions.PREAMBLE_documentclass_COMMAND);
    private ITexCoreAccess texCoreAccess;

    protected LtxElementCompletionComputer() {
    }

    public void sessionStarted(ISourceEditor editor, ContentAssist assist) {
        ISourceUnit su = editor.getSourceUnit();
        if (su instanceof ITexSourceUnit) {
            this.texCoreAccess = ((ITexSourceUnit)su).getTexCoreAccess();
        }
    }

    public void sessionEnded() {
        this.texCoreAccess = null;
    }

    protected final ITexCoreAccess getTexCoreAccess() {
        return this.texCoreAccess != null ? this.texCoreAccess : TexCore.getWorkbenchAccess();
    }

    protected abstract boolean isMath();

    public IStatus computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        LtxAssistInvocationContext texContext;
        int argIdx;
        String prefix = context.getIdentifierPrefix();
        ILtxModelInfo modelInfo = context.getModelInfo() instanceof ILtxModelInfo ? (ILtxModelInfo)context.getModelInfo() : null;
        TexCommandSet commandSet = this.getTexCoreAccess().getTexCommandSet();
        if (prefix.length() > 0 && prefix.charAt(0) == '\\') {
            int offset = context.getInvocationOffset() - prefix.length() + 1;
            this.addCommands(context, prefix, this.isMath() ? commandSet.getLtxMathCommandsASorted() : commandSet.getLtxTextCommandsASorted(), modelInfo != null ? modelInfo.getCustomCommandMap().values() : null, proposals);
            if (modelInfo != null && !this.isMath() && modelInfo.getSourceElement() != null) {
                List elements = modelInfo.getSourceElement().getSourceChildren(null);
                ISourceStructElement element = LTKUtils.getCoveringSourceElement((List)elements, (int)offset);
                if (element != null && (element.getElementType() & 0xFF0) == 1040) {
                    this.addCommands(context, prefix, commandSet.getLtxPreambleCommandsASorted(), null, proposals);
                } else if (prefix.startsWith("\\docu") && (elements.size() == 0 || offset < ((ISourceStructElement)elements.get(0)).getSourceRange().getStartOffset())) {
                    this.addCommands(context, prefix, PREAMBLE_DOCU_COMMANDS, null, proposals);
                }
                if (!this.isMath() && context.getAstSelection().getCovering() instanceof TexAstNode) {
                    TexAstNode texNode = (TexAstNode)context.getAstSelection().getCovering();
                    while (texNode != null) {
                        TexCommand command;
                        if (texNode.getNodeType() == TexAst.NodeType.CONTROL && (command = ((ControlNode)texNode).getCommand()) != null && (command.getType() & 0xFF) == 52) {
                            this.addCommands(context, prefix, commandSet.getLtxMathCommandsASorted(), null, proposals);
                            break;
                        }
                        texNode = texNode.getTexParent();
                    }
                }
            }
        } else if (context instanceof LtxAssistInvocationContext && (argIdx = (texContext = (LtxAssistInvocationContext)context).getInvocationArgIdx()) >= 0) {
            TexCommand command = texContext.getInvocationControlNode().getCommand();
            Argument argDef = (Argument)command.getArguments().get(argIdx);
            TexAstNode argNode = texContext.getInvocationArgNodes()[argIdx];
            int offset = texContext.getInvocationOffset() - prefix.length();
            TextRegion region = TexAst.getInnerRegion((TexAstNode)argNode);
            if (region != null && region.getStartOffset() <= offset && offset <= region.getEndOffset()) {
                if (argIdx == 0 && ((command.getType() & 0xF) == 1 || (command.getType() & 0xF) == 2)) {
                    ArrayList<String> prefered = new ArrayList<String>();
                    if (command == IEnvDefinitions.GENERICENV_end_COMMAND) {
                        ControlNode node = texContext.getInvocationControlNode();
                        while (node != null) {
                            String name;
                            if (!(node.getNodeType() != TexAst.NodeType.ENVIRONMENT || !prefered.isEmpty() && (node.getStatusCode() & 0xFFFF) != 8465 || (name = node.getText()).isEmpty() || prefered.contains(name))) {
                                prefered.add(name);
                            }
                            node = node.getTexParent();
                        }
                    }
                    this.addEnvs(context, prefix, this.isMath() ? commandSet.getLtxMathEnvsASorted() : commandSet.getLtxTextEnvsASorted(), modelInfo != null ? modelInfo.getCustomEnvMap().values() : null, prefered, proposals);
                } else {
                    switch (argDef.getContent()) {
                        case 50: {
                            if (modelInfo == null) break;
                            NameAccessSet labels = modelInfo.getLabels();
                            block6: for (String label : labels.getNames()) {
                                ImList accessList = labels.getAllInUnit(label);
                                boolean isDef = false;
                                for (TexNameAccess access : accessList) {
                                    if (!access.isWriteAccess()) continue;
                                    if (this.isDef(access, offset)) {
                                        isDef = true;
                                        continue;
                                    }
                                    proposals.add((IAssistCompletionProposal)new TexLabelCompletionProposal(context, offset, (TexNameAccess)accessList.get(0), 94));
                                    continue block6;
                                }
                                if (isDef) continue;
                                proposals.add((IAssistCompletionProposal)new TexLabelCompletionProposal(context, offset, (TexNameAccess)accessList.get(0), 95));
                            }
                            break;
                        }
                        case 51: {
                            if (modelInfo == null) break;
                            NameAccessSet labels = modelInfo.getLabels();
                            block8: for (String label : labels.getNames()) {
                                ImList accessList = labels.getAllInUnit(label);
                                for (TexNameAccess access : accessList) {
                                    if (!access.isWriteAccess()) continue;
                                    proposals.add((IAssistCompletionProposal)new TexLabelCompletionProposal(context, offset, (TexNameAccess)accessList.get(0), 95));
                                    continue block8;
                                }
                                if (accessList.size() == 1 && this.isDef((TexNameAccess)accessList.get(0), offset)) continue;
                                proposals.add((IAssistCompletionProposal)new TexLabelCompletionProposal(context, offset, (TexNameAccess)accessList.get(0), 94));
                            }
                            break;
                        }
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus computeInformationProposals(AssistInvocationContext context, AssistProposalCollector tenders, IProgressMonitor monitor) {
        return null;
    }

    private void addCommands(AssistInvocationContext context, String prefix, List<TexCommand> commands, Collection<TexCommand> commands2, AssistProposalCollector proposals) {
        int offset = context.getInvocationOffset() - prefix.length() + 1;
        int length = prefix.length() - 1;
        for (TexCommand command : commands) {
            if (prefix.length() != 1 && !command.getControlWord().regionMatches(true, 0, prefix, 1, length) || (command.getType() & 0xFF) == 42) continue;
            proposals.add((IAssistCompletionProposal)new LtxCommandCompletionProposal(context, offset, command));
        }
        if (commands2 != null) {
            for (TexCommand command : commands2) {
                if (prefix.length() != 1 && !command.getControlWord().regionMatches(true, 0, prefix, 1, length) || (command.getType() & 0xFF) == 42) continue;
                proposals.add((IAssistCompletionProposal)new LtxCommandCompletionProposal(context, offset, command));
            }
        }
    }

    private void addEnvs(AssistInvocationContext context, String prefix, List<TexCommand> envs, Collection<TexCommand> envs2, List<String> prefered, AssistProposalCollector proposals) {
        int idx;
        int offset = context.getInvocationOffset() - prefix.length();
        int length = prefix.length();
        ArrayList<String> addedPrefered = new ArrayList<String>(prefered.size());
        for (TexCommand env : envs) {
            if (prefix.length() != 0 && !env.getControlWord().regionMatches(true, 0, prefix, 0, length)) continue;
            idx = prefered.indexOf(env.getControlWord());
            proposals.add((IAssistCompletionProposal)new LtxCommandCompletionProposal.Env(context, offset, env, idx >= 0 && idx < 5 ? 5 - idx : 0));
            if (idx < 0) continue;
            addedPrefered.add(env.getControlWord());
        }
        if (envs2 != null) {
            for (TexCommand env : envs2) {
                if (prefix.length() != 0 && !env.getControlWord().regionMatches(true, 0, prefix, 0, length)) continue;
                idx = prefered.indexOf(env.getControlWord());
                proposals.add((IAssistCompletionProposal)new LtxCommandCompletionProposal.Env(context, offset, env, idx >= 0 && idx < 5 ? 5 - idx : 0));
                if (idx < 0) continue;
                addedPrefered.add(env.getControlWord());
            }
        }
        for (String name : prefered) {
            if (prefix.length() != 0 && !name.regionMatches(true, 0, prefix, 0, length) || addedPrefered.contains(name)) continue;
            idx = prefered.indexOf(name);
            TexCommand env = LtxCommandDefinitions.getEnv((String)name);
            if (env == null) {
                env = new TexCommand(242, name, "(open environment)");
            }
            proposals.add((IAssistCompletionProposal)new LtxCommandCompletionProposal.Env(context, offset, env, idx >= 0 && idx < 5 ? 5 - idx : 0));
        }
    }

    private boolean isDef(TexNameAccess access, int offset) {
        TexAstNode nameNode = (TexAstNode)access.getNameNode();
        return nameNode != null && nameNode.getStartOffset() <= offset && nameNode.getEndOffset() >= offset;
    }

    public static class Default
    extends LtxElementCompletionComputer {
        @Override
        protected boolean isMath() {
            return false;
        }
    }

    public static class Math
    extends LtxElementCompletionComputer {
        @Override
        protected boolean isMath() {
            return true;
        }
    }
}

