/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.impl.ContentHandlerImpl;
import org.eclipse.sphinx.emf.scoping.ResourceScopeProviderRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;

public class SphinxManagedModelFileContentHandlerImpl
extends ContentHandlerImpl {
    public boolean canHandle(URI uri) {
        IFile file;
        return uri.isPlatformResource() && !ResourceScopeProviderRegistry.INSTANCE.isNotInAnyScope(file = EcorePlatformUtil.getFile(uri));
    }

    public Map<String, Object> contentDescription(URI uri, InputStream inputStream, Map<?, ?> options, Map<Object, Object> context) throws IOException {
        Set requestedProperties = this.getRequestedProperties(options);
        if (requestedProperties != null) {
            return super.contentDescription(uri, inputStream, options, context);
        }
        try {
            IFile file = EcorePlatformUtil.getFile(uri);
            String contentTypeId = ExtendedPlatform.getContentTypeId((IFile)file);
            Map result = SphinxManagedModelFileContentHandlerImpl.createContentDescription((ContentHandler.Validity)ContentHandler.Validity.VALID);
            result.put("org.eclipse.emf.ecore:contentType", contentTypeId);
            return result;
        }
        catch (CoreException ex) {
            throw new IOException(ex.getCause());
        }
    }
}

