/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.view.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.ui.interpreter.internal.InterpreterMessages;
import org.eclipse.sirius.ui.interpreter.internal.SWTUtil;
import org.eclipse.sirius.ui.interpreter.internal.view.Variable;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.VariableLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class NewVariableWizardPage
extends WizardPage {
    private static final int COLUMN_COUNT = 3;
    private static final String PAGE_DESCRIPTION = InterpreterMessages.getString("interpreter.wizard.newvariable.description");
    private static final String PAGE_NAME = "NewVariablePage";
    private static final String PAGE_TITLE = InterpreterMessages.getString("interpreter.wizard.newvariable.title");
    protected Type currentType;
    protected final List<Variable> existingVariables;
    protected Control valueControl;
    protected Text variableText;
    private final String initialVariableName;
    private String variableName;
    private IInputValidator variableValidator = new VariableNameValidator();
    private Object variableValue;

    public NewVariableWizardPage(String initialVariableName, List<Variable> existingVariables) {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.setPageComplete(false);
        this.initialVariableName = initialVariableName;
        this.existingVariables = existingVariables;
    }

    public static int getButtonWidthHint(Button button) {
        Font font = JFaceResources.getDialogFont();
        button.setFont(font);
        GC gc = new GC((Drawable)font.getDevice());
        gc.setFont(font);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createVariableControls(composite);
        this.createSeparator(composite);
        this.createTypeControls(composite);
        this.createValueControls(composite);
        this.setControl((Control)composite);
    }

    public String getVariableName() {
        return this.variableName;
    }

    public Object getVariableValue() {
        return this.variableValue;
    }

    protected void createBooleanValueControl(Composite parent) {
        if (this.valueControl != null) {
            this.valueControl.dispose();
        }
        this.valueControl = new BooleanChooser(parent);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.valueControl.setLayoutData((Object)gridData);
    }

    protected void createFloatValueControl(Composite parent) {
        if (this.valueControl != null) {
            this.valueControl.dispose();
        }
        this.valueControl = new Text(parent, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.valueControl.setLayoutData((Object)gridData);
        final RealValueValidator validator = new RealValueValidator();
        ((Text)this.valueControl).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String errorMessage = validator.isValid(((Text)NewVariableWizardPage.this.valueControl).getText());
                NewVariableWizardPage.this.setErrorMessage(errorMessage);
                NewVariableWizardPage.this.setPageComplete(NewVariableWizardPage.this.getErrorMessage() == null);
            }
        });
    }

    protected void createIntegerValueControl(Composite parent) {
        if (this.valueControl != null) {
            this.valueControl.dispose();
        }
        this.valueControl = new Spinner(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.valueControl.setLayoutData((Object)gridData);
    }

    protected void createStringValueControl(Composite parent) {
        if (this.valueControl != null) {
            this.valueControl.dispose();
        }
        this.valueControl = SWTUtil.createScrollableText(parent, 2818);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 100;
        this.valueControl.setLayoutData((Object)gridData);
    }

    protected void validateVariableName() {
        String name = this.variableText.getText();
        String errorMessage = this.variableValidator.isValid(name);
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            boolean exists = false;
            Iterator<Variable> variables = this.existingVariables.iterator();
            while (variables.hasNext() && !exists) {
                exists = name.equals(variables.next().getName());
            }
            if (exists) {
                this.setMessage(InterpreterMessages.getString("interpreter.wizard.newvariable.info.existingvariable", name), 0);
            } else {
                this.setMessage(null);
            }
        }
    }

    private void createSeparator(Composite parent) {
        Label label = new Label(parent, 258);
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 8;
        gridData.heightHint = 8;
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
    }

    private void createTypeControls(Composite parent) {
        Label typeLabel = new Label(parent, 16448);
        typeLabel.setFont(parent.getFont());
        typeLabel.setText(InterpreterMessages.getString("interpreter.wizard.newvariable.type.label") + ":");
        GridData gridData = new GridData(256);
        typeLabel.setLayoutData((Object)gridData);
        Composite buttonGroup = new Composite(parent, 0);
        buttonGroup.setLayout((Layout)new FillLayout());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        buttonGroup.setLayoutData((Object)gridData);
        Button stringButton = new Button(buttonGroup, 16);
        stringButton.setText(InterpreterMessages.getString("interpreter.wizard.newvariable.type.string"));
        stringButton.setSelection(true);
        stringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVariableWizardPage.this.currentType != Type.STRING) {
                    Composite composite = NewVariableWizardPage.this.valueControl.getParent();
                    NewVariableWizardPage.this.createStringValueControl(composite);
                    composite.layout();
                    NewVariableWizardPage.this.currentType = Type.STRING;
                }
            }
        });
        Button booleanButton = new Button(buttonGroup, 16);
        booleanButton.setText(InterpreterMessages.getString("interpreter.wizard.newvariable.type.boolean"));
        booleanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVariableWizardPage.this.currentType != Type.BOOLEAN) {
                    Composite composite = NewVariableWizardPage.this.valueControl.getParent();
                    NewVariableWizardPage.this.createBooleanValueControl(composite);
                    composite.layout();
                    NewVariableWizardPage.this.currentType = Type.BOOLEAN;
                }
            }
        });
        Button integerButton = new Button(buttonGroup, 16);
        integerButton.setText(InterpreterMessages.getString("interpreter.wizard.newvariable.type.integer"));
        integerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVariableWizardPage.this.currentType != Type.INTEGER) {
                    Composite composite = NewVariableWizardPage.this.valueControl.getParent();
                    NewVariableWizardPage.this.createIntegerValueControl(composite);
                    composite.layout();
                    NewVariableWizardPage.this.currentType = Type.INTEGER;
                }
            }
        });
        Button floatButton = new Button(buttonGroup, 16);
        floatButton.setText(InterpreterMessages.getString("interpreter.wizard.newvariable.type.float"));
        floatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewVariableWizardPage.this.currentType != Type.FLOAT) {
                    Composite composite = NewVariableWizardPage.this.valueControl.getParent();
                    NewVariableWizardPage.this.createFloatValueControl(composite);
                    composite.layout();
                    NewVariableWizardPage.this.currentType = Type.FLOAT;
                }
            }
        });
    }

    private void createValueControls(Composite parent) {
        Label valueLabel = new Label(parent, 16448);
        valueLabel.setFont(parent.getFont());
        valueLabel.setText(InterpreterMessages.getString("interpreter.wizard.newvariable.value.label") + ":");
        GridData gridData = new GridData(258);
        valueLabel.setLayoutData((Object)gridData);
        this.createStringValueControl(parent);
        this.currentType = Type.STRING;
    }

    private void createVariableControls(Composite parent) {
        Label variableLabel = new Label(parent, 16448);
        variableLabel.setFont(parent.getFont());
        variableLabel.setText(InterpreterMessages.getString("interpreter.wizard.newvariable.variable.label") + ":");
        GridData gridData = new GridData(256);
        variableLabel.setLayoutData((Object)gridData);
        this.variableText = new Text(parent, 2052);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.variableText.setLayoutData((Object)gridData);
        this.variableText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewVariableWizardPage.this.validateVariableName();
                NewVariableWizardPage.this.setPageComplete(NewVariableWizardPage.this.getErrorMessage() == null);
            }
        });
        if (this.initialVariableName != null) {
            this.variableText.setText(this.initialVariableName);
        }
        final Button browseButton = new Button(parent, 8);
        browseButton.setFont(parent.getFont());
        browseButton.setText(InterpreterMessages.getString("interpreter.wizard.newvariable.variable.browse"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = NewVariableWizardPage.getButtonWidthHint(browseButton);
        browseButton.setLayoutData((Object)gridData);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object result;
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(browseButton.getShell(), (ILabelProvider)new VariableLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)));
                dialog.setElements(NewVariableWizardPage.this.existingVariables.toArray());
                if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof Variable) {
                    NewVariableWizardPage.this.variableText.setText(((Variable)result).getName());
                }
            }
        });
        if (this.existingVariables.isEmpty()) {
            browseButton.setEnabled(false);
        }
    }

    public void setVariableName() {
        this.variableName = this.variableText.getText();
    }

    public void setVariableValue() {
        this.variableValue = this.currentType == Type.STRING ? ((Text)this.valueControl).getText() : (this.currentType == Type.INTEGER ? Integer.valueOf(((Spinner)this.valueControl).getSelection()) : (this.currentType == Type.FLOAT ? Float.valueOf(((Text)this.valueControl).getText()) : (this.valueControl != null ? Boolean.valueOf(((BooleanChooser)this.valueControl).getValue()) : "")));
    }

    private class BooleanChooser
    extends Composite {
        protected boolean value;

        BooleanChooser(Composite parent) {
            super(parent, 0);
            this.value = true;
            this.setLayout((Layout)new FillLayout(512));
            this.createContents();
        }

        public boolean getValue() {
            return this.value;
        }

        private void createContents() {
            Button trueButton = new Button((Composite)this, 16);
            trueButton.setText(Boolean.TRUE.toString());
            trueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BooleanChooser.this.value = true;
                }
            });
            trueButton.setSelection(true);
            Button falseButton = new Button((Composite)this, 16);
            falseButton.setText(Boolean.FALSE.toString());
            falseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BooleanChooser.this.value = false;
                }
            });
        }
    }

    protected class RealValueValidator
    implements IInputValidator {
        protected RealValueValidator() {
        }

        public String isValid(String newText) {
            String errorMessage = null;
            if (newText != null && newText.length() > 0 && !this.isReal(newText)) {
                errorMessage = InterpreterMessages.getString("interpreter.wizard.newvariable.error.float.invalid", newText);
            }
            return errorMessage;
        }

        private boolean isReal(String value) {
            try {
                Double.parseDouble(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    protected static enum Type {
        BOOLEAN,
        FLOAT,
        INTEGER,
        STRING;

    }

    protected class VariableNameValidator
    implements IInputValidator {
        protected VariableNameValidator() {
        }

        public String isValid(String newText) {
            String errorMessage = null;
            if (newText == null || "".equals(newText)) {
                errorMessage = InterpreterMessages.getString("interpreter.wizard.newvariable.error.noname");
            } else if (!this.isJavaIdentifier(newText)) {
                errorMessage = InterpreterMessages.getString("interpreter.wizard.newvariable.error.invalid", newText);
            }
            return errorMessage;
        }

        private boolean isJavaIdentifier(String name) {
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char character = cArray[n2];
                if (!Character.isJavaIdentifierPart(character)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

