/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.view.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.sirius.ui.interpreter.internal.language.EvaluationContext;
import org.eclipse.sirius.ui.interpreter.internal.language.InterpreterContext;
import org.eclipse.sirius.ui.interpreter.internal.language.SplitExpression;
import org.eclipse.sirius.ui.interpreter.internal.view.InterpreterView;
import org.eclipse.swt.widgets.Display;

public class ExpressionSplittingThread
extends Thread {
    private boolean cancelled;
    private Future<SplitExpression> splittingTask;
    private final InterpreterContext interpreterContext;
    private InterpreterView interpreterView;

    public ExpressionSplittingThread(InterpreterContext interpreterContext, InterpreterView interpreterView) {
        super("InterpreterExpressionSplittingThread");
        this.interpreterContext = interpreterContext;
        this.interpreterView = interpreterView;
    }

    @Override
    public void interrupt() {
        this.cancelled = true;
        if (this.splittingTask != null) {
            this.splittingTask.cancel(true);
        }
        super.interrupt();
    }

    @Override
    public void run() {
        try {
            this.checkCancelled();
            if (this.interpreterView.getCompilationThread() != null) {
                this.interpreterView.getCompilationThread().join();
            }
            this.checkCancelled();
            Callable<SplitExpression> splitExpressionCallable = this.interpreterView.getCurrentLanguageInterpreter().getExpressionSplittingTask(new EvaluationContext(this.interpreterContext, this.interpreterView.getCompilationResult()));
            if (splitExpressionCallable == null) {
                return;
            }
            this.splittingTask = this.interpreterView.getSplittingPool().submit(splitExpressionCallable);
            final SplitExpression splitExpression = this.splittingTask.get();
            this.checkCancelled();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExpressionSplittingThread.this.interpreterView.setSubExpressions(splitExpression);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExpressionSplittingThread.this.interpreterView.setSubExpressions(null);
                }
            });
        }
    }

    protected void checkCancelled() {
        if (this.cancelled) {
            throw new CancellationException();
        }
    }
}

