/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.common.ui.business.internal.views.properties.tabbed.LabelProviderProviderRegistryListener;
import org.eclipse.sirius.common.ui.tools.internal.util.ISaveDialogExtensionRegistryListener;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public final class SiriusTransPlugin
extends EMFPlugin {
    public static final String PREFIX_ROOT = "icons/";
    public static final String PLUGIN_ID = "org.eclipse.sirius.common.ui";
    public static final SiriusTransPlugin INSTANCE = new SiriusTransPlugin();
    private static Implementation plugin;
    private ImageRegistry imageRegistry;

    public SiriusTransPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static ImageDescriptor create(String imageName) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(PREFIX_ROOT + imageName));
    }

    public Image getBundledImage(String path) {
        File imageFile;
        Image image = this.getImageRegistry().get(path);
        if (image == null && (imageFile = FileProvider.getDefault().getFile((IPath)new Path(path))) != null && imageFile.exists() && imageFile.canRead()) {
            try {
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL());
                this.getImageRegistry().put(path, imageDescriptor);
                image = this.getImageRegistry().get(path);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return image;
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.createImageRegistry();
        }
        return this.imageRegistry;
    }

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public void error(String message, Throwable t) {
        Status status = new Status(4, PLUGIN_ID, message, t);
        if (this.getPluginLogger() != null) {
            this.getPluginLogger().log((Object)status);
        }
    }

    public void info(String message, Throwable t) {
        Status status = new Status(1, PLUGIN_ID, message, t);
        if (this.getPluginLogger() != null) {
            this.getPluginLogger().log((Object)status);
        }
    }

    public static class Implementation
    extends EclipseUIPlugin {
        private ISaveDialogExtensionRegistryListener registryListener;
        private LabelProviderProviderRegistryListener labelProviderProviderRegistryListener;
        private PreferenceChangeListener preferenceChangeListener;

        public Implementation() {
            plugin = this;
            this.preferenceChangeListener = new PreferenceChangeListener();
        }

        private void initProfiler() {
            boolean profiling = this.getPreferenceStore().getBoolean("REFRESH_PROFILING");
            DslCommonPlugin.PROFILER.setActive(profiling);
        }

        public void error(String message, Throwable t) {
            Status status = new Status(4, SiriusTransPlugin.PLUGIN_ID, message, t);
            this.getLog().log((IStatus)status);
        }

        public void warning(String message, Throwable t) {
            Status status = new Status(2, SiriusTransPlugin.PLUGIN_ID, message, t);
            this.getLog().log((IStatus)status);
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            this.initProfiler();
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.preferenceChangeListener);
            this.registryListener = new ISaveDialogExtensionRegistryListener();
            this.registryListener.init();
            this.labelProviderProviderRegistryListener = new LabelProviderProviderRegistryListener();
            this.labelProviderProviderRegistryListener.init();
        }

        public void stop(BundleContext context) throws Exception {
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.preferenceChangeListener);
            this.registryListener.dispose();
            this.registryListener = null;
            this.labelProviderProviderRegistryListener.dispose();
            this.labelProviderProviderRegistryListener = null;
            super.stop(context);
        }

        private final class PreferenceChangeListener
        implements IPropertyChangeListener {
            private PreferenceChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent event) {
                boolean profiling = Implementation.this.getPreferenceStore().getBoolean("REFRESH_PROFILING");
                DslCommonPlugin.PROFILER.setActive(profiling);
            }
        }
    }
}

