/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.collection;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.collection.AbstractCollectionService;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;

public class NumberService
extends AbstractCollectionService {
    public NumberService(Method serviceMethod, Object serviceInstance, boolean forWorkspace) {
        super(serviceMethod, serviceInstance, forWorkspace);
    }

    @Override
    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        if (!argTypes.isEmpty() && argTypes.get(0) instanceof ICollectionType) {
            IType argType = ((ICollectionType)argTypes.get(0)).getCollectionType();
            ClassType intType = new ClassType(queryEnvironment, Integer.class);
            ClassType longType = new ClassType(queryEnvironment, Long.class);
            ClassType numberType = new ClassType(queryEnvironment, Number.class);
            if (intType.isAssignableFrom(argType) || longType.isAssignableFrom(argType)) {
                result.add(longType);
            } else if (numberType.isAssignableFrom(argType)) {
                result.add(new ClassType(queryEnvironment, Double.class));
            } else {
                result.add(services.nothing(String.format("%s can only be used on a collection of numbers.", this.getName()), new Object[0]));
            }
        }
        return result;
    }

    @Override
    public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
        IType currentResult = null;
        ClassType longType = new ClassType(queryEnvironment, Long.class);
        ClassType doubleType = new ClassType(queryEnvironment, Double.class);
        for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            IType returnType = entry.getValue().iterator().next();
            if (currentResult == null) {
                currentResult = returnType;
                continue;
            }
            if (currentResult.equals(doubleType) || returnType.equals(doubleType)) {
                currentResult = new ClassType(queryEnvironment, Double.class);
                continue;
            }
            if (returnType.equals(longType)) {
                currentResult = new ClassType(queryEnvironment, Long.class);
                continue;
            }
            currentResult = services.nothing(String.format("%s can only be used on a collection of numbers.", this.getName()), new Object[0]);
            break;
        }
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        result.add(currentResult);
        return result;
    }
}

