/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.provider;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.api.query.DCellQuery;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.provider.TableUIPlugin;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.ui.tools.internal.editor.DefaultFontStyler;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class DTableColumnLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public static final String CHECKED_IMAGE = "table/checked";
    public static final String UNCHECKED_IMAGE = "table/unchecked";
    private static ImageRegistry imageRegistry = new ImageRegistry();
    private static final RGB DEFAULT_BG_COLOR;
    DColumn column;
    private FontData defaultFont;

    static {
        imageRegistry.put(CHECKED_IMAGE, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(CHECKED_IMAGE))));
        imageRegistry.put(UNCHECKED_IMAGE, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(UNCHECKED_IMAGE))));
        DEFAULT_BG_COLOR = new RGB(255, 255, 255);
    }

    public DTableColumnLabelProvider(DColumn column) {
        this.column = column;
    }

    private DTableElementStyle getFgStyleToApply(Object element) {
        Optional<DCell> cell = this.getDCell(element);
        DTableElementStyle result = null;
        if (cell.isPresent()) {
            result = (DTableElementStyle)new DCellQuery(cell.get()).getForegroundStyleToApply().get();
        } else if (element instanceof DLine) {
            result = (DTableElementStyle)TableHelper.getForegroundStyleToApply((DLine)((DLine)element), (DColumn)this.column).get();
        }
        return result;
    }

    private DTableElementStyle getBgStyleToApply(Object element) {
        Optional<DCell> cell = this.getDCell(element);
        DTableElementStyle result = null;
        if (cell.isPresent()) {
            result = (DTableElementStyle)new DCellQuery(cell.get()).getBackgroundStyleToApply().get();
        } else if (element instanceof DLine) {
            result = (DTableElementStyle)TableHelper.getBackgroundStyleToApply((DLine)((DLine)element), (DColumn)this.column).get();
        }
        return result;
    }

    public Color getBackground(Object element) {
        RGBValues rgb;
        Color result = null;
        DTableElementStyle styleToApply = this.getBgStyleToApply(element);
        if (styleToApply != null && (rgb = styleToApply.getBackgroundColor()) != null) {
            result = VisualBindingManager.getDefault().getColorFromRGBValues(rgb);
        }
        if (result != null && DEFAULT_BG_COLOR.equals((Object)result.getRGB())) {
            result = null;
        }
        return result;
    }

    public Font getFont(Object element) {
        Font result = null;
        DTableElementStyle styleToApply = this.getFgStyleToApply(element);
        if (styleToApply != null) {
            List<FontFormat> labelFormat = DTableColumnLabelProvider.getFontFormat(styleToApply);
            int size = this.getFontSize(styleToApply);
            result = this.defaultFont == null ? VisualBindingManager.getDefault().getFontFromLabelFormatAndSize(labelFormat, size) : VisualBindingManager.getDefault().getFontFromLabelFormatAndSize(labelFormat, size, this.defaultFont.getName());
        }
        return result;
    }

    private static List<FontFormat> getFontFormat(DTableElementStyle styleToApply) {
        EList labelFormat = Collections.emptyList();
        if (styleToApply.getLabelFormat() != null) {
            labelFormat = styleToApply.getLabelFormat();
        }
        return labelFormat;
    }

    private int getFontSize(DTableElementStyle styleToApply) {
        int size = styleToApply.getLabelSize();
        if (size == -1) {
            size = this.defaultFont != null ? this.defaultFont.getHeight() : 8;
        }
        return size;
    }

    public Color getForeground(Object element) {
        RGBValues rgb;
        DTableElementStyle styleToApply = this.getFgStyleToApply(element);
        if (styleToApply != null && (rgb = styleToApply.getForegroundColor()) != null) {
            return VisualBindingManager.getDefault().getColorFromRGBValues(rgb);
        }
        return null;
    }

    public Image getImage(Object element) {
        Optional<DCell> cell;
        DLine line = null;
        if (element instanceof DCell) {
            line = ((DCell)element).getLine();
        } else if (element instanceof DLine) {
            line = (DLine)element;
        }
        if (this.isBooleanColumn(line) && (cell = this.getDCell(line)).isPresent()) {
            return this.getBooleanImage(Boolean.parseBoolean(cell.get().getLabel()));
        }
        return null;
    }

    private boolean isBooleanColumn(DLine line) {
        boolean isNotMany;
        EStructuralFeature feature = TableHelper.getEStructuralFeature((DLine)line, (DColumn)this.column);
        EClassifier eClassifier = TableHelper.getEClassifier((DLine)line, (DColumn)this.column);
        boolean bl = isNotMany = feature != null && !feature.isMany();
        return isNotMany && eClassifier instanceof EDataType && ("Boolean".equals(eClassifier.getName()) || "EBoolean".equals(eClassifier.getName()));
    }

    public String getText(Object element) {
        String result = "";
        Optional<DCell> cell = this.getDCell(element);
        if (cell.isPresent()) {
            result = cell.get().getLabel();
        }
        return result;
    }

    protected Optional<DCell> getDCell(Object element) {
        DCell result = null;
        if (element instanceof DLine) {
            DLine line = (DLine)element;
            result = (DCell)TableHelper.getCell((DLine)line, (DColumn)this.column).get();
        } else if (element instanceof DCell) {
            result = (DCell)element;
        }
        return Optional.ofNullable(result);
    }

    private Image getBooleanImage(boolean isSelected) {
        String key = isSelected ? CHECKED_IMAGE : UNCHECKED_IMAGE;
        return imageRegistry.get(key);
    }

    public boolean isProvideColumn(DColumn currentColumn) {
        return this.column.equals(currentColumn);
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        if (text == null) {
            text = "";
        }
        DTableElementStyle styleToApply = this.getFgStyleToApply(element);
        DefaultFontStyler styler = new DefaultFontStyler(this.getFont(element), this.getForeground(element), this.getBackground(element), this.isFormat(styleToApply, FontFormat.UNDERLINE_LITERAL), this.isFormat(styleToApply, FontFormat.STRIKE_THROUGH_LITERAL));
        return new StyledString(text, (StyledString.Styler)styler);
    }

    private boolean isFormat(DTableElementStyle styleToApply, FontFormat format) {
        return styleToApply != null && styleToApply.getLabelFormat() != null && styleToApply.getLabelFormat().contains((Object)format);
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont != null ? defaultFont.getFontData()[0] : null;
    }
}

