/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.api.helper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.InterpretationContext;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.api.helper.TableVariablesHelper;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.description.CellUpdater;
import org.eclipse.sirius.table.metamodel.table.description.CreateCellTool;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.TableTool;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class TableToolHelper {
    private final ModelAccessor accessor;

    public TableToolHelper(ModelAccessor accessor) {
        this.accessor = accessor;
    }

    private IPermissionAuthority getAuthority() {
        return this.accessor.getPermissionAuthority();
    }

    public boolean canEdit(DLine line, DFeatureColumn column) {
        Option<DCell> optCell = TableHelper.getCell(line, (DColumn)column);
        if (!optCell.some()) {
            return false;
        }
        boolean canEdit = true;
        DCell cell = (DCell)optCell.get();
        CellUpdater updater = cell.getUpdater();
        if (updater != null && !StringUtil.isEmpty((String)updater.getCanEdit())) {
            canEdit = (Boolean)InterpretationContext.with((EObject)cell.getTarget(), ctx -> {
                ctx.setVariables(TableVariablesHelper.getVariables(line, (DColumn)column));
                ctx.setVariable("viewpoint", (Object)TableHelper.getTable((EObject)line));
                ctx.setVariable("element", (Object)line.getTarget());
                return ctx.getInterpreter().evaluateBoolean(cell.getTarget(), (EObject)updater, (EStructuralFeature)DescriptionPackage.eINSTANCE.getCellUpdater_CanEdit());
            });
        }
        return canEdit && this.getAuthority().canEditFeature(cell.getTarget(), column.getFeatureName()) && this.getAuthority().canEditInstance((EObject)line);
    }

    public boolean canEdit(DLine line, DTargetColumn column) {
        Option<DCell> optionalCell = TableHelper.getCell(line, (DColumn)column);
        if (!optionalCell.some()) {
            return this.canCreateCell(line, column);
        }
        EObject target = ((DCell)optionalCell.get()).getTarget();
        EObject interpreterContext = target != null ? target : ((DCell)optionalCell.get()).getLine().getTarget();
        boolean canEdit = false;
        CellUpdater updater = ((DCell)optionalCell.get()).getUpdater();
        if (updater != null && updater.getDirectEdit() != null) {
            boolean bl = canEdit = StringUtil.isEmpty((String)updater.getCanEdit()) || (Boolean)InterpretationContext.with((EObject)((EObject)optionalCell.get()), ctx -> {
                ctx.setVariables(TableVariablesHelper.getVariables(line, (DColumn)column));
                ctx.setVariable("viewpoint", (Object)TableHelper.getTable((EObject)line));
                return ctx.getInterpreter().evaluateBoolean(interpreterContext, (EObject)updater, (EStructuralFeature)DescriptionPackage.eINSTANCE.getCellUpdater_CanEdit());
            }) != false;
        }
        return canEdit && this.getAuthority().canEditInstance(((DCell)optionalCell.get()).getTarget());
    }

    private boolean canCreateCell(DLine line, DTargetColumn column) {
        boolean canEdit;
        Option<CreateCellTool> tool = TableHelper.getCreateCellTool(line, (DColumn)column);
        if (!tool.some()) {
            return false;
        }
        EObject target = line.getTarget();
        boolean bl = canEdit = StringUtil.isEmpty((String)((CreateCellTool)tool.get()).getPrecondition()) || (Boolean)InterpretationContext.with((EObject)target, ctx -> {
            ctx.setVariables(TableVariablesHelper.getVariables(line, (DColumn)column));
            ctx.setVariable("viewpoint", (Object)TableHelper.getTable((EObject)line));
            return ctx.getInterpreter().evaluateBoolean(target, (EObject)tool.get(), (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
        }) != false;
        return canEdit && this.getAuthority().canEditInstance((EObject)line) && this.getAuthority().canEditInstance((EObject)column);
    }

    public static <TT extends TableTool & AbstractToolDescription> boolean isAxisToolEnable(TT tool, DSemanticDecorator selection) {
        boolean valid;
        boolean bl = valid = tool != null && tool.getFirstModelOperation() != null;
        if (valid && TableToolHelper.hasPrecondition(tool)) {
            return (Boolean)InterpretationContext.with((EObject)selection.getTarget(), ctxt -> {
                ctxt.setVariables(TableVariablesHelper.getVariables(selection));
                return ctxt.getInterpreter().evaluateBoolean(selection.getTarget(), (EObject)tool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
            });
        }
        return valid;
    }

    private static boolean hasPrecondition(AbstractToolDescription tool) {
        return !StringUtil.isEmpty((String)tool.getPrecondition());
    }
}

