/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.operations;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.DragSource;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public final class DDiagramElementContainerWithInterpreterOperations {
    private DDiagramElementContainerWithInterpreterOperations() {
    }

    public static EList<DDiagramElement> getElements(DDiagramElementContainer container) {
        return new BasicEList();
    }

    public static ContainerDropDescription getBestDropDescription(DragAndDropTargetDescription description, EObject droppedElement, EObject oldContainer, EObject newContainer, EObject newViewContainer, DragSource dragSource, EObject droppedDiagramElement) {
        DDiagram diagram = newViewContainer instanceof DDiagram ? (DDiagram)newViewContainer : ((DDiagramElement)newViewContainer).getParentDiagram();
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(droppedElement);
        if (oldContainer != null) {
            interpreter.setVariable("oldContainer", (Object)oldContainer);
        }
        interpreter.setVariable("newContainer", (Object)newContainer);
        interpreter.setVariable("newViewContainer", (Object)newViewContainer);
        interpreter.setVariable("element", (Object)droppedElement);
        RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
        ContainerDropDescription bestDropDescription = null;
        ArrayList<ContainerDropDescription> candidates = new ArrayList<ContainerDropDescription>();
        for (ContainerDropDescription dropTool : DDiagramElementContainerWithInterpreterOperations.getDropToolsOnActivatedLayers(diagram, description)) {
            if (!DDiagramElementContainerWithInterpreterOperations.checkDragSource(dropTool, dragSource) || !DDiagramElementContainerWithInterpreterOperations.checkDroppedDiagramElement(dropTool, droppedDiagramElement, newViewContainer) || !DDiagramElementContainerWithInterpreterOperations.checkPrecondition(dropTool, safeInterpreter, droppedElement)) continue;
            candidates.add(dropTool);
        }
        for (ContainerDropDescription dropTool : candidates) {
            if (ContainerMappingWithInterpreterHelper.getBestMapping(dropTool, (DragAndDropTarget)newViewContainer, droppedElement) == null) continue;
            if (bestDropDescription == null) {
                bestDropDescription = dropTool;
                continue;
            }
            SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DDiagramElementContainerSpecOperations_tooMuchDropDescErrorMsg, droppedElement, bestDropDescription.getName(), dropTool), (Exception)new RuntimeException());
        }
        if (dragSource == DragSource.PROJECT_EXPLORER_LITERAL && bestDropDescription == null && !candidates.isEmpty()) {
            bestDropDescription = (ContainerDropDescription)candidates.toArray()[0];
        }
        return bestDropDescription;
    }

    private static boolean checkDragSource(ContainerDropDescription dropTool, DragSource dragSource) {
        return dropTool.getDragSource() == DragSource.BOTH_LITERAL || dropTool.getDragSource() == dragSource;
    }

    private static boolean checkDroppedDiagramElement(ContainerDropDescription dropTool, EObject droppedDiagramElement, EObject newViewContainer) {
        boolean valid = true;
        if (droppedDiagramElement instanceof DDiagramElement) {
            valid = droppedDiagramElement.equals(newViewContainer) ? dropTool.getContainers().contains((Object)((DDiagramElement)droppedDiagramElement).getMapping()) : dropTool.getMappings().contains((Object)((DDiagramElement)droppedDiagramElement).getMapping());
        }
        return valid;
    }

    private static boolean checkPrecondition(ContainerDropDescription dropTool, RuntimeLoggerInterpreter safeInterpreter, EObject droppedElement) {
        String precondition = dropTool.getPrecondition();
        if (precondition != null && !StringUtil.isEmpty((String)precondition.trim())) {
            return safeInterpreter.evaluateBoolean(droppedElement, (EObject)dropTool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
        }
        return true;
    }

    private static Collection<ContainerDropDescription> getDropToolsOnActivatedLayers(DDiagram diagram, DragAndDropTargetDescription mapping) {
        if (diagram.getDescription().getDefaultLayer() != null) {
            HashSet allActivatedTools = new HashSet();
            allActivatedTools.addAll(diagram.getDescription().getDefaultLayer().getAllTools());
            for (Layer layer : new DDiagramQuery(diagram).getAllActivatedLayers()) {
                allActivatedTools.addAll(layer.getAllTools());
            }
            Collection<ContainerDropDescription> dropTools = DDiagramElementContainerWithInterpreterOperations.getDropTools(mapping);
            dropTools.retainAll(allActivatedTools);
            return dropTools;
        }
        return DDiagramElementContainerWithInterpreterOperations.getDropTools(mapping);
    }

    private static Collection<ContainerDropDescription> getDropTools(DragAndDropTargetDescription mapping) {
        HashSet dropTools = mapping instanceof DiagramElementMapping ? Sets.newHashSet(new DiagramElementMappingQuery((DiagramElementMapping)mapping).getDropTools()) : Sets.newHashSet((Iterable)mapping.getDropDescriptions());
        return dropTools;
    }
}

