/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.query;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.FoldingStyle;
import org.eclipse.sirius.diagram.ui.business.internal.query.DEdgeQuery;

public class EdgeTargetQuery {
    private final EdgeTarget target;

    public EdgeTargetQuery(EdgeTarget target) {
        this.target = target;
    }

    public boolean isFoldingPoint() {
        Iterable<DEdge> foldables = this.getAllFoldableEdges();
        return !Iterables.isEmpty(foldables);
    }

    public Iterable<DEdge> getFoldableEdgesToFollow() {
        return Iterables.filter(this.getAllFoldableEdges(), (Predicate)new Predicate<DEdge>(){

            public boolean apply(DEdge input) {
                return !new DDiagramElementQuery((DDiagramElement)input).isExplicitlyFolded();
            }
        });
    }

    public Iterable<DEdge> getAllFoldableEdges() {
        Iterable incomingFoldables = Iterables.filter((Iterable)Iterables.filter((Iterable)this.target.getIncomingEdges(), DEdge.class), DEdgeQuery.hasFoldingStyle(FoldingStyle.TARGET_LITERAL));
        Iterable outgoingFoldables = Iterables.filter((Iterable)Iterables.filter((Iterable)this.target.getOutgoingEdges(), DEdge.class), DEdgeQuery.hasFoldingStyle(FoldingStyle.SOURCE_LITERAL));
        Iterable allFoldables = Iterables.concat((Iterable)incomingFoldables, (Iterable)outgoingFoldables);
        return Iterables.filter((Iterable)allFoldables, (Predicate)new Predicate<DEdge>(){

            public boolean apply(DEdge input) {
                return input != null && input.eContainer() != null;
            }
        });
    }

    public FoldingState getFoldingState() {
        FoldingState result = FoldingState.UNFOLDED;
        boolean hasFoldedFoldables = false;
        boolean hasUnfoldedFoldables = false;
        for (DEdge edge : this.getAllFoldableEdges()) {
            if (new DDiagramElementQuery((DDiagramElement)edge).isExplicitlyFolded()) {
                hasFoldedFoldables = true;
                continue;
            }
            hasUnfoldedFoldables = true;
        }
        if (hasFoldedFoldables && hasUnfoldedFoldables) {
            result = FoldingState.MIXED;
        } else if (hasFoldedFoldables) {
            result = FoldingState.FOLDED;
        }
        return result;
    }

    public static enum FoldingState {
        FOLDED,
        MIXED,
        UNFOLDED;

    }
}

