/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.refresh;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.util.BendpointsHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.util.NotificationQuery;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class RefreshLayoutScope
implements Predicate<Notification> {
    private final Diagram diagram;
    private final DDiagram dDiagram;
    private final EObject semanticElement;
    private final Predicate<Notification> isLayoutConstraintNotationChange = new Predicate<Notification>(){
        Object[] features = new Object[]{NotationPackage.eINSTANCE.getRelativeBendpoints_Points(), NotationPackage.eINSTANCE.getLocation_Y(), NotationPackage.eINSTANCE.getLocation_X(), NotationPackage.eINSTANCE.getSize_Width(), NotationPackage.eINSTANCE.getSize_Height()};

        public boolean apply(Notification input) {
            boolean isLayout = false;
            Object feature = input.getFeature();
            Object[] objectArray = this.features;
            int n = this.features.length;
            int n2 = 0;
            while (n2 < n) {
                Object feature2 = objectArray[n2];
                if (feature == feature2) {
                    isLayout = true;
                    break;
                }
                ++n2;
            }
            return isLayout;
        }
    };
    private final Predicate<Notification> isSructuralNotationChange = new Predicate<Notification>(){
        int[] types = new int[]{3, 5, 7, 4, 6};

        public boolean apply(Notification input) {
            return this.isStructural(input.getEventType());
        }

        private boolean isStructural(int eventType) {
            int[] nArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                int type = nArray[n2];
                if (eventType == type) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    };

    public RefreshLayoutScope(Diagram notationDiagram) {
        this.diagram = notationDiagram;
        this.dDiagram = this.diagram != null ? (DDiagram)this.diagram.getElement() : null;
        this.semanticElement = this.dDiagram instanceof DSemanticDiagram ? ((DSemanticDiagram)this.dDiagram).getTarget() : null;
    }

    public boolean apply(Notification input) {
        boolean validScopeContext = this.diagram != null && !this.diagram.eIsProxy();
        validScopeContext = validScopeContext && this.dDiagram != null && !this.dDiagram.eIsProxy();
        boolean bl = validScopeContext = validScopeContext && this.semanticElement != null && !this.semanticElement.eIsProxy();
        return validScopeContext && !input.isTouch() && this.needLayout(input);
    }

    private boolean needLayout(Notification notification) {
        if (this.isSequenceChange(notification)) {
            return !this.isLayoutTouch(notification) && (this.containsStructuralNotationChanges(notification) || this.containsLayoutConstraintNotationChanges(notification));
        }
        return this.containsSetWkpImgApplication(notification);
    }

    private boolean isSequenceChange(Notification input) {
        return new NotificationQuery(input).isNotationChange() && this.isSequenceElementChange(input);
    }

    private boolean isSequenceElementChange(Notification notification) {
        Collection<?> values;
        boolean isSequenceElement = false;
        Object notifier = notification.getNotifier();
        View notifierView = this.getView(notifier);
        boolean bl = isSequenceElement = notifierView != null && ISequenceElementAccessor.isPartOfSequenceElement(notifierView) && this.shouldTriggerLayoutForChangeOn(notifierView.getDiagram());
        if (isSequenceElement && (values = this.getValues(notification)) != null) {
            boolean valueIsSequenceElt = false;
            for (Object val : values) {
                View valueView = this.getView(val);
                if (valueView != null && valueView != notifierView && !ISequenceElementAccessor.isPartOfSequenceElement(valueView)) continue;
                valueIsSequenceElt = true;
                break;
            }
            isSequenceElement = valueIsSequenceElt;
        }
        return isSequenceElement;
    }

    private Collection<?> getValues(Notification notification) {
        Collection<Object> values = null;
        Object newValue = notification.getNewValue();
        if (newValue instanceof EObject) {
            values = Collections.singletonList(newValue);
        } else if (newValue instanceof Collection) {
            values = (Collection)newValue;
        } else {
            Object oldValue = notification.getOldValue();
            if (oldValue instanceof EObject) {
                values = Collections.singletonList(oldValue);
            } else if (oldValue instanceof Collection) {
                values = (Collection)oldValue;
            }
        }
        return values;
    }

    private View getView(Object obj) {
        View view = null;
        if (obj instanceof View) {
            view = (View)obj;
        } else if (obj instanceof EObject && ((EObject)obj).eContainer() instanceof View) {
            view = (View)((EObject)obj).eContainer();
        }
        return view;
    }

    private boolean containsLayoutConstraintNotationChanges(Notification notification) {
        return this.isLayoutConstraintNotationChange.apply((Object)notification);
    }

    private boolean containsStructuralNotationChanges(Notification notification) {
        return this.isSructuralNotationChange.apply((Object)notification);
    }

    private boolean isLayoutTouch(Notification notification) {
        boolean isLayoutTouch = false;
        if (NotationPackage.eINSTANCE.getRelativeBendpoints_Points().equals(notification.getFeature())) {
            isLayoutTouch = BendpointsHelper.areSameBendpoints(notification.getOldValue(), notification.getNewValue());
        }
        return isLayoutTouch;
    }

    private boolean containsSetWkpImgApplication(Notification notification) {
        boolean newStyle = false;
        boolean wkpImageCustomization = false;
        boolean wkpImageDeCustomization = false;
        Object notifier = notification.getNotifier();
        if (notification.getEventType() == 1 && DiagramPackage.eINSTANCE.getDNode_OwnedStyle().equals(notification.getFeature()) && this.hasSequenceMapping(notifier)) {
            newStyle = true;
        } else if (ViewpointPackage.eINSTANCE.getCustomizable_CustomFeatures().equals(notification.getFeature()) && notifier instanceof WorkspaceImage && this.hasSequenceMapping(((WorkspaceImage)notifier).eContainer())) {
            WorkspaceImage workspaceImage = (WorkspaceImage)notifier;
            wkpImageCustomization = !workspaceImage.getCustomFeatures().isEmpty();
            boolean bl = wkpImageDeCustomization = !wkpImageCustomization;
        }
        return newStyle && (wkpImageCustomization || wkpImageDeCustomization);
    }

    private boolean hasSequenceMapping(Object notifier) {
        if (notifier instanceof DDiagramElement) {
            boolean hasSequenceMapping;
            DDiagramElement dde = (DDiagramElement)notifier;
            boolean bl = hasSequenceMapping = AbstractNodeEvent.viewpointElementPredicate().apply((Object)dde) || EndOfLife.viewpointElementPredicate().apply((Object)dde) || InstanceRole.viewpointElementPredicate().apply((Object)dde);
            return hasSequenceMapping && this.shouldTriggerLayoutForChangeOn(dde.getParentDiagram());
        }
        return false;
    }

    private boolean shouldTriggerLayoutForChangeOn(Diagram impactedDiagram) {
        boolean needsLayoutOnCurrentDiagram;
        boolean bl = needsLayoutOnCurrentDiagram = impactedDiagram == this.diagram;
        if (!needsLayoutOnCurrentDiagram && impactedDiagram != null) {
            EObject element = impactedDiagram.getElement();
            needsLayoutOnCurrentDiagram = element instanceof DDiagram && this.shouldTriggerLayoutForChangeOn((DDiagram)element);
        }
        return needsLayoutOnCurrentDiagram;
    }

    private boolean shouldTriggerLayoutForChangeOn(DDiagram impactedDDiagram) {
        boolean needsLayoutOnCurrentDiagram;
        boolean bl = needsLayoutOnCurrentDiagram = impactedDDiagram == this.dDiagram;
        if (!needsLayoutOnCurrentDiagram && impactedDDiagram instanceof DSemanticDiagram) {
            needsLayoutOnCurrentDiagram = this.semanticElement == ((DSemanticDiagram)impactedDDiagram).getTarget();
        }
        return needsLayoutOnCurrentDiagram;
    }
}

