/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.description;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.tools.internal.interpreter.InterpretedContextImpl;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.tools.internal.interpreter.SiriusInterpreterContextFactory;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.JavaExtension;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.AcceleoVariable;
import org.eclipse.sirius.viewpoint.description.tool.Case;
import org.eclipse.sirius.viewpoint.description.tool.ChangeContext;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.For;
import org.eclipse.sirius.viewpoint.description.tool.If;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.Let;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationNavigationDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.tool.VariableContainer;
import org.eclipse.sirius.viewpoint.description.validation.ValidationPackage;

public abstract class AbstractInterpretedExpressionQuery
implements IInterpretedExpressionQuery {
    protected static final VariableType DSEMANTIC_DECORATOR = VariableType.fromString((String)"viewpoint.DSemanticDecorator");
    protected static final String SELF = "self";
    protected static final String VARIABLES_ANNOTATION_SOURCE = "http://www.eclipse.org/sirius/interpreted/expression/variables";
    protected static final char TYPE_DEFINTION_SEPARATOR = '|';
    protected static final String VARIABLE_TYPE_KEY = "type";
    protected EObject target;
    protected EStructuralFeature feature;
    protected Option<Collection<String>> targetDomainClass;
    protected Collection<EPackage> packagesToImport;
    protected Collection<String> dependencies;
    protected Map<String, VariableType> availableVariables;
    protected VariableType selfType;
    protected IInterpretedExpressionTargetSwitch targetSwitch;

    public AbstractInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        this.target = target;
        this.feature = feature;
        this.initializeTargetSwitch();
    }

    protected abstract void initializeTargetSwitch();

    @Override
    public Option<Collection<String>> getTargetDomainClasses() {
        if (this.targetDomainClass == null) {
            this.getAvailableVariables();
            if (this.selfType != null && this.selfType.hasDefinition()) {
                LinkedHashSet<String> possibleTypes = new LinkedHashSet<String>();
                for (TypeName typeName : this.selfType.getPossibleTypes()) {
                    possibleTypes.add(typeName.getCompleteName());
                }
                this.targetDomainClass = Options.fromNullable(possibleTypes);
            } else {
                this.targetDomainClass = this.targetSwitch.doSwitch(this.target, this.feature != null);
            }
        }
        return this.targetDomainClass;
    }

    @Override
    public Collection<EPackage> getPackagesToImport() {
        if (this.packagesToImport == null) {
            this.packagesToImport = new LinkedHashSet<EPackage>();
            EObject representation = this.target.eContainer();
            while (representation != null && !(representation instanceof RepresentationDescription)) {
                representation = representation.eContainer();
            }
            if (representation != null) {
                if (((RepresentationDescription)representation).getMetamodel().isEmpty()) {
                    for (String nsURI : Sets.newLinkedHashSet((Iterable)EPackage.Registry.INSTANCE.keySet())) {
                        try {
                            this.packagesToImport.add(EPackage.Registry.INSTANCE.getEPackage(nsURI));
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    this.packagesToImport.addAll((Collection<EPackage>)((RepresentationDescription)representation).getMetamodel());
                }
            }
            this.packagesToImport.add((EPackage)EcorePackage.eINSTANCE);
            this.packagesToImport.add((EPackage)ViewpointPackage.eINSTANCE);
            this.packagesToImport.add((EPackage)DescriptionPackage.eINSTANCE);
            this.packagesToImport.add((EPackage)ToolPackage.eINSTANCE);
            this.packagesToImport.add((EPackage)ValidationPackage.eINSTANCE);
        }
        return this.packagesToImport;
    }

    @Override
    public Collection<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new LinkedHashSet<String>();
            if (this.target != null) {
                EObject vp = this.target;
                while (vp != null && !(vp instanceof Viewpoint)) {
                    vp = vp.eContainer();
                }
                if (vp != null) {
                    for (JavaExtension dep : ((Viewpoint)vp).getOwnedJavaExtensions()) {
                        if (StringUtil.isEmpty((String)dep.getQualifiedClassName())) continue;
                        this.dependencies.add(dep.getQualifiedClassName());
                    }
                }
            }
        }
        return this.dependencies;
    }

    @Override
    public Map<String, VariableType> getAvailableVariables() {
        Map inferedTypes;
        ValidationResult res;
        IInterpreterContext iContext;
        Option<EObject> toolContext;
        if (this.availableVariables == null) {
            this.availableVariables = new LinkedHashMap<String, VariableType>();
        }
        if ((toolContext = this.getToolContext()).some()) {
            RepresentationNavigationDescription tool;
            EObject operationContext = (EObject)toolContext.get();
            this.collectContextualVariableDefinitions(operationContext, this.target);
            if (operationContext instanceof ToolDescription) {
                this.availableVariables.put("containerView", DSEMANTIC_DECORATOR);
            }
            if (operationContext instanceof RepresentationNavigationDescription && (tool = (RepresentationNavigationDescription)operationContext).getRepresentationNameVariable() != null && !StringUtil.isEmpty((String)tool.getRepresentationNameVariable().getName())) {
                this.availableVariables.put(tool.getRepresentationNameVariable().getName(), VariableType.fromJavaClass(String.class));
            }
            if (operationContext instanceof RepresentationCreationDescription && (tool = (RepresentationCreationDescription)operationContext).getRepresentationNameVariable() != null && !StringUtil.isEmpty((String)tool.getRepresentationNameVariable().getName())) {
                this.availableVariables.put(tool.getRepresentationNameVariable().getName(), VariableType.fromJavaClass(String.class));
            }
            this.addVariablesFromToolContext(operationContext);
            if (operationContext instanceof SelectionWizardDescription) {
                iContext = SiriusInterpreterContextFactory.createInterpreterContext(operationContext, (EStructuralFeature)ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, ((AbstractToolDescription)operationContext).getPrecondition());
                inferedTypes = res.getInferredVariableTypes(Boolean.TRUE);
                for (Map.Entry infered : inferedTypes.entrySet()) {
                    if (!SELF.equals(infered.getKey())) continue;
                    this.availableVariables.put(((SelectionWizardDescription)operationContext).getElement().getName(), (VariableType)infered.getValue());
                }
            }
            if (operationContext instanceof PaneBasedSelectionWizardDescription) {
                iContext = SiriusInterpreterContextFactory.createInterpreterContext(operationContext, (EStructuralFeature)ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, ((AbstractToolDescription)operationContext).getPrecondition());
                inferedTypes = res.getInferredVariableTypes(Boolean.TRUE);
                for (Map.Entry infered : inferedTypes.entrySet()) {
                    if (!SELF.equals(infered.getKey())) continue;
                    this.availableVariables.put(((PaneBasedSelectionWizardDescription)operationContext).getElement().getName(), (VariableType)infered.getValue());
                }
            }
        }
        this.collectLocalVariablesDefinitions();
        if (this.target instanceof ToolDescription && this.feature == ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION) {
            this.availableVariables.put("containerView", DSEMANTIC_DECORATOR);
            this.availableVariables.put(((ToolDescription)this.target).getElement().getName(), VariableType.ANY_EOBJECT);
            this.availableVariables.put(((ToolDescription)this.target).getElementView().getName(), DSEMANTIC_DECORATOR);
        }
        if (ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__ELEMENTS_TO_SELECT.equals(this.feature)) {
            this.collectContextualVariableDefinitions(this.target, this.target);
            this.addVariablesFromToolContext(this.target);
            this.addVariablesFromCreateOperation(this.target);
        }
        if (this.target instanceof SelectionWizardDescription || this.target instanceof PaneBasedSelectionWizardDescription) {
            AbstractToolDescription wiz = (AbstractToolDescription)this.target;
            if (this.feature == DescriptionPackage.Literals.SELECTION_DESCRIPTION__CANDIDATES_EXPRESSION || this.feature == ToolPackage.Literals.PANE_BASED_SELECTION_WIZARD_DESCRIPTION__CANDIDATES_EXPRESSION) {
                iContext = SiriusInterpreterContextFactory.createInterpreterContext((EObject)wiz, (EStructuralFeature)ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, wiz.getPrecondition());
                inferedTypes = res.getInferredVariableTypes(Boolean.TRUE);
                for (Map.Entry infered : inferedTypes.entrySet()) {
                    if (SELF.equals(infered.getKey())) {
                        this.changeSelfType((VariableType)infered.getValue());
                        continue;
                    }
                    this.availableVariables.put((String)infered.getKey(), (VariableType)infered.getValue());
                }
            }
        }
        return this.availableVariables;
    }

    protected void addVariablesFromToolContext(EObject toolContext) {
    }

    private void addVariablesFromCreateOperation(EObject toolContext) {
        TreeIterator eAllContents = toolContext.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            if (!(eObject instanceof ModelOperation)) continue;
            this.addVariableFromCreateOperation((ModelOperation)eObject);
        }
    }

    protected void addVariableFromCreateOperation(ModelOperation modelOperation) {
        if (modelOperation instanceof CreateInstance && !StringUtil.isEmpty((String)((CreateInstance)modelOperation).getVariableName())) {
            this.availableVariables.put(((CreateInstance)modelOperation).getVariableName(), VariableType.fromString((String)((CreateInstance)modelOperation).getTypeName()));
        }
    }

    protected Option<EObject> getToolContext() {
        Option<EObject> found = Options.newNone();
        found = new EObjectQuery(this.target).getFirstAncestorOfType(ValidationPackage.eINSTANCE.getValidationRule());
        if (!found.some()) {
            if (this.target instanceof OperationAction || this.target instanceof RepresentationNavigationDescription || this.target instanceof RepresentationCreationDescription) {
                found = Options.fromNullable((Object)this.target);
            } else {
                EObject container;
                found = new EObjectQuery(this.target).getFirstAncestorOfType(ToolPackage.eINSTANCE.getAbstractToolDescription());
                if (found.some() && found.get() instanceof ExternalJavaAction && ((container = ((EObject)found.get()).eContainer()) instanceof ModelOperation || container instanceof InitialOperation)) {
                    found = new EObjectQuery(container).getFirstAncestorOfType(ToolPackage.eINSTANCE.getAbstractToolDescription());
                }
            }
        }
        return found;
    }

    private void collectLocalVariablesDefinitions() {
        if (this.feature != null) {
            EAnnotation varAnnotations = null;
            EAnnotation overrideAnnotation = this.target.eClass().getEAnnotation("http://www.eclipse.org/sirius/interpreted/expression/variables_" + this.feature.getName());
            varAnnotations = overrideAnnotation == null || overrideAnnotation.getDetails().isEmpty() ? this.feature.getEAnnotation(VARIABLES_ANNOTATION_SOURCE) : overrideAnnotation;
            if (varAnnotations != null) {
                for (String varName : varAnnotations.getDetails().keySet()) {
                    String doc = (String)varAnnotations.getDetails().get((Object)varName);
                    VariableType typeName = VariableType.ANY_EOBJECT;
                    if (doc != null && doc.indexOf(124) != -1) {
                        typeName = VariableType.fromString((String)doc.substring(0, doc.indexOf(124)).trim());
                    }
                    if (this.availableVariables.containsKey(varName)) continue;
                    this.availableVariables.put(varName, typeName);
                }
            }
        }
    }

    private void collectContextualVariableDefinitions(EObject top, EObject bottom) {
        HashMap<String, Collection<VariableType>> definitions = new HashMap<String, Collection<VariableType>>();
        EObject context = bottom;
        while (context != null && context != top.eContainer()) {
            this.appendAllLocalVariableDefinitions(definitions, context);
            this.collectContextualVariableForOperation(context, definitions, bottom);
            if (context != top) {
                EObject sibling = this.precedingSibling(context);
                while (sibling != null) {
                    this.appendAllLocalVariableDefinitions(definitions, sibling);
                    sibling = this.precedingSibling(sibling);
                }
            }
            context = context.eContainer();
        }
        for (Map.Entry var : definitions.entrySet()) {
            this.availableVariables.put((String)var.getKey(), (VariableType)((Collection)var.getValue()).iterator().next());
        }
    }

    protected void collectContextualVariableForOperation(EObject current, Map<String, Collection<VariableType>> definitions, EObject leaf) {
        CreateInstance f;
        if (current != leaf) {
            VariableType returnTypes;
            Map inferedTypes;
            ValidationResult res;
            IInterpreterContext iContext;
            if (current instanceof If) {
                If ifThen = (If)current;
                iContext = SiriusInterpreterContextFactory.createInterpreterContext((EObject)ifThen, (EStructuralFeature)ToolPackage.Literals.CHANGE_CONTEXT__BROWSE_EXPRESSION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, ifThen.getConditionExpression());
                inferedTypes = res.getInferredVariableTypes(Boolean.TRUE);
                for (Map.Entry infered : inferedTypes.entrySet()) {
                    if (SELF.equals(infered.getKey())) {
                        this.changeSelfType((VariableType)infered.getValue());
                        continue;
                    }
                    this.addDefinition(definitions, (String)infered.getKey(), (VariableType)infered.getValue());
                }
            }
            if (current instanceof Case) {
                Case switchCase = (Case)current;
                IInterpreterContext caseContext = SiriusInterpreterContextFactory.createInterpreterContext((EObject)switchCase, (EStructuralFeature)ToolPackage.Literals.CASE__CONDITION_EXPRESSION);
                res = MultiLanguagesValidator.getInstance().validateExpression(caseContext, switchCase.getConditionExpression());
                inferedTypes = res.getInferredVariableTypes(Boolean.TRUE);
                for (Map.Entry infered : inferedTypes.entrySet()) {
                    if (SELF.equals(infered.getKey())) {
                        this.changeSelfType((VariableType)infered.getValue());
                        continue;
                    }
                    this.addDefinition(definitions, (String)infered.getKey(), (VariableType)infered.getValue());
                }
            }
            if (current instanceof ChangeContext) {
                f = (ChangeContext)current;
                iContext = SiriusInterpreterContextFactory.createInterpreterContext((EObject)f, (EStructuralFeature)ToolPackage.Literals.CHANGE_CONTEXT__BROWSE_EXPRESSION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, f.getBrowseExpression());
                returnTypes = res.getReturnTypes();
                this.changeSelfType(returnTypes);
            }
            if (current instanceof For) {
                f = (For)current;
                iContext = SiriusInterpreterContextFactory.createInterpreterContext((EObject)f, (EStructuralFeature)ToolPackage.Literals.FOR__EXPRESSION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, f.getExpression());
                returnTypes = res.getReturnTypes();
                this.changeSelfType(returnTypes);
                this.addDefinition(definitions, f.getIteratorName(), returnTypes);
            }
            if (current instanceof Let) {
                Let let = (Let)current;
                iContext = SiriusInterpreterContextFactory.createInterpreterContext((EObject)let, (EStructuralFeature)ToolPackage.Literals.LET__VALUE_EXPRESSION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, let.getValueExpression());
                returnTypes = res.getReturnTypes();
                if (SELF.equals(let.getVariableName())) {
                    this.changeSelfType(returnTypes);
                } else {
                    this.addDefinition(definitions, let.getVariableName(), returnTypes);
                }
            }
            if (current instanceof AcceleoVariable) {
                f = (AcceleoVariable)current;
                iContext = SiriusInterpreterContextFactory.createInterpreterContext((EObject)f, (EStructuralFeature)ToolPackage.Literals.ACCELEO_VARIABLE__COMPUTATION_EXPRESSION);
                res = MultiLanguagesValidator.getInstance().validateExpression(iContext, f.getComputationExpression());
                returnTypes = res.getReturnTypes();
                this.changeSelfType(returnTypes);
                this.addDefinition(definitions, f.getName(), returnTypes);
            }
        }
        if (current instanceof CreateInstance && this.feature != ToolPackage.eINSTANCE.getCreateInstance_ReferenceName()) {
            f = (CreateInstance)current;
            this.changeSelfType(VariableType.fromString((String)f.getTypeName()));
        }
    }

    protected void changeSelfType(VariableType newSelfType) {
        if (this.selfType == null) {
            this.selfType = newSelfType;
        }
    }

    private EObject precedingSibling(EObject context) {
        Object sibling;
        EList childs;
        int contextPositionInContainingList;
        Object val;
        EObject container = context.eContainer();
        EStructuralFeature containingFeature = context.eContainingFeature();
        if (container != null && containingFeature != null && (val = container.eGet(containingFeature)) instanceof EList && (contextPositionInContainingList = (childs = (EList)val).indexOf((Object)context)) > 0 && (sibling = childs.get(contextPositionInContainingList - 1)) instanceof EObject) {
            return (EObject)sibling;
        }
        return null;
    }

    protected VariableType getVariableTypeName(AbstractVariable var) {
        Objects.requireNonNull(var);
        Objects.requireNonNull(var.eContainingFeature());
        VariableType typeName = VariableType.ANY_EOBJECT;
        EAnnotation varAnnotation = var.eContainingFeature().getEAnnotation(VARIABLES_ANNOTATION_SOURCE);
        if (varAnnotation != null && varAnnotation.getDetails().containsKey((Object)VARIABLE_TYPE_KEY)) {
            typeName = VariableType.fromString((String)((String)varAnnotation.getDetails().get((Object)VARIABLE_TYPE_KEY)));
        }
        if (var instanceof AcceleoVariable && !StringUtil.isEmpty((String)((AcceleoVariable)var).getComputationExpression())) {
            VariableType self = VariableType.fromString((String)SELF);
            if (this.selfType != null) {
                self = this.selfType;
            }
            InterpretedContextImpl iContext = new InterpretedContextImpl((EObject)var, this.targetDomainClass != null && this.targetDomainClass.some(), (EStructuralFeature)ToolPackage.Literals.ACCELEO_VARIABLE__COMPUTATION_EXPRESSION, self, this.getPackagesToImport(), this.availableVariables, this.getDependencies());
            ValidationResult res = MultiLanguagesValidator.getInstance().validateExpression((IInterpreterContext)iContext, ((AcceleoVariable)var).getComputationExpression());
            typeName = res.getReturnTypes();
        }
        return typeName;
    }

    protected void appendAllLocalVariableDefinitions(Map<String, Collection<VariableType>> definitions, EObject context) {
        if (context instanceof AbstractToolDescription) {
            for (AbstractVariable var : Iterables.filter((Iterable)AllContents.of((EObject)context, (boolean)false), AbstractVariable.class)) {
                this.addDefinition(definitions, var.getName(), this.getVariableTypeName(var));
            }
        }
        if (context instanceof VariableContainer) {
            for (AbstractVariable subVar : ((VariableContainer)context).getSubVariables()) {
                this.appendAllLocalVariableDefinitions(definitions, (EObject)subVar);
            }
        }
        if (context instanceof AbstractVariable) {
            AbstractVariable var;
            var = (AbstractVariable)context;
            this.addDefinition(definitions, var.getName(), this.getVariableTypeName(var));
        }
        if (context instanceof CreateInstance) {
            CreateInstance ci = (CreateInstance)context;
            this.addDefinition(definitions, ci.getVariableName(), ci.getTypeName());
        }
    }

    protected void appendEditMaskVariables(EditMaskVariables mask, Map<String, Collection<VariableType>> definitions) {
        Pattern p = Pattern.compile("\\{\\d\\}");
        Matcher m = p.matcher(mask.getMask());
        while (m.find()) {
            String group = m.group();
            String index = group.substring(1, group.length() - 1);
            this.addDefinition(definitions, index, "String");
            this.addDefinition(definitions, "arg" + index, "String");
        }
    }

    protected void addDefinition(Map<String, Collection<VariableType>> definitions, String name, String value) {
        this.addDefinition(definitions, name, VariableType.fromString((String)value));
    }

    protected void addDefinition(Map<String, Collection<VariableType>> definitions, String name, VariableType type) {
        if (name != null) {
            Collection<VariableType> defs = definitions.get(name);
            if (defs == null) {
                defs = new ArrayList<VariableType>();
                definitions.put(name, defs);
            }
            defs.add(type);
        }
    }
}

