/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.tree;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.tests.unit.common.TreeCommonTest;
import org.eclipse.sirius.tests.unit.common.TreeEcoreModeler;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.TreeFactory;
import org.eclipse.sirius.tree.business.api.interaction.DTreeUserInteraction;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class TreeItemOrderTests
extends TreeCommonTest
implements TreeEcoreModeler {
    private GlobalContext ctx;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ctx = new GlobalContext(this.session.getModelAccessor(), this.session.getInterpreter(), null);
    }

    public void testItemOrders() {
        Collection trees = this.getRepresentations("Tree", this.semanticModel);
        TreeItemOrderTests.assertTrue((String)"Tests data have changed, review this test.", (trees.size() == 1 ? 1 : 0) != 0);
        TreeItemOrderTests.assertTrue((String)"Tests data have changed, review this test.", (boolean)(trees.iterator().next() instanceof DTree));
        final DTree dTree = (DTree)trees.iterator().next();
        this.checkItemOrder(dTree);
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                new DTreeUserInteraction(dTree, TreeItemOrderTests.this.ctx).refreshContent(TreeItemOrderTests.this.defaultProgress);
            }
        });
        this.checkItemOrder(dTree);
    }

    public void testItemOrdersOnTreeCreation() {
        Collection trees = this.getRepresentations("Tree", this.semanticModel);
        TreeItemOrderTests.assertTrue((String)"Tests data have changed, review this test.", (trees.size() == 1 ? 1 : 0) != 0);
        TreeItemOrderTests.assertTrue((String)"Tests data have changed, review this test.", (boolean)(trees.iterator().next() instanceof DTree));
        final DTree newTree = TreeFactory.eINSTANCE.createDTree();
        newTree.setTarget(this.semanticModel);
        newTree.setDescription((TreeDescription)this.getRepresentationDescription("Tree", (Viewpoint)this.session.getSelectedViewpoints(false).iterator().next()));
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                new DTreeUserInteraction(newTree, TreeItemOrderTests.this.ctx).refreshContent(TreeItemOrderTests.this.defaultProgress);
            }
        });
        this.checkItemOrder(newTree);
    }

    private void checkItemOrder(DTree dTree) {
        EList subItemMappings = dTree.getDescription().getSubItemMappings();
        this.checkSubItemsOrder((DTreeItemContainer)dTree, (List<TreeItemMapping>)subItemMappings);
    }

    private void checkSubItemsOrder(DTreeItemContainer itemCont, List<TreeItemMapping> subItemMappings) {
        TreeItemMapping currentMapping = null;
        TreeItemMapping nextMapping = null;
        if (itemCont.getOwnedTreeItems().size() > 1) {
            EList subItems = itemCont.getOwnedTreeItems();
            int i = 0;
            while (i < subItems.size() - 1) {
                DTreeItem next;
                DTreeItem current = (DTreeItem)subItems.get(i);
                currentMapping = nextMapping == null ? current.getActualMapping() : nextMapping;
                if (currentMapping == (nextMapping = (next = (DTreeItem)subItems.get(i + 1)).getActualMapping())) {
                    EObject currentSem = current.getTarget();
                    EObject nextSem = next.getTarget();
                    EObject contTarget = itemCont.getTarget();
                    ArrayList conTargetContents = Lists.newArrayList((Iterable)Iterables.filter((Iterable)contTarget.eContents(), currentSem.getClass()));
                    int currentSemInd = conTargetContents.indexOf(currentSem);
                    int nextSemInd = conTargetContents.indexOf(nextSem);
                    TreeItemOrderTests.assertEquals((String)"Items order do not follow semantic candidates order.", (int)(currentSemInd + 1), (int)nextSemInd);
                } else {
                    int currentSemInd = subItemMappings.indexOf(currentMapping);
                    int nextSemInd = subItemMappings.indexOf(nextMapping);
                    TreeItemOrderTests.assertEquals((String)"Items order do not follow mapping order", (int)(currentSemInd + 1), (int)nextSemInd);
                }
                this.checkSubItemsOrder((DTreeItemContainer)current, (List<TreeItemMapping>)currentMapping.getAllSubMappings());
                ++i;
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.ctx = null;
        super.tearDown();
    }
}

