/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.p1position;

import java.util.List;
import org.eclipse.elk.alg.radial.InternalProperties;
import org.eclipse.elk.alg.radial.RadialLayoutPhases;
import org.eclipse.elk.alg.radial.RadialUtil;
import org.eclipse.elk.alg.radial.intermediate.optimization.IEvaluation;
import org.eclipse.elk.alg.radial.options.AnnulusWedgeCriteria;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.alg.radial.options.RadialTranslationStrategy;
import org.eclipse.elk.alg.radial.options.SortingStrategy;
import org.eclipse.elk.alg.radial.p1position.wedge.IAnnulusWedgeCriteria;
import org.eclipse.elk.alg.radial.sorting.IRadialSorter;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class EadesRadial
implements ILayoutPhase<RadialLayoutPhases, ElkNode> {
    private static final int CIRCLE_DEGREES = 360;
    private static final double DEGREE_TO_RAD = Math.PI / 180;
    private double radius;
    private IRadialSorter sorter;
    private IAnnulusWedgeCriteria annulusWedgeCriteria;
    private IEvaluation optimizer;
    private ElkNode root;

    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Eades radial", 1.0f);
        progressMonitor.logGraph(graph, "After");
        this.root = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
        this.radius = (Double)graph.getProperty(RadialOptions.RADIUS);
        this.sorter = ((SortingStrategy)((Object)graph.getProperty(RadialOptions.SORTER))).create();
        this.annulusWedgeCriteria = ((AnnulusWedgeCriteria)((Object)graph.getProperty(RadialOptions.WEDGE_CRITERIA))).create();
        this.optimizer = ((RadialTranslationStrategy)((Object)graph.getProperty(RadialOptions.OPTIMIZATION_CRITERIA))).create();
        this.translate(graph);
        progressMonitor.logGraph(graph, "After");
    }

    private void translate(ElkNode graph) {
        double optimalOffset = 0.0;
        double optimalValue = Double.MAX_VALUE;
        if (this.optimizer != null) {
            int i = 0;
            while (i < 360) {
                double offset = (double)i * (Math.PI / 180);
                this.positionNodes(this.root, 0.0, 0.0, Math.PI * 2, offset);
                double translatedValue = this.optimizer.evaluate(this.root);
                if (translatedValue < optimalValue) {
                    optimalOffset = offset;
                    optimalValue = translatedValue;
                }
                ++i;
            }
        }
        this.positionNodes(this.root, 0.0, 0.0, Math.PI * 2, optimalOffset);
    }

    private void positionNodes(ElkNode node, double currentRadius, double minAlpha, double maxAlpha, double optimalOffset) {
        double alpha;
        double s;
        double radOffest = optimalOffset;
        double alphaPoint = (minAlpha + maxAlpha) / 2.0 + radOffest;
        double xPos = currentRadius * Math.cos(alphaPoint);
        double yPos = currentRadius * Math.sin(alphaPoint);
        RadialUtil.centerNodesOnRadi(node, xPos, yPos);
        double numberOfLeafs = this.annulusWedgeCriteria.calculateWedgeSpace(node);
        double tau = 2.0 * Math.acos(currentRadius / currentRadius + this.radius);
        if (tau < maxAlpha - minAlpha) {
            s = tau / numberOfLeafs;
            alpha = (minAlpha + maxAlpha - tau) / 2.0;
        } else {
            s = (maxAlpha - minAlpha) / numberOfLeafs;
            alpha = minAlpha;
        }
        List<ElkNode> successors = RadialUtil.getSuccessors(node);
        if (this.sorter != null) {
            this.sorter.initialize(this.root);
            this.sorter.sort(successors);
        }
        for (ElkNode child : successors) {
            double numberOfChildLeafs = this.annulusWedgeCriteria.calculateWedgeSpace(child);
            this.positionNodes(child, currentRadius + this.radius, alpha, alpha + s * numberOfChildLeafs, optimalOffset);
            alpha += s * numberOfChildLeafs;
        }
    }

    public LayoutProcessorConfiguration<RadialLayoutPhases, ElkNode> getLayoutProcessorConfiguration(ElkNode graph) {
        return null;
    }
}

