/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.tree;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.IMetamodelExtender;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.internal.accessor.ecore.EcoreIntrinsicExtender;
import org.eclipse.sirius.synchronizer.SemanticPartitionInvalidator;
import org.eclipse.sirius.tests.data.GroupRefreshTreeOdesignData;
import org.eclipse.sirius.tests.data.TreeDescriptionGenericEMFTree;
import org.eclipse.sirius.tests.unit.common.TreeCommonTest;
import org.eclipse.sirius.tests.unit.common.TreeEcoreModeler;
import org.eclipse.sirius.tests.unit.diagram.modeler.ecore.EcoreModeler;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.TreeFactory;
import org.eclipse.sirius.tree.business.api.interaction.DTreeUserInteraction;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.DTreeRefresh;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.junit.Assert;
import org.junit.Before;

public class TreeRefreshTests
extends TreeCommonTest
implements EcoreModeler,
TreeEcoreModeler {
    private GlobalContext ctx;
    private SemanticPartitionInvalidator invalidator;
    private GroupRefreshTreeOdesignData odesign;
    private Map<DRepresentation, String> repToName;
    static final String COMPLETE_ECORE_AS_STRING = "\n|-(*)\n  |-EAttribute\n    |-iD\n      |-(*)\n    |-eAttributeType\n      |-(*)\n    |-(*)\n  |-EAnnotation\n    |-source\n      |-(*)\n    |-details\n      |-(*)\n    |-eModelElement\n      |-(*)\n    |-contents\n      |-(*)\n    |-references\n      |-(*)\n    |-(*)\n  |-EClass\n    |-isSuperTypeOf\n      |-(*)\n      |-someClass\n        |-(*)\n    |-getFeatureCount\n      |-(*)\n    |-getEStructuralFeature\n      |-(*)\n      |-featureID\n        |-(*)\n    |-getFeatureID\n      |-(*)\n      |-feature\n        |-(*)\n    |-getEStructuralFeature\n      |-(*)\n      |-featureName\n        |-(*)\n    |-abstract\n      |-(*)\n    |-interface\n      |-(*)\n    |-eSuperTypes\n      |-(*)\n    |-eOperations\n      |-(*)\n    |-eAllAttributes\n      |-(*)\n    |-eAllReferences\n      |-(*)\n    |-eReferences\n      |-(*)\n    |-eAttributes\n      |-(*)\n    |-eAllContainments\n      |-(*)\n    |-eAllOperations\n      |-(*)\n    |-eAllStructuralFeatures\n      |-(*)\n    |-eAllSuperTypes\n      |-(*)\n    |-eIDAttribute\n      |-(*)\n    |-eStructuralFeatures\n      |-(*)\n    |-eGenericSuperTypes\n      |-(*)\n    |-eAllGenericSuperTypes\n      |-(*)\n    |-(*)\n  |-EClassifier\n    |-isInstance\n      |-(*)\n      |-object\n        |-(*)\n    |-getClassifierID\n      |-(*)\n    |-instanceClassName\n      |-(*)\n    |-instanceClass\n      |-(*)\n        |-(*)\n    |-defaultValue\n      |-(*)\n    |-instanceTypeName\n      |-(*)\n    |-ePackage\n      |-(*)\n    |-eTypeParameters\n      |-(*)\n    |-(*)\n  |-EDataType\n    |-serializable\n      |-(*)\n    |-(*)\n  |-EEnum\n    |-getEEnumLiteral\n      |-(*)\n      |-name\n        |-(*)\n    |-getEEnumLiteral\n      |-(*)\n      |-value\n        |-(*)\n    |-getEEnumLiteralByLiteral\n      |-(*)\n      |-literal\n        |-(*)\n    |-eLiterals\n      |-(*)\n    |-(*)\n  |-EEnumLiteral\n    |-value\n      |-(*)\n    |-instance\n      |-(*)\n    |-literal\n      |-(*)\n    |-eEnum\n      |-(*)\n    |-(*)\n  |-EFactory\n    |-create\n      |-(*)\n      |-eClass\n        |-(*)\n    |-createFromString\n      |-(*)\n      |-eDataType\n        |-(*)\n      |-literalValue\n        |-(*)\n    |-convertToString\n      |-(*)\n      |-eDataType\n        |-(*)\n      |-instanceValue\n        |-(*)\n    |-ePackage\n      |-(*)\n    |-(*)\n  |-EModelElement\n    |-getEAnnotation\n      |-(*)\n      |-source\n        |-(*)\n    |-eAnnotations\n      |-(*)\n    |-(*)\n  |-ENamedElement\n    |-name\n      |-(*)\n    |-(*)\n  |-EObject\n    |-eClass\n      |-(*)\n    |-eIsProxy\n      |-(*)\n    |-eResource\n      |-(*)\n    |-eContainer\n      |-(*)\n    |-eContainingFeature\n      |-(*)\n    |-eContainmentFeature\n      |-(*)\n    |-eContents\n      |-(*)\n        |-(*)\n    |-eAllContents\n      |-(*)\n        |-(*)\n    |-eCrossReferences\n      |-(*)\n        |-(*)\n    |-eGet\n      |-(*)\n      |-feature\n        |-(*)\n    |-eGet\n      |-(*)\n      |-feature\n        |-(*)\n      |-resolve\n        |-(*)\n    |-eSet\n      |-feature\n        |-(*)\n      |-newValue\n        |-(*)\n    |-eIsSet\n      |-(*)\n      |-feature\n        |-(*)\n    |-eUnset\n      |-feature\n        |-(*)\n  |-EOperation\n    |-eContainingClass\n      |-(*)\n    |-eTypeParameters\n      |-(*)\n    |-eParameters\n      |-(*)\n    |-eExceptions\n      |-(*)\n    |-eGenericExceptions\n      |-(*)\n    |-(*)\n  |-EPackage\n    |-getEClassifier\n      |-(*)\n      |-name\n        |-(*)\n    |-nsURI\n      |-(*)\n    |-nsPrefix\n      |-(*)\n    |-eFactoryInstance\n      |-(*)\n    |-eClassifiers\n      |-(*)\n    |-eSubpackages\n      |-(*)\n    |-eSuperPackage\n      |-(*)\n    |-(*)\n  |-EParameter\n    |-eOperation\n      |-(*)\n    |-(*)\n  |-EReference\n    |-containment\n      |-(*)\n    |-container\n      |-(*)\n    |-resolveProxies\n      |-(*)\n    |-eOpposite\n      |-(*)\n    |-eReferenceType\n      |-(*)\n    |-eKeys\n      |-(*)\n    |-(*)\n  |-EStructuralFeature\n    |-getFeatureID\n      |-(*)\n    |-getContainerClass\n      |-(*)\n        |-(*)\n    |-changeable\n      |-(*)\n    |-volatile\n      |-(*)\n    |-transient\n      |-(*)\n    |-defaultValueLiteral\n      |-(*)\n    |-defaultValue\n      |-(*)\n    |-unsettable\n      |-(*)\n    |-derived\n      |-(*)\n    |-eContainingClass\n      |-(*)\n    |-(*)\n  |-ETypedElement\n    |-ordered\n      |-(*)\n    |-unique\n      |-(*)\n    |-lowerBound\n      |-(*)\n    |-upperBound\n      |-(*)\n    |-many\n      |-(*)\n    |-required\n      |-(*)\n    |-eType\n      |-(*)\n    |-eGenericType\n      |-(*)\n    |-(*)\n  |-EStringToStringMapEntry\n    |-key\n      |-(*)\n    |-value\n      |-(*)\n  |-EGenericType\n    |-eUpperBound\n      |-(*)\n    |-eTypeArguments\n      |-(*)\n    |-eRawType\n      |-(*)\n    |-eLowerBound\n      |-(*)\n    |-eTypeParameter\n      |-(*)\n    |-eClassifier\n      |-(*)\n    |-(*)\n  |-ETypeParameter\n    |-eBounds\n      |-(*)\n    |-(*)\n  |-EBigDecimal\n    |-(*)\n      |-(*)\n  |-EBigInteger\n    |-(*)\n      |-(*)\n  |-EBoolean\n    |-(*)\n      |-(*)\n  |-EBooleanObject\n    |-(*)\n      |-(*)\n      |-(*)\n  |-EByte\n    |-(*)\n      |-(*)\n  |-EByteArray\n    |-(*)\n      |-(*)\n  |-EByteObject\n    |-(*)\n      |-(*)\n      |-(*)\n  |-EChar\n  |-ECharacterObject\n    |-(*)\n      |-(*)\n      |-(*)\n  |-EDate\n  |-EDiagnosticChain\n  |-EDouble\n    |-(*)\n      |-(*)\n  |-EDoubleObject\n    |-(*)\n      |-(*)\n      |-(*)\n  |-EEList\n    |-E\n  |-EEnumerator\n  |-EFeatureMap\n  |-EFeatureMapEntry\n  |-EFloat\n    |-(*)\n      |-(*)\n  |-EFloatObject\n    |-(*)\n      |-(*)\n      |-(*)\n  |-EInt\n    |-(*)\n      |-(*)\n  |-EIntegerObject\n    |-(*)\n      |-(*)\n      |-(*)\n  |-EJavaClass\n    |-T\n  |-EJavaObject\n  |-ELong\n    |-(*)\n      |-(*)\n  |-ELongObject\n    |-(*)\n      |-(*)\n      |-(*)\n  |-EMap\n    |-K\n    |-V\n  |-EResource\n  |-EResourceSet\n  |-EShort\n    |-(*)\n      |-(*)\n  |-EShortObject\n    |-(*)\n      |-(*)\n      |-(*)\n  |-EString\n    |-(*)\n      |-(*)\n  |-ETreeIterator\n    |-E";

    @Override
    @Before
    public void setUp() throws Exception {
        this.invalidator = new SemanticPartitionInvalidator();
        this.odesign = new GroupRefreshTreeOdesignData();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.odesign.loadFromPlugin();
        } else {
            this.odesign.createStandaloneInstance();
        }
        ResourceSetImpl set = new ResourceSetImpl();
        ModelAccessor accessor = new ModelAccessor();
        accessor.addExtender((IMetamodelExtender)new EcoreIntrinsicExtender(), 0);
        accessor.init((ResourceSet)set);
        IInterpreter interpreter = CompoundInterpreter.createGenericInterpreter();
        this.ctx = new GlobalContext(accessor, interpreter, null);
        this.initLoggers();
        this.setWarningCatchActive(true);
        this.repToName = new HashMap<DRepresentation, String>();
    }

    public void testWarningLoggingWithIncorrectSemanticCandidateExpression() {
        EPackage semanticModel = EcoreFactory.eINSTANCE.createEPackage();
        semanticModel.setName("testModel");
        DTree newTree = TreeFactory.eINSTANCE.createDTree();
        newTree.setTarget((EObject)semanticModel);
        newTree.setDescription(this.odesign.group().design().epackagecontent().object());
        ArrayList mappings = Lists.newArrayList((Iterator)Iterators.filter((Iterator)this.odesign.group().design().epackagecontent().object().eAllContents(), TreeItemMapping.class));
        Assert.assertFalse((boolean)this.doesAWarningOccurs());
        ((TreeItemMapping)mappings.get(0)).setSemanticCandidatesExpression("aql:incorrectExpression");
        DTreeRefresh refresher = new DTreeRefresh((DTreeItemContainer)newTree, (Iterable)mappings, this.invalidator, this.ctx);
        refresher.refresh(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)1L, (long)this.warnings.size());
        Assert.assertTrue((boolean)(((IStatus)((List)this.warnings.get("org.eclipse.core.runtime")).iterator().next()).getException() instanceof EvaluationException));
        this.clearWarnings();
    }

    public void testOrderMatchesTheModelOrder() throws Exception {
        EPackage semanticModel = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        TreeDescriptionGenericEMFTree representation = this.odesign.group().design().genericemftree();
        DTree firstTree = TreeFactory.eINSTANCE.createDTree();
        firstTree.setTarget((EObject)semanticModel);
        firstTree.setDescription(representation.object());
        new DTreeUserInteraction(firstTree, this.ctx).refreshContent((IProgressMonitor)new NullProgressMonitor());
        Iterator itTree = firstTree.getOwnedTreeItems().iterator();
        for (EObject semantic : semanticModel.eContents()) {
            Assert.assertSame((Object)semantic, (Object)((DTreeItem)itTree.next()).getTarget());
        }
    }

    public void testSwitchMappingInHierarchy() throws Exception {
        EPackage semanticModel = EcoreFactory.eINSTANCE.createEPackage();
        semanticModel.setName("testModel");
        EClass namedElement = EcoreFactory.eINSTANCE.createEClass();
        namedElement.setName("ENamedElement");
        namedElement.setAbstract(true);
        semanticModel.getEClassifiers().add((Object)namedElement);
        DTree newTree = TreeFactory.eINSTANCE.createDTree();
        this.repToName.put((DRepresentation)newTree, "(*)");
        newTree.setTarget((EObject)semanticModel);
        newTree.setDescription(this.odesign.group().design().epackagecontent().object());
        ArrayList mappings = Lists.newArrayList((Iterator)Iterators.filter((Iterator)this.odesign.group().design().epackagecontent().object().eAllContents(), TreeItemMapping.class));
        DTreeRefresh refresher = new DTreeRefresh((DTreeItemContainer)newTree, (Iterable)mappings, this.invalidator, this.ctx);
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        String before = this.toString((DTreeItemContainer)newTree);
        Assert.assertEquals((Object)"\n|-(*)\n  |-*ENamedElement", (Object)before);
        Assert.assertTrue((before.indexOf("*ENamedElement") != -1 ? 1 : 0) != 0);
        ((EClass)semanticModel.getEClassifier("ENamedElement")).setAbstract(false);
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        String after = this.toString((DTreeItemContainer)newTree);
        Assert.assertFalse((after.indexOf("*ENamedElement") != -1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"\n|-(*)\n  |-ENamedElement", (Object)after);
    }

    public void testOrderKeptOnSubsequentRefreshes() throws Exception {
        EPackage semanticModel = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        DTree newTree = TreeFactory.eINSTANCE.createDTree();
        this.repToName.put((DRepresentation)newTree, "ENamedElement");
        newTree.setTarget((EObject)semanticModel);
        newTree.setDescription(this.odesign.group().design().epackagecontent().object());
        DTreeUserInteraction interaction = new DTreeUserInteraction(newTree, this.ctx);
        interaction.refreshContent((IProgressMonitor)new NullProgressMonitor()).expandAll();
        String before = this.toString((DTreeItemContainer)newTree);
        interaction.refreshContent((IProgressMonitor)new NullProgressMonitor());
        String after = this.toString((DTreeItemContainer)newTree);
        Assert.assertEquals((Object)before, (Object)after);
    }

    public void testDeleteElement() throws Exception {
        EPackage semanticModel = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        DTree newTree = TreeFactory.eINSTANCE.createDTree();
        this.repToName.put((DRepresentation)newTree, "ENamedElement");
        newTree.setTarget((EObject)semanticModel);
        newTree.setDescription(this.odesign.group().design().epackagecontent().object());
        ArrayList mappings = Lists.newArrayList((Iterator)Iterators.filter((Iterator)this.odesign.group().design().epackagecontent().object().eAllContents(), TreeItemMapping.class));
        DTreeRefresh refresher = new DTreeRefresh((DTreeItemContainer)newTree, (Iterable)mappings, this.invalidator, this.ctx);
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        EcoreUtil.delete((EObject)semanticModel.getEClassifier("EModelElement"));
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        String afterDelete = this.toString((DTreeItemContainer)newTree);
        Assert.assertFalse((afterDelete.indexOf("EModelElement") != -1 ? 1 : 0) != 0);
    }

    public void testCreateElement() throws Exception {
        EPackage semanticModel = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        DTree newTree = TreeFactory.eINSTANCE.createDTree();
        this.repToName.put((DRepresentation)newTree, "ENamedElement");
        newTree.setTarget((EObject)semanticModel);
        newTree.setDescription(this.odesign.group().design().epackagecontent().object());
        ArrayList mappings = Lists.newArrayList((Iterator)Iterators.filter((Iterator)this.odesign.group().design().epackagecontent().object().eAllContents(), TreeItemMapping.class));
        DTreeRefresh refresher = new DTreeRefresh((DTreeItemContainer)newTree, (Iterable)mappings, this.invalidator, this.ctx);
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        String initialState = this.toString((DTreeItemContainer)newTree);
        String[] tabInitialState = initialState.split("\n");
        int numberOfEModelElement = 0;
        int i = 0;
        while (i <= tabInitialState.length - 1) {
            if (tabInitialState[i].equals("  |-*EModelElement")) {
                ++numberOfEModelElement;
            }
            ++i;
        }
        TreeRefreshTests.assertEquals((String)"We should have only one Abstract EModelElement instance.", (int)1, (int)numberOfEModelElement);
        semanticModel.getEClassifiers().add((Object)((EClassifier)EcoreUtil.copy((EObject)semanticModel.getEClassifier("EModelElement"))));
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        String afterCreate = this.toString((DTreeItemContainer)newTree);
        String[] tabAfterCreate = afterCreate.split("\n");
        int numberOfEModelElementAfterDuplication = 0;
        int i2 = 0;
        while (i2 <= tabAfterCreate.length - 1) {
            if (tabAfterCreate[i2].equals("  |-*EModelElement")) {
                ++numberOfEModelElementAfterDuplication;
            }
            ++i2;
        }
        TreeRefreshTests.assertEquals((String)"We should have one more Abstract EModelElement instance after duplication.", (int)(numberOfEModelElement + 1), (int)numberOfEModelElementAfterDuplication);
    }

    public void testRenameElement() throws Exception {
        EPackage semanticModel = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        DTree newTree = TreeFactory.eINSTANCE.createDTree();
        this.repToName.put((DRepresentation)newTree, "ENamedElement");
        newTree.setTarget((EObject)semanticModel);
        newTree.setDescription(this.odesign.group().design().epackagecontent().object());
        ArrayList mappings = Lists.newArrayList((Iterator)Iterators.filter((Iterator)this.odesign.group().design().epackagecontent().object().eAllContents(), TreeItemMapping.class));
        DTreeRefresh refresher = new DTreeRefresh((DTreeItemContainer)newTree, (Iterable)mappings, this.invalidator, this.ctx);
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        semanticModel.getEClassifier("EModelElement").setName("RenamedElement");
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        String afterRename = this.toString((DTreeItemContainer)newTree);
        Assert.assertFalse((afterRename.indexOf("EModelElement") != -1 ? 1 : 0) != 0);
    }

    public void testRefreshBoundedToExpansionState() throws Exception {
        EPackage semanticModel = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        DTree newTree = TreeFactory.eINSTANCE.createDTree();
        newTree.setTarget((EObject)semanticModel);
        TreeDescription specification = this.odesign.group().design().genericemftree().object();
        newTree.setDescription(specification);
        ArrayList mappings = Lists.newArrayList((Iterator)Iterators.filter((Iterator)specification.eAllContents(), TreeItemMapping.class));
        DTreeRefresh refresher = new DTreeRefresh((DTreeItemContainer)newTree, (Iterable)mappings, this.invalidator, this.ctx);
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        ((DTreeItem)newTree.getOwnedTreeItems().get(0)).setExpanded(true);
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        ((DTreeItem)((DTreeItem)newTree.getOwnedTreeItems().get(0)).getOwnedTreeItems().get(0)).setExpanded(true);
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
    }

    private String toString(DTreeItemContainer newTree) {
        return new ToStringueur(newTree, 0).toString();
    }

    public void testSynchronizationSemanticElementsMappgings() {
        EPackage semanticModel = (EPackage)EcoreUtil.create((EClass)EcorePackage.eINSTANCE.getEPackage());
        EClass subClass1 = (EClass)EcoreUtil.create((EClass)EcorePackage.eINSTANCE.getEClass());
        subClass1.setName("EClass1");
        EClass subClass2 = (EClass)EcoreUtil.create((EClass)EcorePackage.eINSTANCE.getEClass());
        subClass2.setName("EClass2");
        semanticModel.getEClassifiers().add((Object)subClass1);
        semanticModel.getEClassifiers().add((Object)subClass2);
        DTree newTree = TreeFactory.eINSTANCE.createDTree();
        newTree.setTarget((EObject)semanticModel);
        newTree.setDescription(this.odesign.group().design().genericemftree().object());
        ArrayList mappings = Lists.newArrayList((Iterator)Iterators.filter((Iterator)this.odesign.group().design().genericemftree().object().eAllContents(), TreeItemMapping.class));
        DTreeRefresh refresher = new DTreeRefresh((DTreeItemContainer)newTree, (Iterable)mappings, this.invalidator, this.ctx);
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        EList ownedTreeItems = newTree.getOwnedTreeItems();
        TreeRefreshTests.assertEquals((String)"EClass1", (String)((DTreeItem)ownedTreeItems.get(0)).getName());
        TreeRefreshTests.assertEquals((String)"EClass2", (String)((DTreeItem)ownedTreeItems.get(1)).getName());
        semanticModel.getEClassifiers().move(0, 1);
        refresher.refresh((IProgressMonitor)new NullProgressMonitor());
        TreeRefreshTests.assertEquals((String)"EClass2", (String)((DTreeItem)ownedTreeItems.get(0)).getName());
        TreeRefreshTests.assertEquals((String)"EClass1", (String)((DTreeItem)ownedTreeItems.get(1)).getName());
    }

    public void _testGnericEMFTreeCollapseAll() throws Exception {
        EPackage semanticModel = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        DTree newTree = TreeFactory.eINSTANCE.createDTree();
        newTree.setTarget((EObject)semanticModel);
        TreeDescriptionGenericEMFTree representation = this.odesign.group().design().genericemftree();
        newTree.setDescription(representation.object());
        new DTreeUserInteraction(newTree, this.ctx).refreshContent((IProgressMonitor)new NullProgressMonitor()).expandAll();
        String after = this.toString((DTreeItemContainer)newTree);
        Assert.assertEquals((Object)COMPLETE_ECORE_AS_STRING, (Object)after);
    }

    public void testOrderIsDeterministicAmongRepresentationInstances() throws Exception {
        EPackage semanticModel = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        TreeDescriptionGenericEMFTree representation = this.odesign.group().design().genericemftree();
        DTree firstTree = TreeFactory.eINSTANCE.createDTree();
        firstTree.setTarget((EObject)semanticModel);
        firstTree.setDescription(representation.object());
        DTree secondTree = TreeFactory.eINSTANCE.createDTree();
        secondTree.setTarget((EObject)semanticModel);
        secondTree.setDescription(representation.object());
        new DTreeUserInteraction(firstTree, this.ctx).refreshContent((IProgressMonitor)new NullProgressMonitor()).expand();
        new DTreeUserInteraction(secondTree, this.ctx).refreshContent((IProgressMonitor)new NullProgressMonitor()).expand();
        String first = this.toString((DTreeItemContainer)firstTree);
        String after = this.toString((DTreeItemContainer)secondTree);
        Assert.assertEquals((Object)first, (Object)after);
    }

    class ToStringueur {
        private DTreeItemContainer current;
        private String label;
        private int index;

        public ToStringueur(DTreeItemContainer current, int currentIndex) {
            this.current = current;
            this.index = currentIndex;
            if (current instanceof DTree) {
                this.label = TreeRefreshTests.this.repToName.get(current);
            } else if (current instanceof DTreeItem) {
                this.label = ((DTreeItem)current).getName();
            }
            if (StringUtil.isEmpty((String)this.label)) {
                this.label = "(*)";
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("\n");
            int i = 0;
            while (i < this.index) {
                builder.append(" ");
                ++i;
            }
            builder.append("|-");
            builder.append(this.label);
            int newIndex = this.index + 2;
            if (this.current instanceof DTreeItem) {
                if (((DTreeItem)this.current).isExpanded()) {
                    this.generateChildrenText(builder, newIndex);
                }
            } else if (this.current instanceof DTree) {
                this.generateChildrenText(builder, newIndex);
            }
            return builder.toString();
        }

        private void generateChildrenText(StringBuilder builder, int newIndex) {
            for (DTreeItem item : this.current.getOwnedTreeItems()) {
                builder.append(new ToStringueur((DTreeItemContainer)item, newIndex));
            }
        }
    }
}

