/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.quickfix;

import java.util.Optional;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.diagram.tools.internal.validation.constraints.ImagePathWrappingStatus;
import org.eclipse.sirius.diagram.ui.internal.quickfix.AbstractValidationFix;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.ui.IEditorPart;

public class ImageMarkerRemoveResolution
extends AbstractValidationFix {
    public String getLabel() {
        return Messages.ImageMarkerRemove_label;
    }

    @Override
    protected void doExecuteFix(IMarker marker, IEditorPart editor, View markedView, Session session) {
        TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
        String imageIssueKind = marker.getAttribute("IMAGE_PATH_TARGET_KEY", "");
        String imagePath = marker.getAttribute("IMAGE_PATH", null);
        boolean exists = FileProvider.getDefault().exists((IPath)new Path(imagePath), (Object)session);
        EObject target = markedView.getElement();
        Diagram gmfDiagram = markedView.getDiagram();
        EObject diagramTarget = gmfDiagram.getElement();
        if (!exists) {
            boolean fixSucceeded = false;
            if (ImagePathWrappingStatus.ImagePathTarget.DREPRESENTATION_DESCRIPTOR.toString().equals(imageIssueKind)) {
                String featurename = marker.getAttribute("IMAGE_PATH_FEATURE", "");
                fixSucceeded = ImageMarkerRemoveResolution.removeImagePathInRichText(target, featurename, imagePath, transactionalEditingDomain);
            } else if (ImagePathWrappingStatus.ImagePathTarget.SEMANTIC_TARGET.toString().equals(imageIssueKind) && markedView.getElement() instanceof DSemanticDecorator) {
                String featurename = marker.getAttribute("IMAGE_PATH_FEATURE", "");
                fixSucceeded = ImageMarkerRemoveResolution.removeImagePathInRichText(target, featurename, imagePath, transactionalEditingDomain);
            } else if (ImagePathWrappingStatus.ImagePathTarget.WORKSPACE_IMAGE.toString().equals(imageIssueKind) && diagramTarget instanceof DDiagram) {
                DDiagram dDiagram = (DDiagram)diagramTarget;
                DialectUIManager.INSTANCE.openEditor(session, (DRepresentation)dDiagram, (IProgressMonitor)new NullProgressMonitor());
                fixSucceeded = ImageMarkerRemoveResolution.removeImageInDiagram(dDiagram, (DDiagramElement)target, transactionalEditingDomain);
            }
            if (fixSucceeded) {
                this.revalidate(editor, (View)gmfDiagram);
            }
        } else {
            this.revalidate(editor, (View)gmfDiagram);
        }
    }

    public static boolean removeImagePathInRichText(final EObject eObject, String featurename, String imagePath, TransactionalEditingDomain ted) {
        EAttribute eAttribute;
        Object stringObj;
        boolean fixSucceeded = false;
        Optional<EAttribute> eAttributeOpt = eObject.eClass().getEAllAttributes().stream().filter(attr -> featurename.equals(attr.getName())).findFirst();
        if (eAttributeOpt.isPresent() && (stringObj = eObject.eGet((EStructuralFeature)(eAttribute = eAttributeOpt.get()))) instanceof String) {
            final String htmlText = (String)stringObj;
            final String imgRegex = "<img\\s+[^>]*?src\\s*=\\s*(\"|')" + imagePath + "(\"|')[^>]*?>";
            ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                protected void doExecute() {
                    String newHtmlText = htmlText.replaceAll(imgRegex, "");
                    eObject.eSet((EStructuralFeature)eAttribute, (Object)newHtmlText);
                }
            });
            fixSucceeded = true;
        }
        return fixSucceeded;
    }

    public static boolean removeImageInDiagram(final DDiagram dDiagram, final DDiagramElement target, TransactionalEditingDomain ted) {
        RepresentationElementMapping mapping = target.getMapping();
        EObject parentElement = target.eContainer();
        Style targetStyle = target.getStyle();
        if (mapping instanceof DiagramElementMapping && parentElement instanceof DSemanticDecorator && targetStyle instanceof WorkspaceImage) {
            final DiagramElementMapping diagramMapping = (DiagramElementMapping)mapping;
            DSemanticDecorator parentDiagramElement = (DSemanticDecorator)parentElement;
            final EObject parentObject = parentDiagramElement.getTarget();
            final WorkspaceImage currentStyle = (WorkspaceImage)targetStyle;
            RecordingCommand command = new RecordingCommand(ted){

                protected void doExecute() {
                    IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)dDiagram);
                    MappingWithInterpreterHelper mappingHelper = new MappingWithInterpreterHelper(interpreter);
                    StyleHelper styleHelper = new StyleHelper(interpreter);
                    if (currentStyle.getDescription() instanceof WorkspaceImageDescription) {
                        WorkspaceImageDescription styleDescription = (WorkspaceImageDescription)currentStyle.getDescription();
                        currentStyle.setWorkspacePath(styleDescription.getWorkspacePath());
                    } else {
                        Style newStyle = mappingHelper.getBestStyle(diagramMapping, target.getTarget(), (EObject)target, parentObject, dDiagram);
                        EList currentStyleFeatures = DiagramPackage.eINSTANCE.getWorkspaceImage().getEAllStructuralFeatures();
                        EList newStyleFeatures = newStyle.eClass().getEAllStructuralFeatures();
                        currentStyleFeatures.stream().filter(feature -> feature != DiagramPackage.eINSTANCE.getWorkspaceImage_WorkspacePath()).filter(arg_0 -> newStyleFeatures.contains(arg_0)).forEach(feature -> newStyle.eSet(feature, currentStyle.eGet(feature)));
                        styleHelper.setAndRefreshStyle(target, null, newStyle);
                    }
                }
            };
            ted.getCommandStack().execute((Command)command);
            return true;
        }
        return false;
    }
}

