/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.options;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.elk.core.options.Direction;

public enum PortSide {
    UNDEFINED,
    NORTH,
    EAST,
    SOUTH,
    WEST;

    public static final Set<PortSide> SIDES_NONE;
    public static final Set<PortSide> SIDES_NORTH;
    public static final Set<PortSide> SIDES_EAST;
    public static final Set<PortSide> SIDES_SOUTH;
    public static final Set<PortSide> SIDES_WEST;
    public static final Set<PortSide> SIDES_NORTH_SOUTH;
    public static final Set<PortSide> SIDES_EAST_WEST;
    public static final Set<PortSide> SIDES_NORTH_WEST;
    public static final Set<PortSide> SIDES_NORTH_EAST;
    public static final Set<PortSide> SIDES_SOUTH_WEST;
    public static final Set<PortSide> SIDES_EAST_SOUTH;
    public static final Set<PortSide> SIDES_NORTH_EAST_WEST;
    public static final Set<PortSide> SIDES_EAST_SOUTH_WEST;
    public static final Set<PortSide> SIDES_NORTH_SOUTH_WEST;
    public static final Set<PortSide> SIDES_NORTH_EAST_SOUTH;
    public static final Set<PortSide> SIDES_NORTH_EAST_SOUTH_WEST;

    static {
        SIDES_NONE = Collections.unmodifiableSet(EnumSet.noneOf(PortSide.class));
        SIDES_NORTH = Sets.immutableEnumSet((Enum)NORTH, (Enum[])new PortSide[0]);
        SIDES_EAST = Sets.immutableEnumSet((Enum)EAST, (Enum[])new PortSide[0]);
        SIDES_SOUTH = Sets.immutableEnumSet((Enum)SOUTH, (Enum[])new PortSide[0]);
        SIDES_WEST = Sets.immutableEnumSet((Enum)WEST, (Enum[])new PortSide[0]);
        SIDES_NORTH_SOUTH = Sets.immutableEnumSet((Enum)NORTH, (Enum[])new PortSide[]{SOUTH});
        SIDES_EAST_WEST = Sets.immutableEnumSet((Enum)EAST, (Enum[])new PortSide[]{WEST});
        SIDES_NORTH_WEST = Sets.immutableEnumSet((Enum)NORTH, (Enum[])new PortSide[]{WEST});
        SIDES_NORTH_EAST = Sets.immutableEnumSet((Enum)NORTH, (Enum[])new PortSide[]{EAST});
        SIDES_SOUTH_WEST = Sets.immutableEnumSet((Enum)SOUTH, (Enum[])new PortSide[]{WEST});
        SIDES_EAST_SOUTH = Sets.immutableEnumSet((Enum)EAST, (Enum[])new PortSide[]{SOUTH});
        SIDES_NORTH_EAST_WEST = Sets.immutableEnumSet((Enum)NORTH, (Enum[])new PortSide[]{EAST, WEST});
        SIDES_EAST_SOUTH_WEST = Sets.immutableEnumSet((Enum)EAST, (Enum[])new PortSide[]{SOUTH, WEST});
        SIDES_NORTH_SOUTH_WEST = Sets.immutableEnumSet((Enum)NORTH, (Enum[])new PortSide[]{SOUTH, WEST});
        SIDES_NORTH_EAST_SOUTH = Sets.immutableEnumSet((Enum)NORTH, (Enum[])new PortSide[]{EAST, SOUTH});
        SIDES_NORTH_EAST_SOUTH_WEST = Sets.immutableEnumSet((Enum)NORTH, (Enum[])new PortSide[]{EAST, SOUTH, WEST});
    }

    public PortSide right() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        return UNDEFINED;
    }

    public PortSide left() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        return UNDEFINED;
    }

    public PortSide opposed() {
        switch (this) {
            case NORTH: {
                return SOUTH;
            }
            case EAST: {
                return WEST;
            }
            case SOUTH: {
                return NORTH;
            }
            case WEST: {
                return EAST;
            }
        }
        return UNDEFINED;
    }

    public boolean areAdjacent(PortSide other) {
        if (this == UNDEFINED) {
            return false;
        }
        return this.left() == other || this.right() == other;
    }

    public static PortSide fromDirection(Direction direction) {
        switch (direction) {
            case UP: {
                return NORTH;
            }
            case RIGHT: {
                return EAST;
            }
            case DOWN: {
                return SOUTH;
            }
            case LEFT: {
                return WEST;
            }
        }
        return UNDEFINED;
    }
}

