/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.math.DoubleMath;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public final class ElkSpacings {
    private ElkSpacings() {
    }

    public static ElkCoreSpacingsBuilder withBaseValue(double baseSpacing) {
        return new ElkCoreSpacingsBuilder(baseSpacing);
    }

    public static abstract class AbstractSpacingsBuilder<T extends AbstractSpacingsBuilder<T>> {
        public static final LayoutConfigurator.IPropertyHolderOptionFilter ELK_OPTION_TARGET_FILTER = (holder, property) -> {
            if (property instanceof ElkGraphElement) {
                return LayoutConfigurator.OPTION_TARGET_FILTER.accept((ElkGraphElement)holder, property);
            }
            return true;
        };
        protected static final double DOUBLE_EQ_EPSILON = 1.0E-4;
        private final double baseSpacing;
        private boolean overwrite = false;
        private List<LayoutConfigurator.IPropertyHolderOptionFilter> filters = Lists.newArrayList((Object[])new LayoutConfigurator.IPropertyHolderOptionFilter[]{ELK_OPTION_TARGET_FILTER});
        private Map<IProperty<Double>, Double> factorMap = Maps.newHashMap();

        protected AbstractSpacingsBuilder(double theBaseSpacing) {
            this.baseSpacing = theBaseSpacing;
            this.factorMap.put(this.getBaseSpacingOption(), 1.0);
            this.getDependendSpacingOptions().forEach(option -> {
                double factor = this.getBaseSpacingOption().getDefault() != null && option.getDefault() != null ? (Double)option.getDefault() / (Double)this.getBaseSpacingOption().getDefault() : 1.0;
                this.factorMap.put((IProperty<Double>)option, factor);
            });
        }

        protected abstract IProperty<Double> getBaseSpacingOption();

        protected abstract Iterable<IProperty<Double>> getDependendSpacingOptions();

        protected List<LayoutConfigurator.IPropertyHolderOptionFilter> getFilters() {
            return this.filters;
        }

        protected abstract T thisT();

        protected double computeFactor(double value) {
            return value / this.baseSpacing;
        }

        public Map<IProperty<Double>, Double> getFactors() {
            return ImmutableMap.copyOf(this.factorMap);
        }

        public T withFactor(IProperty<Double> spacingOption, double factor) {
            if (!this.factorMap.keySet().contains(spacingOption)) {
                throw new IllegalArgumentException("'" + spacingOption.getId() + "' is not a configurable spacing option.");
            }
            if (factor < 0.0) {
                throw new IllegalArgumentException("The factor for '" + spacingOption.getId() + "' must not be negative (" + factor + ").");
            }
            if (spacingOption.getId().equals(this.getBaseSpacingOption().getId())) {
                throw new IllegalArgumentException("'" + spacingOption.getId() + "' is the base spacing option not allowed to use with 'withFactor'.");
            }
            this.factorMap.put(spacingOption, factor);
            return this.thisT();
        }

        public T withValue(IProperty<Double> spacingOption, double value) {
            if (!this.factorMap.keySet().contains(spacingOption)) {
                throw new IllegalArgumentException("'" + spacingOption.getId() + "' is not a configurable spacing option.");
            }
            if (value < 0.0) {
                throw new IllegalArgumentException("The value for '" + spacingOption.getId() + "' must not be negative (" + value + ").");
            }
            if (spacingOption.getId().equals(this.getBaseSpacingOption().getId())) {
                throw new IllegalArgumentException("'" + spacingOption.getId() + "' is the base spacing option not allowed to use with 'withValue'.");
            }
            this.factorMap.put(spacingOption, this.computeFactor(value));
            return this.thisT();
        }

        public T withOverwrite(boolean shallOverwrite) {
            this.overwrite = shallOverwrite;
            return this.thisT();
        }

        public Consumer<IPropertyHolder> build() {
            if (!this.overwrite) {
                this.filters.add(LayoutConfigurator.NO_OVERWRITE_HOLDER);
            }
            if (!this.overwrite && DoubleMath.fuzzyEquals((double)this.baseSpacing, (double)((Double)this.getBaseSpacingOption().getDefault()), (double)1.0E-4)) {
                return e -> {};
            }
            return element -> this.factorMap.keySet().stream().filter(p -> this.filters.stream().allMatch(filter -> filter.accept((IPropertyHolder)element, (IProperty<?>)p))).forEach(p -> element.setProperty(p, (Object)(this.factorMap.get(p) * this.baseSpacing)));
        }

        public void apply(IPropertyHolder holder) {
            this.build().accept(holder);
        }

        public IGraphElementVisitor toVisitor() {
            Consumer<IPropertyHolder> consumer = this.build();
            return e -> consumer.accept((IPropertyHolder)e);
        }
    }

    public static final class ElkCoreSpacingsBuilder
    extends AbstractSpacingsBuilder<ElkCoreSpacingsBuilder> {
        public static final IProperty<Double> BASE_SPACING_OPTION = CoreOptions.SPACING_NODE_NODE;
        private static final List<IProperty<Double>> DEPENDENT_SPACING_OPTIONS = Lists.newArrayList((Object[])new IProperty[]{CoreOptions.SPACING_COMPONENT_COMPONENT, CoreOptions.SPACING_EDGE_EDGE, CoreOptions.SPACING_EDGE_LABEL, CoreOptions.SPACING_EDGE_NODE, CoreOptions.SPACING_LABEL_LABEL, CoreOptions.SPACING_LABEL_NODE, CoreOptions.SPACING_LABEL_PORT, CoreOptions.SPACING_NODE_SELF_LOOP, CoreOptions.SPACING_PORT_PORT});

        static {
            assert (BASE_SPACING_OPTION.getDefault() != null) : "Base spacing default value must be non-null.";
            assert (!DoubleMath.fuzzyEquals((double)0.0, (double)((Double)BASE_SPACING_OPTION.getDefault()), (double)1.0E-4)) : "Base spacing default value must be different from 0.0d.";
        }

        private ElkCoreSpacingsBuilder(double baseSpacing) {
            super(baseSpacing);
        }

        @Override
        protected ElkCoreSpacingsBuilder thisT() {
            return this;
        }

        @Override
        protected IProperty<Double> getBaseSpacingOption() {
            return BASE_SPACING_OPTION;
        }

        @Override
        protected Iterable<IProperty<Double>> getDependendSpacingOptions() {
            return DEPENDENT_SPACING_OPTIONS;
        }
    }
}

