/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.AbstractCopyPasteFormatAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;
import org.eclipse.sirius.diagram.ui.tools.internal.format.data.extension.FormatDataManagerRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class CopyFormatAction
extends AbstractCopyPasteFormatAction {
    public CopyFormatAction(IWorkbenchPage workbenchPage, IWorkbenchPart actionWorkbenchPart) {
        super(workbenchPage, actionWorkbenchPart);
        this.setText(Messages.CopyFormatAction_text);
        this.setAccelerator(458819);
        this.setId("copyFormatAction");
        this.setToolTipText(Messages.CopyFormatAction_toolTipText_diagramElements);
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/copyFormat.gif"));
        this.setDisabledImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/copyFormatDisabled.gif"));
        this.setHoverImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/copyFormat.gif"));
    }

    public CopyFormatAction(IWorkbenchPage workbenchPage) {
        this(workbenchPage, null);
    }

    @Override
    protected boolean isReadOnlyAction() {
        return true;
    }

    protected String getCommandLabel() {
        return Messages.CopyFormatAction_commandLabel;
    }

    protected Command getCommand() {
        Option<DDiagram> diagram;
        CompoundCommand doStoreFormatsCmd = new CompoundCommand(Messages.CopyFormatAction_storeFormatCommandLabel);
        doStoreFormatsCmd.add(new Command(Messages.CopyFormatAction_clearPreviousFormatDateCommandLabel){

            public boolean canUndo() {
                return false;
            }

            public void execute() {
                for (SiriusFormatDataManager formatDataManager : FormatDataManagerRegistry.getAllSiriusFormatDataManagers()) {
                    formatDataManager.clearFormatData();
                }
            }
        });
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        if (diagramEditPart instanceof IDDiagramEditPart && (diagram = ((IDDiagramEditPart)diagramEditPart).resolveDDiagram()).some()) {
            List<IGraphicalEditPart> selectedEditParts = this.cleanSelectedObjects(this.getSelectedObjects());
            for (IGraphicalEditPart toStore : selectedEditParts) {
                doStoreFormatsCmd.add((Command)new ICommandProxy((ICommand)new CopyFormatDataCommand(toStore.getEditingDomain(), (DDiagram)diagram.get(), toStore)));
            }
        }
        doStoreFormatsCmd.add(new Command(Messages.CopyFormatAction_notifyEditors){

            public boolean canUndo() {
                return false;
            }

            public void execute() {
                IEditorReference[] editorReferences = null;
                IWorkbenchPage page = EclipseUIUtil.getActivePage();
                if (page != null) {
                    editorReferences = page.getEditorReferences();
                }
                if (editorReferences != null) {
                    IEditorReference[] iEditorReferenceArray = editorReferences;
                    int n = editorReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DDiagramEditorImpl diagramEditor;
                        IEditorReference ref = iEditorReferenceArray[n2];
                        IEditorPart editor = ref.getEditor(false);
                        if (editor instanceof DDiagramEditorImpl && (diagramEditor = (DDiagramEditorImpl)editor).getTabbar() != null) {
                            diagramEditor.getTabbar().reinitToolBar(diagramEditor.getDiagramGraphicalViewer().getSelection());
                        }
                        ++n2;
                    }
                }
            }
        });
        return doStoreFormatsCmd.unwrap();
    }

    @Override
    protected String getToolTipForDiagramSelection() {
        return Messages.CopyFormatAction_toolTipText_diagram;
    }

    @Override
    protected String getToolTipForDiagramElementsSelection() {
        return Messages.CopyFormatAction_toolTipText_diagramElements;
    }

    private List<IGraphicalEditPart> cleanSelectedObjects(List<?> selectedObjects) {
        ArrayList<IGraphicalEditPart> result = new ArrayList<IGraphicalEditPart>();
        HashSet selection = new HashSet(selectedObjects);
        for (Object selectedObject : selection) {
            boolean isLabelOfSelectedParent;
            boolean bl = isLabelOfSelectedParent = selectedObject instanceof IDiagramNameEditPart && selection.contains(((IDiagramNameEditPart)selectedObject).getParent());
            if (isLabelOfSelectedParent) continue;
            result.add((IGraphicalEditPart)selectedObject);
        }
        return result;
    }

    private static final class CopyFormatDataCommand
    extends AbstractTransactionalCommand {
        private IGraphicalEditPart toStore;
        private DDiagram dDiagram;

        CopyFormatDataCommand(TransactionalEditingDomain domain, DDiagram dDiagram, IGraphicalEditPart editPartToStore) {
            super(domain, Messages.CopyFormatDataCommand_label, null);
            this.dDiagram = dDiagram;
            this.toStore = editPartToStore;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            for (SiriusFormatDataManager formatDataManager : FormatDataManagerRegistry.getSiriusFormatDataManagers(this.dDiagram)) {
                formatDataManager.storeFormatData(this.toStore);
            }
            return CommandResult.newOKCommandResult();
        }

        protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            for (SiriusFormatDataManager formatDataManager : FormatDataManagerRegistry.getSiriusFormatDataManagers(this.dDiagram)) {
                formatDataManager.clearFormatData();
            }
            return super.doUndo(monitor, info);
        }
    }
}

